/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.features;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.core.util.Base64;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.multipart.MultiPart;
import com.sun.jersey.multipart.impl.MultiPartWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.context.ContextHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

public class HTTPHelper
implements ContextHelper {
    protected static volatile ObjectMapper mapper = new ObjectMapper();
    private static final Integer TIMEOUT = 300000;
    private static final String HTTP_CONTENT_DISPOSITION = "Content-Disposition";

    public Blob call(String username, String password, String requestType, String path) throws IOException {
        return this.call(username, password, requestType, path, null, null, null, null);
    }

    public Blob call(String username, String password, String requestType, String path, Map<String, String> headers) throws IOException {
        return this.call(username, password, requestType, path, null, null, null, headers);
    }

    public Blob call(String username, String password, String requestType, String path, MultiPart mp) throws IOException {
        return this.call(username, password, requestType, path, null, null, mp, null);
    }

    public Blob call(String username, String password, String requestType, String path, MultiPart mp, Map<String, String> headers) throws IOException {
        return this.call(username, password, requestType, path, null, null, mp, headers);
    }

    public Blob call(String username, String password, String requestType, String path, MultivaluedMap<String, String> queryParams) throws IOException {
        return this.call(username, password, requestType, path, null, queryParams, null, null);
    }

    public Blob call(String username, String password, String requestType, String path, Object data) throws IOException {
        return this.call(username, password, requestType, path, data, null, null, null);
    }

    public Blob call(String username, String password, String requestType, String path, Object data, Map<String, String> headers) throws IOException {
        return this.call(username, password, requestType, path, data, null, null, headers);
    }

    public Blob call(String username, String password, String requestType, String url, Object data, MultivaluedMap<String, String> queryParams, MultiPart mp, Map<String, String> headers) throws IOException {
        ClientResponse response;
        DefaultClientConfig config = new DefaultClientConfig();
        config.getClasses().add(MultiPartWriter.class);
        Client client = Client.create((ClientConfig)config);
        client.setConnectTimeout(TIMEOUT);
        client.setReadTimeout(TIMEOUT);
        if (username != null && password != null) {
            client.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, password));
        }
        WebResource wr = client.resource(url);
        if (queryParams != null && !queryParams.isEmpty()) {
            wr = wr.queryParams(queryParams);
        }
        WebResource.Builder builder = wr.accept(new String[]{"application/json"});
        if (mp != null) {
            builder = wr.type(MediaType.MULTIPART_FORM_DATA_TYPE);
        }
        if (headers != null && !headers.isEmpty()) {
            for (String headerKey : headers.keySet()) {
                builder.header(headerKey, (Object)headers.get(headerKey));
            }
        }
        try {
            switch (requestType) {
                case "HEAD": 
                case "GET": {
                    response = (ClientResponse)builder.get(ClientResponse.class);
                    break;
                }
                case "POST": {
                    if (mp != null) {
                        response = (ClientResponse)builder.post(ClientResponse.class, (Object)mp);
                        break;
                    }
                    response = (ClientResponse)builder.post(ClientResponse.class, data);
                    break;
                }
                case "PUT": {
                    if (mp != null) {
                        response = (ClientResponse)builder.put(ClientResponse.class, (Object)mp);
                        break;
                    }
                    response = (ClientResponse)builder.put(ClientResponse.class, data);
                    break;
                }
                case "DELETE": {
                    response = (ClientResponse)builder.delete(ClientResponse.class, data);
                    break;
                }
                default: {
                    throw new NuxeoException("Unknown request type: " + requestType);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (response.getStatus() >= 200 && response.getStatus() < 300) {
            return Blobs.createBlob((InputStream)response.getEntityInputStream());
        }
        return new StringBlob(response.getStatusInfo() != null ? response.getStatusInfo().toString() : "error");
    }

    public Blob get(String url, Map<String, Object> options) throws IOException {
        return this.invoke("GET", url, null, null, options);
    }

    public Blob post(String url, Object data, Map<String, Object> options) throws IOException {
        return this.invoke("POST", url, data, null, options);
    }

    public Blob post(String url, MultiPart multiPart, Map<String, Object> options) throws IOException {
        return this.invoke("POST", url, null, multiPart, options);
    }

    public Blob put(String url, Object data, Map<String, Object> options) throws IOException {
        return this.invoke("PUT", url, data, null, options);
    }

    public Blob put(String url, MultiPart multiPart, Map<String, Object> options) throws IOException {
        return this.invoke("PUT", url, null, multiPart, options);
    }

    public Blob delete(String url, Object data, Map<String, Object> options) throws IOException {
        return this.invoke("DELETE", url, data, null, options);
    }

    private Blob invoke(String requestType, String url, Object data, MultiPart multipart, Map<String, Object> options) throws IOException {
        ClientResponse response;
        MultivaluedMap<String, String> queryParams = this.getQueryParameters(options);
        Map<String, String> headers = this.getHeaderParameters(options);
        DefaultClientConfig config = new DefaultClientConfig();
        config.getClasses().add(MultiPartWriter.class);
        Client client = Client.create((ClientConfig)config);
        client.setConnectTimeout(TIMEOUT);
        WebResource wr = client.resource(url);
        if (queryParams != null && !queryParams.isEmpty()) {
            wr = wr.queryParams(queryParams);
        }
        WebResource.Builder builder = wr.accept(new String[]{"application/json"});
        if (multipart != null) {
            builder = wr.type(MediaType.MULTIPART_FORM_DATA_TYPE);
        }
        if (headers != null && !headers.isEmpty()) {
            for (String headerKey : headers.keySet()) {
                builder.header(headerKey, (Object)headers.get(headerKey));
            }
        }
        try {
            switch (requestType) {
                case "HEAD": 
                case "GET": {
                    response = (ClientResponse)builder.get(ClientResponse.class);
                    break;
                }
                case "POST": {
                    if (multipart != null) {
                        response = (ClientResponse)builder.post(ClientResponse.class, (Object)multipart);
                        break;
                    }
                    response = (ClientResponse)builder.post(ClientResponse.class, data);
                    break;
                }
                case "PUT": {
                    if (multipart != null) {
                        response = (ClientResponse)builder.put(ClientResponse.class, (Object)multipart);
                        break;
                    }
                    response = (ClientResponse)builder.put(ClientResponse.class, data);
                    break;
                }
                case "DELETE": {
                    response = (ClientResponse)builder.delete(ClientResponse.class, data);
                    break;
                }
                default: {
                    throw new NuxeoException("Unknown request type: " + requestType);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (response.getStatus() >= 200 && response.getStatus() < 300) {
            return this.setUpBlob(response, url);
        }
        return new StringBlob(response.getStatusInfo() != null ? response.getStatusInfo().toString() : "error");
    }

    private Map<String, String> getHeaderParameters(Map<String, Object> options) {
        if (options != null) {
            Map headersOptions;
            HashMap<String, String> headers = new HashMap<String, String>();
            Map authorization = (Map)options.get("auth");
            if (authorization != null) {
                String method;
                switch (method = (String)authorization.get("method")) {
                    case "basic": {
                        Map<String, String> header = this.basicAuthentication((String)authorization.get("username"), (String)authorization.get("password"));
                        headers.putAll(header);
                        break;
                    }
                }
            }
            if ((headersOptions = (Map)options.get("headers")) != null) {
                headers.putAll(headersOptions);
            }
            return headers;
        }
        return null;
    }

    private MultivaluedMap<String, String> getQueryParameters(Map<String, Object> options) {
        Map params;
        if (options != null && (params = (Map)options.get("params")) != null) {
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            for (String key : params.keySet()) {
                queryParams.put((Object)key, params.get(key));
            }
            return queryParams;
        }
        return null;
    }

    private Blob setUpBlob(ClientResponse response, String url) throws IOException {
        MediaType contentType;
        String encoding;
        MultivaluedMap headers = response.getHeaders();
        String disposition = (String)headers.getFirst((Object)HTTP_CONTENT_DISPOSITION);
        String filename = "";
        if (disposition != null) {
            int index = disposition.indexOf("filename=");
            if (index > -1) {
                filename = disposition.substring(index + 9);
            }
        } else {
            filename = url.substring(url.lastIndexOf("/") + 1, url.length());
        }
        Blob resultBlob = Blobs.createBlob((InputStream)response.getEntityInputStream());
        if (!StringUtils.isEmpty((CharSequence)filename)) {
            resultBlob.setFilename(filename);
        }
        if ((encoding = (String)headers.getFirst((Object)"Content-Encoding")) != null) {
            resultBlob.setEncoding(encoding);
        }
        if ((contentType = response.getType()) != null) {
            resultBlob.setMimeType(contentType.getType());
        }
        return resultBlob;
    }

    private Map<String, String> basicAuthentication(String username, String password) {
        HashMap<String, String> authenticationHeader;
        if (username == null || password == null) {
            return null;
        }
        try {
            byte[] prefix = (username + ":").getBytes(Charset.forName("iso-8859-1"));
            byte[] usernamePassword = new byte[prefix.length + password.getBytes().length];
            System.arraycopy(prefix, 0, usernamePassword, 0, prefix.length);
            System.arraycopy(password.getBytes(), 0, usernamePassword, prefix.length, password.getBytes().length);
            String authentication = "Basic " + new String(Base64.encode((byte[])usernamePassword), "ASCII");
            authenticationHeader = new HashMap<String, String>();
            authenticationHeader.put("Authorization", authentication);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return authenticationHeader;
    }
}

