/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.codec.NoCodec;
import org.nuxeo.lib.stream.computation.ComputationPolicy;
import org.nuxeo.lib.stream.computation.Record;

public class Settings {
    protected final int defaultConcurrency;
    protected final int defaultPartitions;
    protected final Codec<Record> defaultCodec;
    protected final ComputationPolicy defaultPolicy;
    protected final Map<String, Integer> concurrencies = new HashMap<String, Integer>();
    protected final Map<String, Integer> partitions = new HashMap<String, Integer>();
    protected final Map<String, Codec<Record>> codecs = new HashMap<String, Codec<Record>>();
    protected final Map<String, ComputationPolicy> policies = new HashMap<String, ComputationPolicy>();

    public Settings(int defaultConcurrency, int defaultPartitions) {
        this(defaultConcurrency, defaultPartitions, null, null);
    }

    public Settings(int defaultConcurrency, int defaultPartitions, Codec<Record> defaultCodec) {
        this(defaultConcurrency, defaultPartitions, defaultCodec, null);
    }

    public Settings(int defaultConcurrency, int defaultPartitions, ComputationPolicy defaultPolicy) {
        this(defaultConcurrency, defaultPartitions, null, defaultPolicy);
    }

    public Settings(int defaultConcurrency, int defaultPartitions, Codec<Record> defaultCodec, ComputationPolicy defaultPolicy) {
        this.defaultConcurrency = defaultConcurrency;
        this.defaultPartitions = defaultPartitions;
        this.defaultCodec = defaultCodec == null ? NoCodec.NO_CODEC : defaultCodec;
        this.defaultPolicy = defaultPolicy == null ? ComputationPolicy.NONE : defaultPolicy;
    }

    public Settings setConcurrency(String computationName, int concurrency) {
        this.concurrencies.put(computationName, concurrency);
        return this;
    }

    public int getConcurrency(String computationName) {
        return this.concurrencies.getOrDefault(computationName, this.defaultConcurrency);
    }

    public Settings setPartitions(String streamName, int partitions) {
        this.partitions.put(streamName, partitions);
        return this;
    }

    public int getPartitions(String streamName) {
        return this.partitions.getOrDefault(streamName, this.defaultPartitions);
    }

    public Settings setCodec(String streamName, Codec<Record> codec) {
        Objects.requireNonNull(codec);
        this.codecs.put(streamName, codec);
        return this;
    }

    public Codec<Record> getCodec(String streamName) {
        return this.codecs.getOrDefault(streamName, this.defaultCodec);
    }

    public Settings setPolicy(String computationName, ComputationPolicy policy) {
        if (policy == null) {
            this.policies.remove(computationName);
        } else {
            this.policies.put(computationName, policy);
        }
        return this;
    }

    public ComputationPolicy getPolicy(String computationName) {
        return this.policies.getOrDefault(computationName, this.defaultPolicy);
    }
}

