/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation.log;

import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.SyncFailsafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.Computation;
import org.nuxeo.lib.stream.computation.ComputationMetadataMapping;
import org.nuxeo.lib.stream.computation.ComputationPolicy;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Watermark;
import org.nuxeo.lib.stream.computation.internals.ComputationContextImpl;
import org.nuxeo.lib.stream.computation.internals.WatermarkMonotonicInterval;
import org.nuxeo.lib.stream.log.LogAppender;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.LogRecord;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.RebalanceException;
import org.nuxeo.lib.stream.log.RebalanceListener;

public class ComputationRunner
implements Runnable,
RebalanceListener {
    public static final Duration READ_TIMEOUT = Duration.ofMillis(25L);
    protected static final long STARVING_TIMEOUT_MS = 1000L;
    protected static final long INACTIVITY_BREAK_MS = 100L;
    private static final Log log = LogFactory.getLog(ComputationRunner.class);
    protected final LogManager logManager;
    protected final ComputationMetadataMapping metadata;
    protected final LogTailer<Record> tailer;
    protected final Supplier<Computation> supplier;
    protected final CountDownLatch assignmentLatch = new CountDownLatch(1);
    protected final WatermarkMonotonicInterval lowWatermark = new WatermarkMonotonicInterval();
    protected final Codec<Record> inputCodec;
    protected final Codec<Record> outputCodec;
    protected final ComputationPolicy policy;
    protected ComputationContextImpl context;
    protected volatile boolean stop;
    protected volatile boolean drain;
    protected Computation computation;
    protected long counter;
    protected long inRecords;
    protected long inCheckpointRecords;
    protected long outRecords;
    protected long lastReadTime = System.currentTimeMillis();
    protected long lastTimerExecution;
    protected String threadName;

    public ComputationRunner(Supplier<Computation> supplier, ComputationMetadataMapping metadata, List<LogPartition> defaultAssignment, LogManager logManager, Codec<Record> inputCodec, Codec<Record> outputCodec, ComputationPolicy policy) {
        this.supplier = supplier;
        this.metadata = metadata;
        this.logManager = logManager;
        this.context = new ComputationContextImpl(logManager, metadata, policy);
        this.inputCodec = inputCodec;
        this.outputCodec = outputCodec;
        this.policy = policy;
        if (metadata.inputStreams().isEmpty()) {
            this.tailer = null;
            this.assignmentLatch.countDown();
        } else if (logManager.supportSubscribe()) {
            this.tailer = logManager.subscribe(metadata.name(), metadata.inputStreams(), this, inputCodec);
        } else {
            this.tailer = logManager.createTailer(metadata.name(), defaultAssignment, inputCodec);
            this.assignmentLatch.countDown();
        }
    }

    public void stop() {
        log.debug((Object)(this.metadata.name() + ": Receives Stop signal"));
        this.stop = true;
        if (this.computation != null) {
            this.computation.signalStop();
        }
    }

    public void drain() {
        log.debug((Object)(this.metadata.name() + ": Receives Drain signal"));
        this.drain = true;
    }

    public boolean waitForAssignments(Duration timeout) throws InterruptedException {
        if (!this.assignmentLatch.await(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
            log.warn((Object)(this.metadata.name() + ": Timeout waiting for assignment"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block20: {
            this.threadName = Thread.currentThread().getName();
            boolean interrupted = false;
            this.computation = this.supplier.get();
            log.debug((Object)(this.metadata.name() + ": Init"));
            try {
                this.computation.init(this.context);
                log.debug((Object)(this.metadata.name() + ": Start"));
                this.processLoop();
            }
            catch (InterruptedException e) {
                interrupted = true;
                String msg = this.metadata.name() + ": Interrupted";
                if (log.isTraceEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                } else {
                    log.debug((Object)msg);
                }
            }
            catch (Exception e) {
                if (Thread.currentThread().isInterrupted()) {
                    log.info((Object)(this.metadata.name() + ": Interrupted"), (Throwable)e);
                    break block20;
                }
                log.error((Object)(this.metadata.name() + ": Exception in processLoop: " + e.getMessage()), (Throwable)e);
                throw e;
            }
            finally {
                try {
                    this.computation.destroy();
                    this.closeTailer();
                    log.debug((Object)(this.metadata.name() + ": Exited"));
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    protected void closeTailer() {
        if (this.tailer != null && !this.tailer.closed()) {
            this.tailer.close();
        }
    }

    protected void processLoop() throws InterruptedException {
        while (this.continueLoop()) {
            boolean activity = this.processTimer();
            ++this.counter;
            if (activity |= this.processRecord()) continue;
            Thread.sleep(100L);
        }
    }

    protected boolean continueLoop() {
        if (this.stop || Thread.currentThread().isInterrupted()) {
            return false;
        }
        if (this.drain) {
            long now = System.currentTimeMillis();
            if (this.metadata.inputStreams().isEmpty()) {
                if (this.lastTimerExecution > 0L && now - this.lastTimerExecution > 1000L) {
                    log.info((Object)(this.metadata.name() + ": End of source drain, last timer " + 1000L + " ms ago"));
                    return false;
                }
            } else if (now - this.lastReadTime > 1000L) {
                log.info((Object)(this.metadata.name() + ": End of drain no more input after " + (now - this.lastReadTime) + " ms, " + this.inRecords + " records read, " + this.counter + " reads attempt"));
                return false;
            }
        }
        return true;
    }

    protected boolean processTimer() {
        Map<String, Long> timers = this.context.getTimers();
        if (timers.isEmpty()) {
            return false;
        }
        if (this.tailer != null && this.tailer.assignments().isEmpty()) {
            return false;
        }
        long now = System.currentTimeMillis();
        boolean[] timerUpdate = new boolean[]{false};
        LinkedHashMap sortedTimer = timers.entrySet().stream().filter(entry -> (Long)entry.getValue() <= now).sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        sortedTimer.forEach((key, value) -> {
            this.context.removeTimer((String)key);
            this.processTimerWithRetry((String)key, (Long)value);
            timerUpdate[0] = true;
        });
        if (timerUpdate[0]) {
            this.checkSourceLowWatermark();
            this.lastTimerExecution = now;
            this.setThreadName("timer");
            this.checkpointIfNecessary();
            if (this.context.requireTerminate()) {
                this.stop = true;
            }
            return true;
        }
        return false;
    }

    protected void processTimerWithRetry(String key, Long value) {
        ((SyncFailsafe)((SyncFailsafe)((SyncFailsafe)Failsafe.with((RetryPolicy)this.policy.getRetryPolicy()).onRetry(failure -> this.computation.processRetry(this.context, (Throwable)failure))).onFailure(failure -> this.computation.processFailure(this.context, (Throwable)failure))).withFallback(() -> this.processFallback(this.context))).run(() -> this.computation.processTimer(this.context, key, value));
    }

    protected boolean processRecord() throws InterruptedException {
        if (this.context.requireTerminate()) {
            this.stop = true;
            return true;
        }
        if (this.tailer == null) {
            return false;
        }
        Duration timeoutRead = this.getTimeoutDuration();
        LogRecord<Record> logRecord = null;
        try {
            logRecord = this.tailer.read(timeoutRead);
        }
        catch (RebalanceException rebalanceException) {
            // empty catch block
        }
        if (logRecord != null) {
            Record record = logRecord.message();
            this.lastReadTime = System.currentTimeMillis();
            ++this.inRecords;
            this.lowWatermark.mark(record.getWatermark());
            String from = this.metadata.reverseMap(logRecord.offset().partition().name());
            this.context.setLastOffset(logRecord.offset());
            this.processRecordWithRetry(from, record);
            this.checkRecordFlags(record);
            this.checkSourceLowWatermark();
            this.setThreadName("record");
            this.checkpointIfNecessary();
            return true;
        }
        return false;
    }

    protected void processRecordWithRetry(String from, Record record) {
        ((SyncFailsafe)((SyncFailsafe)((SyncFailsafe)Failsafe.with((RetryPolicy)this.policy.getRetryPolicy()).onRetry(failure -> this.computation.processRetry(this.context, (Throwable)failure))).onFailure(failure -> this.computation.processFailure(this.context, (Throwable)failure))).withFallback(() -> this.processFallback(this.context))).run(() -> this.computation.processRecord(this.context, from, record));
    }

    protected void processFallback(ComputationContextImpl context) {
        if (this.policy.continueOnFailure()) {
            log.error((Object)String.format("Skip record after failure: %s", context.getLastOffset()));
            context.askForCheckpoint();
        } else {
            log.error((Object)String.format("Terminate computation: %s due to previous failure", this.metadata.name()));
            context.cancelAskForCheckpoint();
            context.askForTermination();
        }
    }

    protected Duration getTimeoutDuration() {
        return Duration.ofMillis(Math.min(READ_TIMEOUT.toMillis(), System.currentTimeMillis() - this.lastReadTime));
    }

    protected void checkSourceLowWatermark() {
        long watermark = this.context.getSourceLowWatermark();
        if (watermark > 0L) {
            this.lowWatermark.mark(Watermark.ofValue(watermark));
            this.context.setSourceLowWatermark(0L);
        }
    }

    protected void checkRecordFlags(Record record) {
        if (record.getFlags().contains((Object)Record.Flag.POISON_PILL)) {
            log.info((Object)(this.metadata.name() + ": Receive POISON PILL"));
            this.context.askForCheckpoint();
            this.stop = true;
        } else if (record.getFlags().contains((Object)Record.Flag.COMMIT)) {
            this.context.askForCheckpoint();
        }
    }

    protected void checkpointIfNecessary() {
        if (this.context.requireCheckpoint()) {
            boolean completed = false;
            try {
                this.checkpoint();
                completed = true;
            }
            finally {
                if (!completed) {
                    log.error((Object)(this.metadata.name() + ": CHECKPOINT FAILURE: Resume may create duplicates."));
                }
            }
        }
    }

    protected void checkpoint() {
        this.sendRecords();
        this.saveTimers();
        this.saveState();
        this.saveOffsets();
        this.lowWatermark.checkpoint();
        this.context.removeCheckpointFlag();
        log.debug((Object)(this.metadata.name() + ": checkpoint"));
        this.inCheckpointRecords = this.inRecords;
        this.setThreadName("checkpoint");
    }

    protected void saveTimers() {
    }

    protected void saveState() {
    }

    protected void saveOffsets() {
        if (this.tailer != null) {
            this.tailer.commit();
        }
    }

    protected void sendRecords() {
        for (String stream : this.metadata.outputStreams()) {
            LogAppender<Record> appender = this.logManager.getAppender(stream, this.outputCodec);
            for (Record record : this.context.getRecords(stream)) {
                if (record.getWatermark() == 0L) {
                    record.setWatermark(this.lowWatermark.getLow().getValue());
                }
                appender.append(record.getKey(), record);
                ++this.outRecords;
            }
            this.context.getRecords(stream).clear();
        }
    }

    public Watermark getLowWatermark() {
        return this.lowWatermark.getLow();
    }

    protected void setThreadName(String message) {
        String name = this.threadName + ",in:" + this.inRecords + ",inCheckpoint:" + this.inCheckpointRecords + ",out:" + this.outRecords + ",lastRead:" + this.lastReadTime + ",lastTimer:" + this.lastTimerExecution + ",wm:" + this.lowWatermark.getLow().getValue() + ",loop:" + this.counter;
        if (message != null) {
            name = name + "," + message;
        }
        Thread.currentThread().setName(name);
    }

    @Override
    public void onPartitionsRevoked(Collection<LogPartition> partitions) {
        this.setThreadName("rebalance revoked");
    }

    @Override
    public void onPartitionsAssigned(Collection<LogPartition> partitions) {
        this.lastReadTime = System.currentTimeMillis();
        this.setThreadName("rebalance assigned");
        this.context = new ComputationContextImpl(this.logManager, this.metadata, this.policy);
        log.debug((Object)(this.metadata.name() + ": Init"));
        this.computation.init(this.context);
        this.lastReadTime = System.currentTimeMillis();
        this.lastTimerExecution = 0L;
        this.assignmentLatch.countDown();
    }
}

