/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteSender;
import com.codahale.metrics.graphite.GraphiteUDP;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.log.Latency;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.internals.LogPartitionGroup;
import org.nuxeo.lib.stream.tools.command.LatencyTrackerComputation;

public class LatencyMonitorComputation
extends LatencyTrackerComputation {
    private static final Log log = LogFactory.getLog(LatencyMonitorComputation.class);
    protected final String host;
    protected final int port;
    protected final boolean udp;
    protected final String basePrefix;
    protected GraphiteSender graphite;

    public LatencyMonitorComputation(LogManager manager, List<String> logNames, String host, int port, boolean udp, String basePrefix, String computationName, int intervalSecond, int count, boolean verbose, Codec<Record> codec) {
        super(manager, logNames, computationName, intervalSecond, count, verbose, codec);
        this.host = host;
        this.port = port;
        this.udp = udp;
        this.basePrefix = basePrefix;
    }

    @Override
    public void init(ComputationContext context) {
        super.init(context);
        this.graphite = this.udp ? new GraphiteUDP(this.host, this.port) : new Graphite(this.host, this.port);
        try {
            this.graphite.connect();
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to connect to " + this.host + ":" + this.port, e);
        }
    }

    @Override
    protected void processLatencies(ComputationContext context, LogPartitionGroup logGroup, List<Latency> latencies) {
        Latency groupLatency = Latency.of(latencies);
        this.publishMetrics(groupLatency, String.format("%s%s.%s.all.", this.basePrefix, logGroup.group, logGroup.name));
        for (int partition = 0; partition < latencies.size(); ++partition) {
            this.publishMetrics(latencies.get(partition), String.format("%s%s.%s.p%02d.", this.basePrefix, logGroup.group, logGroup.name, partition));
        }
    }

    protected void publishMetrics(Latency latency, String prefix) {
        if (this.verbose) {
            log.info((Object)latency.toString());
        }
        long metricTime = latency.upper() / 1000L;
        try {
            this.graphite.send(prefix + "lag", Long.toString(latency.lag().lag()), metricTime);
            this.graphite.send(prefix + "end", Long.toString(latency.lag().upper()), metricTime);
            this.graphite.send(prefix + "pos", Long.toString(latency.lag().lower()), metricTime);
            this.graphite.send(prefix + "latency", Long.toString(latency.latency()), metricTime);
        }
        catch (IOException e) {
            log.error((Object)("Fail to send metric to graphite " + prefix + " " + latency), (Throwable)e);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.graphite != null) {
            try {
                this.graphite.close();
            }
            catch (IOException e) {
                log.debug((Object)"Error when closing graphite socket: ", (Throwable)e);
            }
        }
        this.graphite = null;
    }
}

