/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.comment.api.Comment;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractCommentManager
implements CommentManager {
    private static final Log log = LogFactory.getLog(AbstractCommentManager.class);
    protected static final String COMMENTS_DIRECTORY = "Comments";

    public List<DocumentModel> getComments(DocumentModel docModel) {
        return this.getComments(docModel.getCoreSession(), docModel);
    }

    public List<DocumentModel> getComments(DocumentModel docModel, DocumentModel parent) {
        return this.getComments(docModel);
    }

    public List<Comment> getComments(CoreSession session, String documentId) {
        return this.getComments(session, documentId, 0L, 0L, true);
    }

    public List<Comment> getComments(CoreSession session, String documentId, boolean sortAscending) {
        return this.getComments(session, documentId, 0L, 0L, sortAscending);
    }

    public PartialList<Comment> getComments(CoreSession session, String documentId, Long pageSize, Long currentPageIndex) {
        return this.getComments(session, documentId, pageSize, currentPageIndex, true);
    }

    protected void notifyEvent(CoreSession session, String eventType, DocumentModel commentedDoc, DocumentModel comment) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        NuxeoPrincipal principal = null;
        if (userManager != null && (principal = userManager.getPrincipal((String)((Object)comment.getPropertyValue("comment:author")))) == null) {
            try {
                principal = this.getAuthor(comment);
            }
            catch (PropertyException e) {
                log.error((Object)"Error building principal for comment author", (Throwable)e);
                return;
            }
        }
        DocumentEventContext ctx = new DocumentEventContext(session, principal, commentedDoc);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("parentComment", commentedDoc);
        props.put("comment_document", comment);
        props.put("comment", (String)comment.getProperty("comment", "text"));
        props.put("comment_text", (String)comment.getProperty("comment", "text"));
        props.put("category", "commentCategory");
        ctx.setProperties(props);
        Event event = ctx.newEvent(eventType);
        EventProducer evtProducer = (EventProducer)Framework.getService(EventProducer.class);
        evtProducer.fireEvent(event);
    }

    protected NuxeoPrincipal getAuthor(DocumentModel docModel) {
        String[] contributors = (String[])docModel.getProperty("dublincore", "contributors");
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        return userManager.getPrincipal(contributors[0]);
    }

    protected void setFolderPermissions(CoreSession session, DocumentModel documentModel) {
        ACPImpl acp = new ACPImpl();
        ACE grantAddChildren = new ACE("members", "AddChildren", true);
        ACE grantRemoveChildren = new ACE("members", "RemoveChildren", true);
        ACE grantRemove = new ACE("members", "Remove", true);
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{grantAddChildren, grantRemoveChildren, grantRemove});
        acp.addACL((ACL)acl);
        session.setACP(documentModel.getRef(), (ACP)acp, true);
    }

    protected void setCommentPermissions(CoreSession session, DocumentModel documentModel) {
        ACPImpl acp = new ACPImpl();
        ACE grantRead = new ACE("Everyone", "Read", true);
        ACE grantRemove = new ACE("members", "Remove", true);
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{grantRead, grantRemove});
        acp.addACL((ACL)acl);
        session.setACP(documentModel.getRef(), (ACP)acp, true);
    }

    protected Collection<String> computeAncestorIds(CoreSession session, String parentId) {
        HashSet<String> ancestorIds = new HashSet<String>();
        ancestorIds.add(parentId);
        IdRef parentRef = new IdRef(parentId);
        while (session.exists((DocumentRef)parentRef) && session.getDocument((DocumentRef)parentRef).hasSchema("comment")) {
            parentId = (String)((Object)session.getDocument((DocumentRef)parentRef).getPropertyValue("comment:parentId"));
            ancestorIds.add(parentId);
            parentRef = new IdRef(parentId);
        }
        return ancestorIds;
    }
}

