/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Instant;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.comment.api.Comment;
import org.nuxeo.ecm.platform.comment.api.CommentImpl;
import org.nuxeo.ecm.platform.comment.api.ExternalEntity;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class CommentJsonReader
extends EntityJsonReader<Comment> {
    public CommentJsonReader() {
        super("comment");
    }

    protected Comment readEntity(JsonNode jn) {
        CommentImpl comment = new CommentImpl();
        return CommentJsonReader.fillCommentEntity(jn, (Comment)comment);
    }

    protected static Comment fillCommentEntity(JsonNode jn, Comment comment) {
        comment.setParentId(jn.get("parentId").textValue());
        comment.setAuthor(jn.get("author").textValue());
        comment.setText(jn.get("text").textValue());
        JsonNode creationDateNode = jn.get("creationDate");
        Instant creationDate = creationDateNode != null && !creationDateNode.isNull() ? Instant.parse(creationDateNode.textValue()) : null;
        comment.setCreationDate(creationDate);
        JsonNode modificationDateNode = jn.get("modificationDate");
        Instant modificationDate = modificationDateNode != null && !modificationDateNode.isNull() ? Instant.parse(modificationDateNode.textValue()) : null;
        comment.setModificationDate(modificationDate);
        if (jn.has("entityId")) {
            ExternalEntity externalEntity = (ExternalEntity)comment;
            externalEntity.setEntityId(jn.get("entityId").textValue());
            externalEntity.setOrigin(jn.get("origin").textValue());
            externalEntity.setEntity(jn.get("entity").textValue());
        }
        return comment;
    }
}

