/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.migrator.AbstractRepositoryMigrator;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.platform.comment.service.CommentService;
import org.nuxeo.ecm.platform.comment.service.CommentServiceConfig;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.QNameResourceImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.migration.MigrationService;

public class CommentsMigrator
extends AbstractRepositoryMigrator {
    private static final Logger log = LogManager.getLogger(CommentsMigrator.class);
    protected static final int BATCH_SIZE = 50;

    protected String probeSession(CoreSession session) {
        Graph graph;
        CommentService commentComponent = (CommentService)((Object)Framework.getRuntime().getComponent(CommentService.NAME));
        CommentServiceConfig commentServiceConfig = commentComponent.getConfig();
        if (commentServiceConfig != null && (graph = ((RelationManager)Framework.getService(RelationManager.class)).getGraph(commentServiceConfig.graphName, session)).getStatements().size() > 0) {
            return "relation";
        }
        return "property";
    }

    protected void migrateSession(CoreSession session) {
        CommentService commentComponent = (CommentService)((Object)Framework.getRuntime().getComponent(CommentService.NAME));
        CommentServiceConfig commentServiceConfig = commentComponent.getConfig();
        if (commentServiceConfig != null) {
            RelationManager relationManager = (RelationManager)Framework.getService(RelationManager.class);
            Graph graph = relationManager.getGraph(commentServiceConfig.graphName, session);
            List statements = graph.getStatements();
            this.checkShutdownRequested();
            this.processBatched(50, statements, statement -> this.migrateComments(session, relationManager, commentServiceConfig, (Statement)statement), "Migrating comments");
            this.reportProgress("Done", statements.size(), statements.size());
        }
    }

    public String probeState() {
        List repositoryNames = ((RepositoryService)Framework.getService(RepositoryService.class)).getRepositoryNames();
        if (repositoryNames.stream().map(arg_0 -> ((CommentsMigrator)this).probeRepository(arg_0)).anyMatch(Predicate.isEqual("relation"))) {
            return "relation";
        }
        return "property";
    }

    public void run(String step, MigrationService.MigrationContext migrationContext) {
        if (!"relation-to-property".equals(step)) {
            throw new NuxeoException("Unknown migration step: " + step);
        }
        this.migrationContext = migrationContext;
        this.reportProgress("Initializing", 0L, -1L);
        List repositoryNames = ((RepositoryService)Framework.getService(RepositoryService.class)).getRepositoryNames();
        try {
            repositoryNames.forEach(arg_0 -> ((CommentsMigrator)this).migrateRepository(arg_0));
        }
        catch (AbstractRepositoryMigrator.MigrationShutdownException e) {
            return;
        }
    }

    protected void migrateComments(CoreSession session, RelationManager relationManager, CommentServiceConfig config, Statement statement) {
        Map<String, CoreSession> ctxMap = Collections.singletonMap("CoreSession", session);
        QNameResourceImpl object = (QNameResourceImpl)statement.getObject();
        DocumentModel parent = (DocumentModel)relationManager.getResourceRepresentation(config.documentNamespace, (Resource)object, ctxMap);
        QNameResourceImpl subject = (QNameResourceImpl)statement.getSubject();
        DocumentModel comment = (DocumentModel)relationManager.getResourceRepresentation(config.commentNamespace, (Resource)subject, ctxMap);
        if (parent != null && comment != null) {
            comment.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
            comment.setPropertyValue("comment:parentId", (Serializable)((Object)parent.getId()));
            session.saveDocument(comment);
        } else if (parent == null && comment == null) {
            log.debug("Documents {} and {} do not exist, they can not be migrated", (Object)object.getLocalName(), (Object)subject.getLocalName());
        } else {
            log.debug("Document {} does not exist, it can not be migrated", (Object)(parent == null ? object.getLocalName() : subject.getLocalName()));
        }
        Graph graph = relationManager.getGraph(config.graphName, session);
        graph.remove(statement);
    }

    public void notifyStatusChange() {
        CommentService commentComponent = (CommentService)((Object)Framework.getRuntime().getComponent(CommentService.NAME));
        commentComponent.invalidateCommentManagerImplementation();
    }
}

