/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class ForecastJobResponse
extends ActionResponse
implements ToXContentObject {
    public static final ParseField ACKNOWLEDGED = new ParseField("acknowledged", new String[0]);
    public static final ParseField FORECAST_ID = new ParseField("forecast_id", new String[0]);
    public static final ConstructingObjectParser<ForecastJobResponse, Void> PARSER = new ConstructingObjectParser("forecast_job_response", true, a -> new ForecastJobResponse((Boolean)a[0], (String)a[1]));
    private final boolean acknowledged;
    private final String forecastId;

    public static ForecastJobResponse fromXContent(XContentParser parser) throws IOException {
        return (ForecastJobResponse)((Object)PARSER.parse(parser, null));
    }

    public ForecastJobResponse(boolean acknowledged, String forecastId) {
        this.acknowledged = acknowledged;
        this.forecastId = forecastId;
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public String getForecastId() {
        return this.forecastId;
    }

    public int hashCode() {
        return Objects.hash(this.acknowledged, this.forecastId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ForecastJobResponse other = (ForecastJobResponse)((Object)obj);
        return Objects.equals(this.acknowledged, other.acknowledged) && Objects.equals(this.forecastId, other.forecastId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ACKNOWLEDGED.getPreferredName(), this.acknowledged);
        builder.field(FORECAST_ID.getPreferredName(), this.forecastId);
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ACKNOWLEDGED);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FORECAST_ID);
    }
}

