/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.Tree;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.server.support.TypeManager;
import org.apache.chemistry.opencmis.server.support.query.AbstractPredicateWalker;
import org.apache.chemistry.opencmis.server.support.query.CmisQueryWalker;
import org.apache.chemistry.opencmis.server.support.query.CmisSelector;
import org.apache.chemistry.opencmis.server.support.query.ColumnReference;
import org.apache.chemistry.opencmis.server.support.query.FunctionReference;
import org.apache.chemistry.opencmis.server.support.query.PredicateWalkerBase;
import org.apache.chemistry.opencmis.server.support.query.QueryObject;
import org.apache.chemistry.opencmis.server.support.query.QueryUtilStrict;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.trash.TrashService;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoCmisService;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoObjectData;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoPropertyDataBase;
import org.nuxeo.ecm.core.opencmis.impl.util.TypeManagerImpl;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class CMISQLtoNXQL {
    private static final Log log = LogFactory.getLog(CMISQLtoNXQL.class);
    protected static final String CMIS_PREFIX = "cmis:";
    protected static final String NX_PREFIX = "nuxeo:";
    protected static final String NXQL_DOCUMENT = "Document";
    protected static final String NXQL_RELATION = "Relation";
    protected static final String NXQL_DC_TITLE = "dc:title";
    protected static final String NXQL_DC_DESCRIPTION = "dc:description";
    protected static final String NXQL_DC_CREATOR = "dc:creator";
    protected static final String NXQL_DC_CREATED = "dc:created";
    protected static final String NXQL_DC_MODIFIED = "dc:modified";
    protected static final String NXQL_DC_LAST_CONTRIBUTOR = "dc:lastContributor";
    protected static final String NXQL_REL_SOURCE = "relation:source";
    protected static final String NXQL_REL_TARGET = "relation:target";
    protected static final DateTimeFormatter ISO_DATE_TIME_FORMAT = ISODateTimeFormat.dateTime();
    private static final char QUOTE = '\'';
    private static final String SPACE_ASC = " asc";
    private static final String SPACE_DESC = " desc";
    protected static final Set<String> NULL_IS_FALSE_COLUMNS = new HashSet<String>(Arrays.asList("ecm:isVersion", "ecm:isLatestVersion", "ecm:isLatestMajorVersion", "ecm:isCheckedIn"));
    protected final boolean supportsProxies;
    protected Map<String, PropertyDefinition<?>> typeInfo;
    protected CoreSession coreSession;
    protected QueryUtilStrict queryUtil;
    protected QueryObject query;
    protected TypeDefinition fromType;
    protected boolean skipDeleted = true;
    protected Map<String, String> realColumns = new LinkedHashMap<String, String>();
    protected Map<String, ColumnReference> virtualColumns = new LinkedHashMap<String, ColumnReference>();
    protected static final String JOIN = "JOIN";
    protected static final String WHERE = "WHERE";
    protected static final String ORDER_BY = "ORDER BY";

    public CMISQLtoNXQL(boolean supportsProxies) {
        this.supportsProxies = supportsProxies;
    }

    public String getNXQL(String cmisql, NuxeoCmisService service, Map<String, PropertyDefinition<?>> typeInfo, boolean searchAllVersions) throws QueryParseException {
        Tree whereNode;
        String nxqlFrom;
        this.typeInfo = typeInfo;
        boolean searchLatestVersion = !searchAllVersions;
        TypeManagerImpl typeManager = service.getTypeManager();
        this.coreSession = service.coreSession;
        try {
            this.queryUtil = new QueryUtilStrict(cmisql, (TypeManager)typeManager, (PredicateWalkerBase)new AnalyzingWalker(), false);
            this.queryUtil.processStatement();
            this.query = this.queryUtil.getQueryObject();
        }
        catch (RecognitionException e) {
            throw new QueryParseException(this.queryUtil.getErrorMessage(e), (Throwable)e);
        }
        if (this.query.getTypes().size() != 1 && this.query.getJoinedSecondaryTypes() == null) {
            throw new QueryParseException("JOINs not supported in query: " + cmisql);
        }
        this.fromType = this.query.getMainFromName();
        BaseTypeId fromBaseTypeId = this.fromType.getBaseTypeId();
        for (CmisSelector sel : this.query.getSelectReferences()) {
            this.recordSelectSelector(sel);
        }
        for (CmisSelector sel : this.query.getJoinReferences()) {
            ColumnReference col = (ColumnReference)sel;
            if (col.getTypeDefinition().getBaseTypeId() == BaseTypeId.CMIS_SECONDARY) continue;
            this.recordSelector(sel, JOIN);
        }
        for (CmisSelector sel : this.query.getWhereReferences()) {
            this.recordSelector(sel, WHERE);
        }
        for (QueryObject.SortSpec spec : this.query.getOrderBys()) {
            this.recordSelector(spec.getSelector(), ORDER_BY);
        }
        this.addSystemColumns();
        ArrayList<String> whereClauses = new ArrayList<String>();
        String what = StringUtils.join(this.realColumns.values(), (String)", ");
        if (fromBaseTypeId == BaseTypeId.CMIS_RELATIONSHIP) {
            nxqlFrom = this.fromType.getParentTypeId() == null ? NXQL_RELATION : this.fromType.getId();
        } else {
            Object tc;
            nxqlFrom = NXQL_DOCUMENT;
            List<Object> types = new ArrayList<String>();
            if (this.fromType.getParentTypeId() != null) {
                types.add(this.fromType.getId());
            }
            LinkedList<TypeDefinitionContainer> typesTodo = new LinkedList<TypeDefinitionContainer>();
            typesTodo.addAll(typeManager.getTypeDescendants(this.fromType.getId(), -1, Boolean.TRUE));
            while ((tc = (TypeDefinitionContainer)typesTodo.poll()) != null) {
                types.add(tc.getTypeDefinition().getId());
                typesTodo.addAll(tc.getChildren());
            }
            if (types.isEmpty()) {
                types = Collections.singletonList("__NOSUCHTYPE__");
            }
            StringBuilder pt = new StringBuilder();
            pt.append("ecm:primaryType");
            pt.append(" IN (");
            Iterator<Object> it = types.iterator();
            while (it.hasNext()) {
                pt.append('\'');
                pt.append((String)it.next());
                pt.append('\'');
                if (!it.hasNext()) continue;
                pt.append(", ");
            }
            pt.append(")");
            whereClauses.add(pt.toString());
        }
        if (this.skipDeleted) {
            whereClauses.add(String.format("%s = 0", "ecm:isTrashed"));
        }
        if (searchLatestVersion && fromBaseTypeId == BaseTypeId.CMIS_DOCUMENT) {
            whereClauses.add(String.format("%s = 1", "ecm:isLatestVersion"));
        }
        if (!this.supportsProxies) {
            whereClauses.add("ecm:isProxy = 0");
        }
        if ((whereNode = ((CmisQueryWalker)this.queryUtil.getWalker()).getWherePredicateTree()) != null) {
            GeneratingWalker generator = new GeneratingWalker();
            generator.walkPredicate(whereNode);
            whereClauses.add(generator.buf.toString());
        }
        ArrayList<String> orderbys = new ArrayList<String>();
        for (QueryObject.SortSpec spec : this.query.getOrderBys()) {
            CmisSelector sel = spec.getSelector();
            String orderby = sel instanceof ColumnReference ? (String)sel.getInfo() : "ecm:fulltextScore";
            if (!spec.ascending) {
                orderby = orderby + " DESC";
            }
            orderbys.add(orderby);
        }
        String where = StringUtils.join(whereClauses, (String)" AND ");
        String nxql = "SELECT " + what + " FROM " + nxqlFrom + " WHERE " + where;
        if (!orderbys.isEmpty()) {
            nxql = nxql + " ORDER BY " + StringUtils.join(orderbys, (String)", ");
        }
        return nxql;
    }

    public IterableQueryResult getIterableQueryResult(IterableQueryResult it, NuxeoCmisService service) {
        return new NXQLtoCMISIterableQueryResult(it, this.realColumns, this.virtualColumns, service);
    }

    public PartialList<Map<String, Serializable>> convertToCMIS(PartialList<Map<String, Serializable>> pl, NuxeoCmisService service) {
        return pl.stream().map(map -> CMISQLtoNXQL.convertToCMISMap(map, this.realColumns, this.virtualColumns, service)).collect(Collectors.collectingAndThen(Collectors.toList(), result -> new PartialList(result, pl.totalSize())));
    }

    protected boolean isFacetsColumn(String name) {
        return "cmis:secondaryObjectTypeIds".equals(name) || "nuxeo:secondaryObjectTypeIds".equals(name);
    }

    protected void addSystemColumns() {
        for (String propertyId : Arrays.asList("cmis:objectId", "cmis:objectTypeId")) {
            if (this.realColumns.containsKey(propertyId)) continue;
            ColumnReference col = new ColumnReference(propertyId);
            col.setTypeDefinition(propertyId, this.fromType);
            this.recordSelectSelector((CmisSelector)col);
        }
    }

    protected void recordSelectSelector(CmisSelector sel) {
        if (sel instanceof FunctionReference) {
            FunctionReference fr = (FunctionReference)sel;
            if (fr.getFunction() != FunctionReference.CmisQlFunction.SCORE) {
                throw new CmisRuntimeException("Unknown function: " + fr.getFunction());
            }
            String key = fr.getAliasName();
            if (key == null) {
                key = "SEARCH_SCORE";
            }
            this.realColumns.put(key, "ecm:fulltextScore");
            if (this.typeInfo != null) {
                PropertyDecimalDefinitionImpl pd = new PropertyDecimalDefinitionImpl();
                pd.setId(key);
                pd.setQueryName(key);
                pd.setCardinality(Cardinality.SINGLE);
                pd.setDisplayName("Score");
                pd.setLocalName("score");
                this.typeInfo.put(key, (PropertyDefinition<?>)pd);
            }
        } else {
            ColumnReference col = (ColumnReference)sel;
            if (col.getPropertyQueryName().equals("*")) {
                for (PropertyDefinition pd : this.fromType.getPropertyDefinitions().values()) {
                    String id = pd.getId();
                    if ((pd.getCardinality() != Cardinality.SINGLE || !Boolean.TRUE.equals(pd.isQueryable())) && !id.equals("cmis:baseTypeId")) continue;
                    ColumnReference c = new ColumnReference(null, id);
                    c.setTypeDefinition(id, this.fromType);
                    this.recordSelectSelector((CmisSelector)c);
                }
                return;
            }
            String key = col.getPropertyQueryName();
            PropertyDefinition pd = col.getPropertyDefinition();
            String nxqlCol = this.getColumn(col);
            String id = pd.getId();
            if (nxqlCol != null && pd.getCardinality() == Cardinality.SINGLE && (Boolean.TRUE.equals(pd.isQueryable()) || id.equals("cmis:baseTypeId") || id.equals("cmis:objectTypeId"))) {
                col.setInfo((Object)nxqlCol);
                this.realColumns.put(key, nxqlCol);
            } else {
                this.virtualColumns.put(key, col);
            }
            if (this.typeInfo != null) {
                this.typeInfo.put(key, pd);
            }
        }
    }

    protected void recordSelector(CmisSelector sel, String clauseType) {
        if (sel instanceof FunctionReference) {
            FunctionReference fr = (FunctionReference)sel;
            if (clauseType != ORDER_BY) {
                throw new QueryParseException("Cannot use function in " + clauseType + " clause: " + fr.getFunction());
            }
            return;
        }
        ColumnReference col = (ColumnReference)sel;
        String column = this.getColumn(col);
        if (!this.isFacetsColumn(col.getPropertyId()) && column == null) {
            throw new QueryParseException("Cannot use column in " + clauseType + " clause: " + col.getPropertyQueryName());
        }
        col.setInfo((Object)column);
        if (clauseType == WHERE && "nuxeo:lifecycleState".equals(col.getPropertyId()) && ((TrashService)Framework.getService(TrashService.class)).hasFeature(TrashService.Feature.TRASHED_STATE_IS_DEDUCED_FROM_LIFECYCLE)) {
            this.skipDeleted = false;
        }
        if (clauseType == WHERE && "nuxeo:isTrashed".equals(col.getPropertyId())) {
            this.skipDeleted = false;
        }
    }

    protected String getColumn(ColumnReference col) {
        return this.getColumn(col.getPropertyId());
    }

    protected String getColumn(String propertyId) {
        if (propertyId.startsWith(CMIS_PREFIX) || propertyId.startsWith(NX_PREFIX)) {
            return this.getSystemColumn(propertyId);
        }
        if (propertyId.indexOf(58) == -1) {
            SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            for (Schema schema : schemaManager.getSchemas()) {
                if (schema.getNamespace().hasPrefix() || !schema.hasField(propertyId)) continue;
                propertyId = schema.getName() + ":" + propertyId;
                break;
            }
        }
        return propertyId;
    }

    protected String getSystemColumn(String propertyId) {
        switch (propertyId) {
            case "cmis:objectId": {
                return "ecm:uuid";
            }
            case "cmis:parentId": 
            case "nuxeo:parentId": {
                return "ecm:parentId";
            }
            case "nuxeo:pathSegment": {
                return "ecm:name";
            }
            case "nuxeo:pos": {
                return "ecm:pos";
            }
            case "cmis:objectTypeId": {
                return "ecm:primaryType";
            }
            case "cmis:secondaryObjectTypeIds": 
            case "nuxeo:secondaryObjectTypeIds": {
                return "ecm:mixinType";
            }
            case "cmis:versionLabel": {
                return "ecm:versionLabel";
            }
            case "cmis:isLatestMajorVersion": {
                return "ecm:isLatestMajorVersion";
            }
            case "cmis:isLatestVersion": {
                return "ecm:isLatestVersion";
            }
            case "nuxeo:isVersion": {
                return "ecm:isVersion";
            }
            case "nuxeo:isCheckedIn": {
                return "ecm:isCheckedIn";
            }
            case "nuxeo:isTrashed": {
                return "ecm:isTrashed";
            }
            case "nuxeo:lifecycleState": {
                return "ecm:currentLifeCycleState";
            }
            case "cmis:name": {
                return NXQL_DC_TITLE;
            }
            case "cmis:description": {
                return NXQL_DC_DESCRIPTION;
            }
            case "cmis:createdBy": {
                return NXQL_DC_CREATOR;
            }
            case "cmis:creationDate": {
                return NXQL_DC_CREATED;
            }
            case "cmis:lastModificationDate": {
                return NXQL_DC_MODIFIED;
            }
            case "cmis:lastModifiedBy": {
                return NXQL_DC_LAST_CONTRIBUTOR;
            }
            case "cmis:sourceId": {
                return NXQL_REL_SOURCE;
            }
            case "cmis:targetId": {
                return NXQL_REL_TARGET;
            }
        }
        return null;
    }

    protected static String cmisToNxqlFulltextQuery(String statement) {
        statement = statement.replace(" and ", " ");
        statement = statement.replace(" AND ", " ");
        return statement;
    }

    protected String convertOrderBy(String orderBy, TypeManagerImpl typeManager) {
        ArrayList<String> list = new ArrayList<String>(1);
        for (String order : orderBy.split(",")) {
            boolean asc;
            String prop;
            String lower = (order = order.trim()).toLowerCase();
            if (lower.endsWith(SPACE_ASC)) {
                prop = order.substring(0, order.length() - SPACE_ASC.length()).trim();
                asc = true;
            } else if (lower.endsWith(SPACE_DESC)) {
                prop = order.substring(0, order.length() - SPACE_DESC.length()).trim();
                asc = false;
            } else {
                prop = order;
                asc = true;
            }
            String propId = typeManager.getPropertyIdForQueryName(prop);
            if (propId == null) {
                throw new CmisInvalidArgumentException("Invalid orderBy: " + orderBy);
            }
            String col = this.getColumn(propId);
            list.add(asc ? col : col + " DESC");
        }
        return StringUtils.join(list, (String)", ");
    }

    protected static Map<String, Serializable> convertToCMISMap(Map<String, Serializable> nxqlMap, Map<String, String> realColumns, Map<String, ColumnReference> virtualColumns, NuxeoCmisService service) {
        HashMap<String, Serializable> cmisMap = new HashMap<String, Serializable>();
        for (Map.Entry<String, String> en : realColumns.entrySet()) {
            String cmisCol = en.getKey();
            String nxqlCol = en.getValue();
            Serializable value = nxqlMap.get(nxqlCol);
            if (value instanceof Long) {
                value = BigInteger.valueOf((Long)value);
            } else if (value instanceof Integer) {
                value = BigInteger.valueOf(((Integer)value).intValue());
            } else if (value instanceof Double) {
                value = ((Double)value).isNaN() ? BigDecimal.ZERO : BigDecimal.valueOf((Double)value);
            } else if (value == null && NULL_IS_FALSE_COLUMNS.contains(nxqlCol)) {
                value = Boolean.FALSE;
            }
            cmisMap.put(cmisCol, value);
        }
        HashMap<String, NuxeoObjectData> datas = null;
        TypeManagerImpl typeManager = service.getTypeManager();
        for (Map.Entry<String, ColumnReference> vc : virtualColumns.entrySet()) {
            NuxeoPropertyDataBase<?> pd;
            NuxeoObjectData data;
            String key = vc.getKey();
            ColumnReference col = vc.getValue();
            String qual = col.getQualifier();
            if (col.getPropertyId().equals("cmis:baseTypeId")) {
                String typeId = (String)cmisMap.get("cmis:objectTypeId");
                if (typeId == null) {
                    throw new NullPointerException();
                }
                TypeDefinitionContainer type = typeManager.getTypeById(typeId);
                String baseTypeId = type.getTypeDefinition().getBaseTypeId().value();
                cmisMap.put(key, (Serializable)((Object)baseTypeId));
                continue;
            }
            if (datas == null) {
                datas = new HashMap<String, NuxeoObjectData>(2);
            }
            if ((data = (NuxeoObjectData)datas.get(qual)) == null) {
                String id = (String)cmisMap.get("cmis:objectId");
                try {
                    data = service.getObject(service.getNuxeoRepository().getId(), id, null, null, null, null, null, null, null);
                }
                catch (CmisRuntimeException e) {
                    log.error((Object)("Cannot get document: " + id), (Throwable)e);
                }
                datas.put(qual, data);
            }
            Serializable v = data == null ? null : ((pd = data.getProperty(col.getPropertyId())) == null ? null : (pd.getPropertyDefinition().getCardinality() == Cardinality.SINGLE ? (Serializable)pd.getFirstValue() : (Serializable)((Object)pd.getValues())));
            cmisMap.put(key, v);
        }
        return cmisMap;
    }

    public static class NXQLtoCMISIterableQueryResult
    implements IterableQueryResult,
    Iterator<Map<String, Serializable>> {
        protected IterableQueryResult it;
        protected Iterator<Map<String, Serializable>> iter;
        protected Map<String, String> realColumns;
        protected Map<String, ColumnReference> virtualColumns;
        protected NuxeoCmisService service;

        public NXQLtoCMISIterableQueryResult(IterableQueryResult it, Map<String, String> realColumns, Map<String, ColumnReference> virtualColumns, NuxeoCmisService service) {
            this.it = it;
            this.iter = it.iterator();
            this.realColumns = realColumns;
            this.virtualColumns = virtualColumns;
            this.service = service;
        }

        public Iterator<Map<String, Serializable>> iterator() {
            return this;
        }

        public void close() {
            this.it.close();
        }

        public boolean isLife() {
            return this.it.isLife();
        }

        public boolean mustBeClosed() {
            return this.it.mustBeClosed();
        }

        public long size() {
            return this.it.size();
        }

        public long pos() {
            return this.it.pos();
        }

        public void skipTo(long pos) {
            this.it.skipTo(pos);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Serializable> next() {
            Map<String, Serializable> nxqlMap = this.iter.next();
            return CMISQLtoNXQL.convertToCMISMap(nxqlMap, this.realColumns, this.virtualColumns, this.service);
        }
    }

    public class GeneratingWalker
    extends AbstractPredicateWalker {
        public static final String NX_FULLTEXT_INDEX_PREFIX = "nx:";
        public StringBuilder buf = new StringBuilder();

        public Boolean walkNot(Tree opNode, Tree node) {
            this.buf.append("NOT ");
            this.walkPredicate(node);
            return null;
        }

        public Boolean walkAnd(Tree opNode, Tree leftNode, Tree rightNode) {
            this.buf.append("(");
            this.walkPredicate(leftNode);
            this.buf.append(" AND ");
            this.walkPredicate(rightNode);
            this.buf.append(")");
            return null;
        }

        public Boolean walkOr(Tree opNode, Tree leftNode, Tree rightNode) {
            this.buf.append("(");
            this.walkPredicate(leftNode);
            this.buf.append(" OR ");
            this.walkPredicate(rightNode);
            this.buf.append(")");
            return null;
        }

        public Boolean walkEquals(Tree opNode, Tree leftNode, Tree rightNode) {
            this.walkExpr(leftNode);
            this.buf.append(" = ");
            this.walkExpr(rightNode);
            return null;
        }

        public Boolean walkNotEquals(Tree opNode, Tree leftNode, Tree rightNode) {
            this.walkExpr(leftNode);
            this.buf.append(" <> ");
            this.walkExpr(rightNode);
            return null;
        }

        public Boolean walkGreaterThan(Tree opNode, Tree leftNode, Tree rightNode) {
            this.walkExpr(leftNode);
            this.buf.append(" > ");
            this.walkExpr(rightNode);
            return null;
        }

        public Boolean walkGreaterOrEquals(Tree opNode, Tree leftNode, Tree rightNode) {
            this.walkExpr(leftNode);
            this.buf.append(" >= ");
            this.walkExpr(rightNode);
            return null;
        }

        public Boolean walkLessThan(Tree opNode, Tree leftNode, Tree rightNode) {
            this.walkExpr(leftNode);
            this.buf.append(" < ");
            this.walkExpr(rightNode);
            return null;
        }

        public Boolean walkLessOrEquals(Tree opNode, Tree leftNode, Tree rightNode) {
            this.walkExpr(leftNode);
            this.buf.append(" <= ");
            this.walkExpr(rightNode);
            return null;
        }

        public Boolean walkIn(Tree opNode, Tree colNode, Tree listNode) {
            this.walkExpr(colNode);
            this.buf.append(" IN ");
            this.walkExpr(listNode);
            return null;
        }

        public Boolean walkNotIn(Tree opNode, Tree colNode, Tree listNode) {
            this.walkExpr(colNode);
            this.buf.append(" NOT IN ");
            this.walkExpr(listNode);
            return null;
        }

        public Boolean walkInAny(Tree opNode, Tree colNode, Tree listNode) {
            this.walkAny(colNode, "IN", listNode);
            return null;
        }

        public Boolean walkNotInAny(Tree opNode, Tree colNode, Tree listNode) {
            this.walkAny(colNode, "NOT IN", listNode);
            return null;
        }

        public Boolean walkEqAny(Tree opNode, Tree literalNode, Tree colNode) {
            this.walkAny(colNode, "=", literalNode);
            return null;
        }

        protected void walkAny(Tree colNode, String op, Tree exprNode) {
            ColumnReference col = this.getColumnReference(colNode);
            if (col.getPropertyDefinition().getCardinality() != Cardinality.MULTI) {
                throw new QueryParseException("Cannot use " + op + " ANY with single-valued property: " + col.getPropertyQueryName());
            }
            String nxqlCol = (String)col.getInfo();
            this.buf.append(nxqlCol);
            if (!"ecm:mixinType".equals(nxqlCol)) {
                this.buf.append("/*");
            }
            this.buf.append(' ');
            this.buf.append(op);
            this.buf.append(' ');
            this.walkExpr(exprNode);
        }

        public Boolean walkIsNull(Tree opNode, Tree colNode) {
            return this.walkIsNullOrIsNotNull(colNode, true);
        }

        public Boolean walkIsNotNull(Tree opNode, Tree colNode) {
            return this.walkIsNullOrIsNotNull(colNode, false);
        }

        protected Boolean walkIsNullOrIsNotNull(Tree colNode, boolean isNull) {
            ColumnReference col = this.getColumnReference(colNode);
            boolean multi = col.getPropertyDefinition().getCardinality() == Cardinality.MULTI;
            this.walkExpr(colNode);
            if (multi) {
                this.buf.append("/*");
            }
            this.buf.append(isNull ? " IS NULL" : " IS NOT NULL");
            return null;
        }

        public Boolean walkLike(Tree opNode, Tree colNode, Tree stringNode) {
            this.walkExpr(colNode);
            this.buf.append(" LIKE ");
            this.walkExpr(stringNode);
            return null;
        }

        public Boolean walkNotLike(Tree opNode, Tree colNode, Tree stringNode) {
            this.walkExpr(colNode);
            this.buf.append(" NOT LIKE ");
            this.walkExpr(stringNode);
            return null;
        }

        public Boolean walkContains(Tree opNode, Tree qualNode, Tree queryNode) {
            String statement = (String)super.walkString(queryNode);
            String indexName = "ecm:fulltext";
            if (statement.startsWith(NX_FULLTEXT_INDEX_PREFIX)) {
                int firstColumnIdx = (statement = statement.substring(NX_FULLTEXT_INDEX_PREFIX.length())).indexOf(58);
                if (firstColumnIdx > 0 && firstColumnIdx < statement.length() - 1) {
                    indexName = indexName + '_' + statement.substring(0, firstColumnIdx);
                    statement = statement.substring(firstColumnIdx + 1);
                } else {
                    log.warn((Object)String.format("fail to microparse custom fulltext index: fallback to '%s'", indexName));
                }
            }
            statement = CMISQLtoNXQL.cmisToNxqlFulltextQuery(statement);
            this.buf.append(indexName);
            this.buf.append(" = ");
            this.buf.append(NXQL.escapeString((String)statement));
            return null;
        }

        public Boolean walkInFolder(Tree opNode, Tree qualNode, Tree paramNode) {
            String id = (String)super.walkString(paramNode);
            this.buf.append("ecm:parentId");
            this.buf.append(" = ");
            this.buf.append(NXQL.escapeString((String)id));
            return null;
        }

        public Boolean walkInTree(Tree opNode, Tree qualNode, Tree paramNode) {
            String id = (String)super.walkString(paramNode);
            IdRef docRef = new IdRef(id);
            String path = CMISQLtoNXQL.this.coreSession.exists((DocumentRef)docRef) ? CMISQLtoNXQL.this.coreSession.getDocument((DocumentRef)docRef).getPathAsString() : "/__NOSUCHPATH__";
            this.buf.append("ecm:path");
            this.buf.append(" STARTSWITH ");
            this.buf.append(NXQL.escapeString((String)path));
            return null;
        }

        public Object walkList(Tree node) {
            this.buf.append("(");
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (i != 0) {
                    this.buf.append(", ");
                }
                Tree child = node.getChild(i);
                this.walkExpr(child);
            }
            this.buf.append(")");
            return null;
        }

        public Object walkBoolean(Tree node) {
            Object value = super.walkBoolean(node);
            this.buf.append(Boolean.FALSE.equals(value) ? "0" : "1");
            return null;
        }

        public Object walkNumber(Tree node) {
            Number value = (Number)super.walkNumber(node);
            this.buf.append(value.toString());
            return null;
        }

        public Object walkString(Tree node) {
            String value = (String)super.walkString(node);
            this.buf.append(NXQL.escapeString((String)value));
            return null;
        }

        public Object walkTimestamp(Tree node) {
            Calendar value = (Calendar)super.walkTimestamp(node);
            this.buf.append("TIMESTAMP ");
            this.buf.append('\'');
            this.buf.append(ISO_DATE_TIME_FORMAT.print((ReadablePartial)LocalDateTime.fromCalendarFields((Calendar)value)));
            this.buf.append('\'');
            return null;
        }

        public Object walkCol(Tree node) {
            String nxqlCol = (String)this.getColumnReference(node).getInfo();
            this.buf.append(nxqlCol);
            return null;
        }

        protected ColumnReference getColumnReference(Tree node) {
            CmisSelector sel = CMISQLtoNXQL.this.query.getColumnReference(Integer.valueOf(node.getTokenStartIndex()));
            if (sel instanceof ColumnReference) {
                return (ColumnReference)sel;
            }
            throw new QueryParseException("Cannot use column in WHERE clause: " + sel.getName());
        }
    }

    public class AnalyzingWalker
    extends AbstractPredicateWalker {
        public boolean hasContains;

        public Boolean walkContains(Tree opNode, Tree qualNode, Tree queryNode) {
            if (this.hasContains && ((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanPropertyFalse("org.nuxeo.cmis.relaxSpec")) {
                throw new QueryParseException("At most one CONTAINS() is allowed");
            }
            this.hasContains = true;
            return null;
        }
    }
}

