/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ChangeEventInfo;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.PolicyIdList;
import org.apache.chemistry.opencmis.commons.data.Principal;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AllowableActionsImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BindingsObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyIdListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RenditionDataImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoCmisService;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoPropertyData;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoPropertyDataBase;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoTypeHelper;
import org.nuxeo.ecm.core.opencmis.impl.util.ListUtils;
import org.nuxeo.ecm.core.opencmis.impl.util.SimpleImageInfo;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.runtime.api.Framework;

public class NuxeoObjectData
implements ObjectData {
    public static final String REND_STREAM_ICON = "nuxeo:icon";
    public static final String REND_KIND_CMIS_THUMBNAIL = "cmis:thumbnail";
    public static final String REND_STREAM_RENDITION_PREFIX = "nuxeo:rendition:";
    public static final String REND_KIND_NUXEO_RENDITION = "nuxeo:rendition";
    public static final String RENDITION_COMPUTE_INFO_PROP = "org.nuxeo.cmis.computeRenditionInfo";
    public static final String RENDITION_COMPUTE_INFO_DEFAULT = "false";
    public CmisService service;
    public DocumentModel doc;
    public boolean creation = false;
    private List<String> propertyIds;
    private Boolean includeAllowableActions;
    private IncludeRelationships includeRelationships;
    private String renditionFilter;
    private Boolean includePolicyIds;
    private Boolean includeAcl;
    private static final BindingsObjectFactory objectFactory = new BindingsObjectFactoryImpl();
    private TypeDefinition type;
    private List<TypeDefinition> secondaryTypes;
    private List<TypeDefinition> allTypes;
    private static final int CACHE_MAX_SIZE = 10;
    private static final int DEFAULT_MAX_RENDITIONS = 20;
    private Map<String, Properties> propertiesCache = new HashMap<String, Properties>();
    private CallContext callContext;
    private NuxeoCmisService nuxeoCmisService;
    private static final String STAR = "*";
    protected static final List<String> STAR_FILTER = Collections.singletonList("*");

    public NuxeoObjectData(CmisService service, DocumentModel doc, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        this.service = service;
        this.doc = doc;
        this.propertyIds = NuxeoObjectData.getPropertyIdsFromFilter(filter);
        this.includeAllowableActions = includeAllowableActions;
        this.includeRelationships = includeRelationships;
        this.renditionFilter = renditionFilter;
        this.includePolicyIds = includePolicyIds;
        this.includeAcl = includeAcl;
        this.nuxeoCmisService = NuxeoCmisService.extractFromCmisService(service);
        this.type = this.nuxeoCmisService.getTypeManager().getTypeDefinition(NuxeoTypeHelper.mappedId(doc.getType()));
        this.secondaryTypes = new ArrayList<TypeDefinition>();
        for (String secondaryTypeId : NuxeoPropertyData.getSecondaryTypeIds(doc)) {
            TypeDefinition td = this.nuxeoCmisService.getTypeManager().getTypeDefinition(secondaryTypeId);
            if (td == null) continue;
            this.secondaryTypes.add(td);
        }
        this.allTypes = new ArrayList<TypeDefinition>(1 + this.secondaryTypes.size());
        this.allTypes.add(this.type);
        this.allTypes.addAll(this.secondaryTypes);
        this.callContext = this.nuxeoCmisService.callContext;
    }

    protected NuxeoObjectData(CmisService service, DocumentModel doc) {
        this(service, doc, null, null, null, null, null, null, null);
    }

    public NuxeoObjectData(CmisService service, DocumentModel doc, OperationContext context) {
        this(service, doc, context.getFilterString(), context.isIncludeAllowableActions(), context.getIncludeRelationships(), context.getRenditionFilterString(), context.isIncludePolicies(), context.isIncludeAcls(), null);
    }

    protected static List<String> getPropertyIdsFromFilter(String filter) {
        if (filter == null || filter.length() == 0) {
            return STAR_FILTER;
        }
        List<String> ids = Arrays.asList(filter.split(",\\s*"));
        if (ids.contains(STAR)) {
            ids = STAR_FILTER;
        }
        return ids;
    }

    public String getId() {
        return this.doc.getId();
    }

    public BaseTypeId getBaseTypeId() {
        return NuxeoTypeHelper.getBaseTypeId(this.doc);
    }

    public List<TypeDefinition> getTypeDefinitions() {
        return this.allTypes;
    }

    public Properties getProperties() {
        return this.getProperties(this.propertyIds);
    }

    protected Properties getProperties(List<String> propertyIds) {
        String key = StringUtils.join(propertyIds, (char)',');
        Properties properties = this.propertiesCache.get(key);
        if (properties == null) {
            ArrayList props = new ArrayList();
            for (TypeDefinition t : this.allTypes) {
                Map propertyDefinitions = t.getPropertyDefinitions();
                for (PropertyDefinition pd : propertyDefinitions.values()) {
                    if (propertyIds != STAR_FILTER && !propertyIds.contains(pd.getId())) continue;
                    props.add(NuxeoPropertyData.construct(this, pd, this.callContext));
                }
            }
            properties = objectFactory.createPropertiesData(props);
            this.limitCacheSize();
            this.propertiesCache.put(key, properties);
        }
        return properties;
    }

    protected void limitCacheSize() {
        if (this.propertiesCache.size() >= 10) {
            Properties sf = this.propertiesCache.get(STAR);
            this.propertiesCache.clear();
            if (sf != null) {
                this.propertiesCache.put(STAR, sf);
            }
        }
    }

    public NuxeoPropertyDataBase<?> getProperty(String id) {
        return (NuxeoPropertyDataBase)this.getProperties(STAR_FILTER).getProperties().get(id);
    }

    public AllowableActions getAllowableActions() {
        if (!Boolean.TRUE.equals(this.includeAllowableActions)) {
            return null;
        }
        return NuxeoObjectData.getAllowableActions(this.doc, this.creation);
    }

    public static AllowableActions getAllowableActions(DocumentModel doc, boolean creation) {
        BaseTypeId baseType = NuxeoTypeHelper.getBaseTypeId(doc);
        boolean isDocument = baseType == BaseTypeId.CMIS_DOCUMENT;
        boolean isFolder = baseType == BaseTypeId.CMIS_FOLDER;
        boolean isRoot = "/".equals(doc.getPathAsString());
        boolean canWrite = creation || doc.getCoreSession().hasPermission(doc.getRef(), "Write");
        EnumSet<Action> set = EnumSet.noneOf(Action.class);
        set.add(Action.CAN_GET_OBJECT_PARENTS);
        set.add(Action.CAN_GET_PROPERTIES);
        if (isFolder) {
            set.add(Action.CAN_GET_DESCENDANTS);
            set.add(Action.CAN_GET_FOLDER_TREE);
            set.add(Action.CAN_GET_CHILDREN);
            if (!isRoot) {
                set.add(Action.CAN_GET_FOLDER_PARENT);
            }
        } else if (isDocument) {
            set.add(Action.CAN_GET_CONTENT_STREAM);
            set.add(Action.CAN_GET_ALL_VERSIONS);
            set.add(Action.CAN_ADD_OBJECT_TO_FOLDER);
            set.add(Action.CAN_REMOVE_OBJECT_FROM_FOLDER);
            if (doc.isCheckedOut()) {
                set.add(Action.CAN_CHECK_IN);
                set.add(Action.CAN_CANCEL_CHECK_OUT);
            } else {
                set.add(Action.CAN_CHECK_OUT);
            }
        }
        if (isFolder || isDocument) {
            set.add(Action.CAN_GET_RENDITIONS);
        }
        if (canWrite) {
            if (isFolder) {
                set.add(Action.CAN_CREATE_DOCUMENT);
                set.add(Action.CAN_CREATE_FOLDER);
                set.add(Action.CAN_CREATE_RELATIONSHIP);
                set.add(Action.CAN_DELETE_TREE);
            } else if (isDocument) {
                set.add(Action.CAN_SET_CONTENT_STREAM);
                set.add(Action.CAN_DELETE_CONTENT_STREAM);
            }
            set.add(Action.CAN_UPDATE_PROPERTIES);
            if (isFolder && !isRoot || isDocument) {
                set.add(Action.CAN_MOVE_OBJECT);
            }
            if (!isRoot) {
                set.add(Action.CAN_DELETE_OBJECT);
            }
        }
        if (Boolean.FALSE.booleanValue()) {
            set.add(Action.CAN_GET_OBJECT_RELATIONSHIPS);
            set.add(Action.CAN_APPLY_POLICY);
            set.add(Action.CAN_REMOVE_POLICY);
            set.add(Action.CAN_GET_APPLIED_POLICIES);
            set.add(Action.CAN_GET_ACL);
            set.add(Action.CAN_APPLY_ACL);
            set.add(Action.CAN_CREATE_ITEM);
        }
        AllowableActionsImpl aa = new AllowableActionsImpl();
        aa.setAllowableActions(set);
        return aa;
    }

    public List<RenditionData> getRenditions() {
        if (!NuxeoObjectData.needsRenditions(this.renditionFilter)) {
            return Collections.emptyList();
        }
        return NuxeoObjectData.getRenditions(this.doc, this.renditionFilter, null, null, this.callContext);
    }

    public static boolean needsRenditions(String renditionFilter) {
        return !StringUtils.isBlank((CharSequence)renditionFilter) && !"cmis:none".equals(renditionFilter);
    }

    public static List<RenditionData> getRenditions(DocumentModel doc, String renditionFilter, BigInteger maxItems, BigInteger skipCount, CallContext callContext) {
        try {
            ArrayList<RenditionData> list = new ArrayList<RenditionData>();
            list.addAll(NuxeoObjectData.getRenditionServiceRenditions(doc, callContext));
            if (!STAR.equals(renditionFilter)) {
                String[] filters = renditionFilter.split(",");
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    RenditionData ren = (RenditionData)it.next();
                    boolean keep = false;
                    for (String filter : filters) {
                        if (filter.contains("/")) {
                            if (filter.endsWith("/*")) {
                                String typeSlash = filter.substring(0, filter.indexOf(47) + 1);
                                if (!ren.getMimeType().startsWith(typeSlash)) continue;
                                keep = true;
                                break;
                            }
                            if (!ren.getMimeType().equals(filter)) continue;
                            keep = true;
                            break;
                        }
                        if (!ren.getKind().equals(filter)) continue;
                        keep = true;
                        break;
                    }
                    if (keep) continue;
                    it.remove();
                }
            }
            list = ListUtils.batchList(list, maxItems, skipCount, 20);
            return list;
        }
        catch (IOException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    @Deprecated
    protected static List<RenditionData> getIconRendition(DocumentModel doc, CallContext callContext) throws IOException {
        String iconPath;
        try {
            iconPath = (String)((Object)doc.getPropertyValue("common:icon"));
        }
        catch (PropertyException e) {
            iconPath = null;
        }
        InputStream is = NuxeoObjectData.getIconStream(iconPath, callContext);
        if (is == null) {
            return Collections.emptyList();
        }
        RenditionDataImpl ren = new RenditionDataImpl();
        ren.setStreamId(REND_STREAM_ICON);
        ren.setKind(REND_KIND_CMIS_THUMBNAIL);
        int slash = iconPath.lastIndexOf(47);
        String filename = slash == -1 ? iconPath : iconPath.substring(slash + 1);
        ren.setTitle(filename);
        SimpleImageInfo info = new SimpleImageInfo(is);
        ren.setBigLength(BigInteger.valueOf(info.getLength()));
        ren.setBigWidth(BigInteger.valueOf(info.getWidth()));
        ren.setBigHeight(BigInteger.valueOf(info.getHeight()));
        ren.setMimeType(info.getMimeType());
        return Collections.singletonList(ren);
    }

    @Deprecated
    public static InputStream getIconStream(String iconPath, CallContext context) {
        ServletContext servletContext;
        if (iconPath == null || iconPath.length() == 0) {
            return null;
        }
        if (!iconPath.startsWith("/")) {
            iconPath = '/' + iconPath;
        }
        if ((servletContext = (ServletContext)context.get("servletContext")) == null) {
            throw new CmisRuntimeException("Cannot get servlet context");
        }
        return servletContext.getResourceAsStream(iconPath);
    }

    protected static List<RenditionData> getRenditionServiceRenditions(DocumentModel doc, CallContext callContext) throws IOException {
        RenditionService renditionService = (RenditionService)Framework.getService(RenditionService.class);
        List defs = renditionService.getAvailableRenditionDefinitions(doc);
        ArrayList<RenditionData> list = new ArrayList<RenditionData>(defs.size());
        for (RenditionDefinition def : defs) {
            Rendition rendition;
            Blob blob;
            if (!def.isVisible()) continue;
            RenditionDataImpl ren = new RenditionDataImpl();
            String cmisName = def.getCmisName();
            if (StringUtils.isBlank((CharSequence)cmisName)) {
                cmisName = REND_STREAM_RENDITION_PREFIX + def.getName();
            }
            ren.setStreamId(cmisName);
            String kind = def.getKind();
            ren.setKind(StringUtils.isNotBlank((CharSequence)kind) ? kind : REND_KIND_NUXEO_RENDITION);
            ren.setTitle(def.getLabel());
            ren.setMimeType(def.getContentType());
            boolean computeInfo = Boolean.parseBoolean(Framework.getProperty((String)RENDITION_COMPUTE_INFO_PROP, (String)RENDITION_COMPUTE_INFO_DEFAULT));
            if ((REND_KIND_CMIS_THUMBNAIL.equals(ren.getKind()) || computeInfo) && (blob = (rendition = renditionService.getRendition(doc, def.getName())).getBlob()) != null) {
                ren.setTitle(blob.getFilename());
                SimpleImageInfo info = new SimpleImageInfo(blob.getStream());
                ren.setBigLength(BigInteger.valueOf(info.getLength()));
                ren.setBigWidth(BigInteger.valueOf(info.getWidth()));
                ren.setBigHeight(BigInteger.valueOf(info.getHeight()));
                ren.setMimeType(info.getMimeType());
            }
            list.add((RenditionData)ren);
        }
        return list;
    }

    public List<ObjectData> getRelationships() {
        return NuxeoObjectData.getRelationships(this.getId(), this.includeRelationships, this.nuxeoCmisService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ObjectData> getRelationships(String id, IncludeRelationships includeRelationships, NuxeoCmisService service) {
        if (includeRelationships == null || includeRelationships == IncludeRelationships.NONE) {
            return null;
        }
        String statement = "SELECT cmis:objectId, cmis:baseTypeId, cmis:sourceId, cmis:targetId FROM " + BaseTypeId.CMIS_RELATIONSHIP.value() + " WHERE ";
        String qid = "'" + id.replace("'", "''") + "'";
        if (includeRelationships != IncludeRelationships.TARGET) {
            statement = statement + "cmis:sourceId = " + qid;
        }
        if (includeRelationships == IncludeRelationships.BOTH) {
            statement = statement + " OR ";
        }
        if (includeRelationships != IncludeRelationships.SOURCE) {
            statement = statement + "cmis:targetId = " + qid;
        }
        ArrayList<ObjectData> list = new ArrayList<ObjectData>();
        try (IterableQueryResult res = null;){
            HashMap typeInfo = new HashMap();
            res = service.queryAndFetch(statement, false, typeInfo);
            for (Map map : res) {
                list.add((ObjectData)service.makeObjectData(map, typeInfo));
            }
        }
        return list;
    }

    public Acl getAcl() {
        if (!Boolean.TRUE.equals(this.includeAcl)) {
            return null;
        }
        ACP acp = this.doc.getACP();
        return NuxeoObjectData.getAcl(acp, false, this.nuxeoCmisService);
    }

    protected static Acl getAcl(ACP acp, boolean onlyBasicPermissions, NuxeoCmisService service) {
        if (acp == null) {
            acp = new ACPImpl();
        }
        Boolean exact = Boolean.TRUE;
        ArrayList<AccessControlEntryImpl> aces = new ArrayList<AccessControlEntryImpl>();
        for (ACL acl : acp.getACLs()) {
            boolean direct = "local".equals(acl.getName());
            LinkedHashMap permissionMap = new LinkedHashMap();
            for (ACE ace : acl.getACEs()) {
                LinkedHashSet<String> permissions;
                boolean denied = ace.isDenied();
                String username = ace.getUsername();
                String permission = ace.getPermission();
                if (denied) {
                    if ("Everyone".equals(username) && "Everything".equals(permission)) {
                        permission = "Nothing";
                    } else {
                        exact = Boolean.FALSE;
                        continue;
                    }
                }
                if ((permissions = (LinkedHashSet<String>)permissionMap.get(username)) == null) {
                    permissions = new LinkedHashSet<String>();
                    permissionMap.put(username, permissions);
                }
                boolean isBasic = false;
                if (service.readPermissions.contains(permission)) {
                    isBasic = true;
                    permissions.add("cmis:read");
                }
                if (service.writePermissions.contains(permission)) {
                    isBasic = true;
                    permissions.add("cmis:write");
                }
                if ("Everything".equals(permission)) {
                    isBasic = true;
                    permissions.add("cmis:all");
                }
                if (!onlyBasicPermissions) {
                    permissions.add(permission);
                } else if (!isBasic) {
                    exact = Boolean.FALSE;
                }
                if ("Nothing".equals(permission)) break;
            }
            for (Map.Entry entry : permissionMap.entrySet()) {
                String username = (String)entry.getKey();
                Set permissions = (Set)entry.getValue();
                if (permissions.isEmpty()) continue;
                AccessControlEntryImpl entry2 = new AccessControlEntryImpl();
                entry2.setPrincipal((Principal)new AccessControlPrincipalDataImpl(username));
                entry2.setPermissions(new ArrayList(permissions));
                entry2.setDirect(direct);
                aces.add(entry2);
            }
        }
        AccessControlListImpl result = new AccessControlListImpl();
        result.setAces(aces);
        result.setExact(exact);
        return result;
    }

    public Boolean isExactAcl() {
        return Boolean.FALSE;
    }

    public PolicyIdList getPolicyIds() {
        if (!Boolean.TRUE.equals(this.includePolicyIds)) {
            return null;
        }
        return new PolicyIdListImpl();
    }

    public ChangeEventInfo getChangeEventInfo() {
        return null;
    }

    public List<CmisExtensionElement> getExtensions() {
        return Collections.emptyList();
    }

    public void setExtensions(List<CmisExtensionElement> extensions) {
    }
}

