/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoRepository;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class NuxeoRepositories
extends DefaultComponent {
    protected Map<String, NuxeoRepository> repositories;

    public void start(ComponentContext context) {
        this.repositories = new ConcurrentHashMap<String, NuxeoRepository>();
    }

    public void stop(ComponentContext context) {
        this.repositories = null;
    }

    public NuxeoRepository getRepository(String repositoryId) {
        this.initRepositories();
        return this.repositories.get(repositoryId);
    }

    public List<NuxeoRepository> getRepositories() {
        this.initRepositories();
        return new ArrayList<NuxeoRepository>(this.repositories.values());
    }

    protected void initRepositories() {
        if (!this.repositories.isEmpty()) {
            return;
        }
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        for (String repositoryName : repositoryManager.getRepositoryNames()) {
            CloseableCoreSession coreSession = CoreInstance.openCoreSession((String)repositoryName);
            Throwable throwable = null;
            try {
                String rootFolderId = coreSession.getRootDocument().getId();
                this.repositories.put(repositoryName, new NuxeoRepository(repositoryName, rootFolderId));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (coreSession == null) continue;
                if (throwable != null) {
                    try {
                        coreSession.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                coreSession.close();
            }
        }
    }
}

