/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.jtajca;

import java.util.Date;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public interface TransactionStatistics {
    public String getId();

    public String getThreadName();

    public Status getStatus();

    public Date getStartDate();

    public String getStartCapturedContextMessage();

    public Date getEndDate();

    public String getEndCapturedContextMessage();

    public long getDuration();

    public boolean isEnded();

    public static enum Status {
        ACTIVE(0),
        COMMITTED(3),
        COMMITTING(8),
        MARKED_ROLLLEDBACK(1),
        NO_TRANSACTION(6),
        PREPARED(2),
        PREPARING(7),
        ROLLEDBACK(4),
        ROLLING_BACK(9),
        UNKNOWN(5);

        public final int code;

        private Status(int code) {
            this.code = code;
        }

        public static Status fromCode(int code) {
            for (Status e : Status.values()) {
                if (e.code != code) continue;
                return e;
            }
            return UNKNOWN;
        }

        public static Status fromTx(Transaction tx) {
            try {
                return Status.fromCode(tx.getStatus());
            }
            catch (SystemException e) {
                return UNKNOWN;
            }
        }
    }
}

