/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.jtajca.internal;

import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.management.jtajca.ConnectionPoolMonitor;
import org.nuxeo.ecm.core.management.jtajca.CoreSessionMonitor;
import org.nuxeo.ecm.core.management.jtajca.Defaults;
import org.nuxeo.ecm.core.management.jtajca.TransactionMonitor;
import org.nuxeo.ecm.core.management.jtajca.internal.DefaultConnectionPoolMonitor;
import org.nuxeo.ecm.core.management.jtajca.internal.DefaultCoreSessionMonitor;
import org.nuxeo.ecm.core.management.jtajca.internal.DefaultTransactionMonitor;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManager;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.jtajca.NuxeoContainerListener;
import org.nuxeo.runtime.management.ServerLocator;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.model.Component;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class DefaultMonitorComponent
extends DefaultComponent {
    private final ConnectionManagerUpdater cmUpdater = new ConnectionManagerUpdater();
    protected final Log log = LogFactory.getLog(DefaultMonitorComponent.class);
    protected CoreSessionMonitor coreSessionMonitor;
    protected TransactionMonitor transactionMonitor;
    protected Map<String, ConnectionPoolMonitor> poolConnectionMonitors = new HashMap<String, ConnectionPoolMonitor>();
    protected boolean installed;

    public void start(ComponentContext context) {
        RepositoryService repositoryService = (RepositoryService)Framework.getService(RepositoryService.class);
        if (repositoryService == null) {
            return;
        }
        this.uninstall();
        this.install();
    }

    public int getApplicationStartedOrder() {
        Component component = (Component)Framework.getRuntime().getComponent(MetricsService.class.getName());
        return component.getApplicationStartedOrder() + 1;
    }

    public void stop(ComponentContext context) {
        this.uninstall();
    }

    protected void install() {
        this.installed = true;
        this.coreSessionMonitor = new DefaultCoreSessionMonitor();
        this.coreSessionMonitor.install();
        this.transactionMonitor = new DefaultTransactionMonitor();
        this.transactionMonitor.install();
        NuxeoContainer.addListener((NuxeoContainerListener)this.cmUpdater);
    }

    protected void activateRepository(String repositoryName) {
        CloseableCoreSession session = CoreInstance.openCoreSessionSystem((String)repositoryName);
        Throwable throwable = null;
        if (session != null) {
            if (throwable != null) {
                try {
                    session.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                session.close();
            }
        }
    }

    protected void uninstall() {
        if (!this.installed) {
            return;
        }
        this.log.info((Object)("Total commits during server life: " + this.transactionMonitor.getTotalCommits()));
        this.installed = false;
        NuxeoContainer.removeListener((NuxeoContainerListener)this.cmUpdater);
        for (ConnectionPoolMonitor storage : this.poolConnectionMonitors.values()) {
            storage.uninstall();
        }
        this.coreSessionMonitor.uninstall();
        this.transactionMonitor.uninstall();
        this.poolConnectionMonitors.clear();
        this.coreSessionMonitor = null;
        this.transactionMonitor = null;
    }

    protected static ServerInstance bind(Object managed) {
        return DefaultMonitorComponent.bind(managed, "default");
    }

    protected static ServerInstance bind(Class<?> itf, Object managed) {
        return DefaultMonitorComponent.bind(itf, managed, "default");
    }

    protected static ServerInstance bind(Object managed, String name) {
        return DefaultMonitorComponent.bind(managed.getClass().getInterfaces()[0], managed, name);
    }

    protected static ServerInstance bind(Class<?> itf, Object managed, String name) {
        MBeanServer mbs = ((ServerLocator)Framework.getService(ServerLocator.class)).lookupServer();
        name = Defaults.instance.name(itf, name);
        try {
            ObjectInstance oi = mbs.registerMBean(managed, new ObjectName(name));
            return new ServerInstance(mbs, oi.getObjectName());
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new UnsupportedOperationException("Cannot bind " + managed + " on " + name, e);
        }
    }

    protected static void unbind(ServerInstance instance) {
        try {
            instance.server.unregisterMBean(instance.name);
        }
        catch (InstanceNotFoundException | MBeanRegistrationException e) {
            LogFactory.getLog(DefaultMonitorComponent.class).error((Object)("Cannot unbind " + instance), (Throwable)e);
        }
    }

    public static class ServerInstance {
        public final MBeanServer server;
        public final ObjectName name;

        ServerInstance(MBeanServer server, ObjectName name) {
            this.server = server;
            this.name = name;
        }
    }

    private class ConnectionManagerUpdater
    implements NuxeoContainerListener {
        private ConnectionManagerUpdater() {
        }

        public void handleNewConnectionManager(String name, NuxeoConnectionManager cm) {
            DefaultConnectionPoolMonitor monitor = new DefaultConnectionPoolMonitor(name, cm);
            monitor.install();
            DefaultMonitorComponent.this.poolConnectionMonitors.put(name, monitor);
        }

        public void handleConnectionManagerReset(String name, NuxeoConnectionManager cm) {
            DefaultConnectionPoolMonitor monitor = (DefaultConnectionPoolMonitor)DefaultMonitorComponent.this.poolConnectionMonitors.get(name);
            monitor.handleNewConnectionManager(cm);
        }

        public void handleConnectionManagerDispose(String name, NuxeoConnectionManager mgr) {
            ConnectionPoolMonitor monitor = DefaultMonitorComponent.this.poolConnectionMonitors.remove(name);
            monitor.uninstall();
        }
    }
}

