/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.avro;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.avro.AvroMapper;
import org.nuxeo.runtime.avro.AvroService;

public class DocumentModelMapper
extends AvroMapper<DocumentModel, GenericRecord> {
    public DocumentModelMapper(AvroService service) {
        super(service);
    }

    public DocumentModel fromAvro(Schema schema, GenericRecord input) {
        if (!"documentModel".equals(this.getLogicalType(schema))) {
            throw new RuntimeServiceException("Schema does not match DocumentModel");
        }
        DocumentModel doc = this.documentModelFromAvro(input);
        GenericRecord documentTypeRecord = (GenericRecord)input.get("documentType");
        for (Schema.Field schemaField : documentTypeRecord.getSchema().getFields()) {
            GenericRecord schemaRecord = (GenericRecord)documentTypeRecord.get(schemaField.name());
            List fields = schemaField.schema().getFields();
            HashMap<String, Object> data = new HashMap<String, Object>(fields.size());
            for (Schema.Field field : fields) {
                data.put(this.service.decodeName(field.name()), this.service.fromAvro(field.schema(), Property.class, schemaRecord.get(field.name())));
            }
            doc.setProperties(this.service.decodeName(schemaField.name()), data);
        }
        return doc;
    }

    public GenericRecord toAvro(Schema schema, DocumentModel input) {
        GenericData.Record record = new GenericData.Record(schema);
        if ("documentModel".equals(this.getLogicalType(schema))) {
            this.documentModelToAvro(schema, input, (GenericRecord)record);
        } else if ("documentType".equals(this.getLogicalType(schema))) {
            for (Schema.Field field : schema.getFields()) {
                record.put(field.name(), this.service.toAvro(field.schema(), (Object)input));
            }
        } else {
            for (Schema.Field field : schema.getFields()) {
                Property p = input.getProperty(this.service.decodeName(field.name()));
                record.put(field.name(), this.service.toAvro(field.schema(), (Object)p));
            }
        }
        return record;
    }

    protected DocumentModel documentModelFromAvro(GenericRecord input) {
        String path = (String)input.get("path");
        String type = (String)input.get("primaryType");
        String uuid = (String)input.get("uuid");
        String parentId = (String)input.get("parentId");
        String repositoryName = (String)input.get("repository");
        Boolean isProxy = (Boolean)input.get("isProxy");
        IdRef parentRef = parentId == null ? null : new IdRef(parentId);
        Set facets = (Set)input.get("mixinType");
        DocumentModelImpl doc = new DocumentModelImpl(null, type, uuid, new Path(path), null, (DocumentRef)parentRef, null, facets, null, repositoryName, isProxy.booleanValue());
        doc.setIsVersion(((Boolean)input.get("isVersion")).booleanValue());
        doc.prefetchCurrentLifecycleState((String)input.get("currentLifeCycleState"));
        return doc;
    }

    protected void documentModelToAvro(Schema schema, DocumentModel doc, GenericRecord record) {
        record.put("uuid", (Object)doc.getId());
        record.put("name", (Object)doc.getName());
        record.put("title", (Object)doc.getTitle());
        record.put("path", (Object)doc.getPathAsString());
        record.put("repository", (Object)doc.getRepositoryName());
        record.put("primaryType", (Object)doc.getType());
        DocumentRef parentRef = doc.getParentRef();
        if (parentRef != null) {
            record.put("parentId", (Object)parentRef.toString());
        }
        record.put("currentLifeCycleState", (Object)doc.getCurrentLifeCycleState());
        if (doc.isVersion()) {
            record.put("versionLabel", (Object)doc.getVersionLabel());
            record.put("versionVersionableId", (Object)doc.getVersionSeriesId());
        }
        record.put("isProxy", (Object)doc.isProxy());
        record.put("isTrashed", (Object)doc.isTrashed());
        record.put("isVersion", (Object)doc.isVersion());
        record.put("isCheckedIn", (Object)(!doc.isCheckedOut() ? 1 : 0));
        record.put("isLatestVersion", (Object)doc.isLatestVersion());
        record.put("isLatestMajorVersion", (Object)doc.isLatestMajorVersion());
        record.put("changeToken", (Object)doc.getChangeToken());
        if (doc.getPos() != null) {
            record.put("pos", (Object)doc.getPos());
        }
        record.put("mixinType", (Object)doc.getFacets());
        record.put("documentType", this.service.toAvro(schema.getField("documentType").schema(), (Object)doc));
    }
}

