/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.marshallers.json.InputStreamWithJsonNode;
import org.nuxeo.ecm.core.io.registry.Reader;

public abstract class DefaultListJsonReader<EntityType>
extends EntityJsonReader<List<EntityType>> {
    private final Class<EntityType> elClazz;
    private final Type elGenericType;

    public DefaultListJsonReader(String entityType, Class<EntityType> elClazz) {
        super(entityType);
        this.elClazz = elClazz;
        this.elGenericType = elClazz;
    }

    public DefaultListJsonReader(String entityType, Class<EntityType> elClazz, Type elGenericType) {
        super(entityType);
        this.elClazz = elClazz;
        this.elGenericType = elGenericType;
    }

    @Override
    protected List<EntityType> readEntity(JsonNode jn) throws IOException {
        Reader<EntityType> entryReader = this.registry.getReader(this.ctx, this.elClazz, this.elGenericType, MediaType.APPLICATION_JSON_TYPE);
        ArrayList<EntityType> result = new ArrayList<EntityType>();
        JsonNode entriesNode = jn.get("entries");
        if (entriesNode != null && !entriesNode.isNull() && entriesNode.isArray()) {
            JsonNode entryNode = null;
            Iterator it = entriesNode.elements();
            while (it.hasNext()) {
                entryNode = (JsonNode)it.next();
                InputStreamWithJsonNode in = new InputStreamWithJsonNode(entryNode);
                EntityType doc = entryReader.read(this.elClazz, this.elClazz, MediaType.APPLICATION_JSON_TYPE, in);
                result.add(doc);
            }
        }
        return result;
    }
}

