/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.tools.report;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.nuxeo.connect.tools.report.ReportConfiguration;
import org.nuxeo.connect.tools.report.ReportRunner;
import org.nuxeo.connect.tools.report.ReportServer;
import org.nuxeo.ecm.core.management.statuses.NuxeoInstanceIdentifierHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.ResourcePublisher;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ReportComponent
extends DefaultComponent {
    final ReportConfiguration configuration = new ReportConfiguration();
    final Service service = new Service();
    final Management management = new Management();

    public void start(ComponentContext context) {
        ((ResourcePublisher)Framework.getService(ResourcePublisher.class)).registerResource("connect-report", "connect-report", ReportServer.class, (Object)this.management);
    }

    public void stop(ComponentContext context) {
        ((ResourcePublisher)Framework.getService(ResourcePublisher.class)).unregisterResource("connect-report", "connect-report");
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (!(contribution instanceof ReportConfiguration.Contribution)) {
            throw new IllegalArgumentException(String.format("unknown contribution of type %s in %s", contribution.getClass(), contributor));
        }
        this.configuration.addContribution((ReportConfiguration.Contribution)contribution);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(Service.class)) {
            return adapter.cast(this.service);
        }
        return (T)super.getAdapter(adapter);
    }

    public class Management
    implements ReportServer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(String host, int port, String ... names) throws IOException {
            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(Management.class.getClassLoader());
            try (Socket sock = new Socket(host, port);
                 OutputStream sink = sock.getOutputStream();){
                ReportComponent.this.service.run(sink, new HashSet<String>(Arrays.asList(names)));
            }
            finally {
                Thread.currentThread().setContextClassLoader(tcl);
            }
        }
    }

    class Service
    implements ReportRunner {
        Service() {
        }

        public ReportConfiguration getConfiguration() {
            return ReportComponent.this.configuration;
        }

        @Override
        public Set<String> list() {
            HashSet<String> names = new HashSet<String>();
            for (ReportConfiguration.Contribution contrib : ReportComponent.this.configuration) {
                names.add(contrib.name);
            }
            return names;
        }

        @Override
        public void run(OutputStream out, Set<String> names) throws IOException {
            out.write(123);
            out.write(34);
            out.write(NuxeoInstanceIdentifierHelper.getServerInstanceName().getBytes());
            out.write(34);
            out.write(58);
            out.write(123);
            Iterator<ReportConfiguration.Contribution> iterator = ReportComponent.this.configuration.iterator(names);
            while (iterator.hasNext()) {
                ReportConfiguration.Contribution contrib = iterator.next();
                out.write(34);
                out.write(contrib.name.getBytes());
                out.write(34);
                out.write(58);
                contrib.writer.write(out);
                if (iterator.hasNext()) {
                    out.write(44);
                }
                out.flush();
            }
            out.write(125);
            out.write(125);
            out.flush();
        }
    }
}

