/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.tools.report.management;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jolokia.backend.BackendManager;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.config.ProcessingParameters;
import org.jolokia.request.JmxRequest;
import org.jolokia.request.JmxRequestFactory;
import org.jolokia.util.LogHandler;
import org.jolokia.util.RequestType;
import org.json.simple.JSONObject;
import org.nuxeo.runtime.model.DefaultComponent;

public class MXComponent
extends DefaultComponent {
    static MXComponent instance;
    final Configuration config = new Configuration(new Object[]{ConfigKey.AGENT_ID, "false", ConfigKey.IGNORE_ERRORS, "true"});
    final BackendManager manager = new BackendManager(this.config, new LogHandler(){
        final Log log = LogFactory.getLog(MXComponent.class);

        public void info(String message) {
            this.log.info((Object)message);
        }

        public void error(String message, Throwable t) {
            this.log.error((Object)message, t);
        }

        public void debug(String message) {
            this.log.debug((Object)message);
        }
    });

    public MXComponent() {
        instance = this;
    }

    RequestBuilder list() {
        return new RequestBuilder(RequestType.LIST);
    }

    RequestBuilder search(String pattern) {
        return new RequestBuilder(RequestType.SEARCH).withMbean(pattern);
    }

    RequestBuilder read(String pattern) {
        return new RequestBuilder(RequestType.READ).withMbean(pattern);
    }

    RequestBuilder exec(String pattern, String operation, Object ... arguments) {
        return new RequestBuilder(RequestType.EXEC).withMbean(pattern).withOperation(operation, arguments);
    }

    class RequestBuilder {
        final Map<String, Object> pRequestMap = new JSONObject();
        final Map<String, String> pParams = new HashMap<String, String>();

        RequestBuilder(RequestType oftype) {
            this.pRequestMap.put("type", oftype.getName());
        }

        RequestBuilder withMbean(String value) {
            this.pRequestMap.put("mbean", value);
            return this;
        }

        RequestBuilder withOperation(String value, Object ... arguments) {
            this.pRequestMap.put("operation", value);
            this.pRequestMap.put("arguments", Arrays.asList(arguments));
            return this;
        }

        void run(OutputStream sink) {
            try {
                JmxRequest request = JmxRequestFactory.createPostRequest(this.pRequestMap, (ProcessingParameters)MXComponent.this.config.getProcessingParameters(this.pParams));
                JSONObject json = MXComponent.this.manager.handleRequest(request);
                OutputStreamWriter writer = new OutputStreamWriter(sink);
                json.writeJSONString((Writer)writer);
                writer.flush();
            }
            catch (IOException | JMException cause) {
                throw new AssertionError("Cannot invoke jolokia", cause);
            }
        }
    }
}

