/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.db;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.h2.tools.SimpleResultSet;
import org.nuxeo.ecm.core.storage.sql.db.EmbeddedFunctions;

public class H2Functions
extends EmbeddedFunctions {
    private static boolean isLogEnabled() {
        return false;
    }

    private static void logDebug(String message, Object ... args) {
    }

    public static boolean isInTreeString(Connection conn, String id, String baseId) throws SQLException {
        return H2Functions.isInTree(conn, (Serializable)((Object)id), (Serializable)((Object)baseId));
    }

    public static boolean isInTreeLong(Connection conn, Long id, Long baseId) throws SQLException {
        return H2Functions.isInTree(conn, id, baseId);
    }

    public static boolean isAccessAllowedString(Connection conn, String id, String principals, String permissions) throws SQLException {
        return H2Functions.isAccessAllowed(conn, (Serializable)((Object)id), H2Functions.split(principals), H2Functions.split(permissions));
    }

    public static boolean isAccessAllowedLong(Connection conn, Long id, String principals, String permissions) throws SQLException {
        return H2Functions.isAccessAllowed(conn, id, H2Functions.split(principals), H2Functions.split(permissions));
    }

    public static void clusterInvalidateString(Connection conn, long nodeId, String id, String fragments, int kind) throws SQLException {
        String sql = "SELECT \"NODEID\" FROM \"CLUSTER_NODES\" WHERE \"NODEID\" <> ?";
        if (H2Functions.isLogEnabled()) {
            H2Functions.logDebug(sql, nodeId);
        }
        LinkedList<Long> nodeIds = new LinkedList<Long>();
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setLong(1, nodeId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    nodeIds.add(rs.getLong(1));
                }
            }
        }
        if (H2Functions.isLogEnabled()) {
            H2Functions.logDebug("  -> " + nodeIds, new Object[0]);
        }
        sql = "INSERT INTO \"CLUSTER_INVALS\" (\"NODEID\", \"ID\", \"FRAGMENTS\", \"KIND\") VALUES (?, ?, ?, ?)";
        ps = conn.prepareStatement(sql);
        var9_8 = null;
        try {
            for (Long nid : nodeIds) {
                if (H2Functions.isLogEnabled()) {
                    H2Functions.logDebug(sql, nid, id, fragments, kind);
                }
                ps.setLong(1, nid);
                ps.setObject(2, id);
                ps.setString(3, fragments);
                ps.setInt(4, kind);
                ps.execute();
            }
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
        finally {
            if (ps != null) {
                if (var9_8 != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable throwable) {
                        var9_8.addSuppressed(throwable);
                    }
                } else {
                    ps.close();
                }
            }
        }
    }

    public static ResultSet getClusterInvalidationsString(Connection conn, long nodeId) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        SimpleResultSet result = new SimpleResultSet();
        result.addColumn("ID", 12, 0, 0);
        result.addColumn("FRAGMENTS", 12, 0, 0);
        result.addColumn("KIND", 4, 0, 0);
        if (meta.getURL().startsWith("jdbc:columnlist:")) {
            return result;
        }
        String sql = "SELECT \"ID\", \"FRAGMENTS\", \"KIND\" FROM \"CLUSTER_INVALS\" WHERE \"NODEID\" = ?";
        if (H2Functions.isLogEnabled()) {
            H2Functions.logDebug(sql, nodeId);
        }
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setLong(1, nodeId);
            LinkedList<String> debugValues = null;
            if (H2Functions.isLogEnabled()) {
                debugValues = new LinkedList<String>();
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String id = rs.getString(1);
                    String fragments = rs.getString(2);
                    long kind = rs.getLong(3);
                    result.addRow(new Object[]{id, fragments, kind});
                    if (debugValues == null) continue;
                    debugValues.add(id + ',' + fragments + ',' + kind);
                }
            }
            if (debugValues != null) {
                H2Functions.logDebug("  -> " + debugValues, new Object[0]);
            }
            sql = "DELETE FROM \"CLUSTER_INVALS\" WHERE \"NODEID\" = ?";
            if (H2Functions.isLogEnabled()) {
                H2Functions.logDebug(sql, new Object[0]);
            }
        }
        ps = conn.prepareStatement(sql);
        var7_6 = null;
        try {
            ps.setLong(1, nodeId);
            ps.execute();
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
        finally {
            if (ps != null) {
                if (var7_6 != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable throwable) {
                        var7_6.addSuppressed(throwable);
                    }
                } else {
                    ps.close();
                }
            }
        }
        return result;
    }

    public static ResultSet upgradeVersions(Connection conn) throws SQLException {
        String sql = "SELECT v.id, v.versionableid, h.majorversion, h.minorversion  FROM versions v JOIN hierarchy h ON v.id = h.id  ORDER BY v.versionableid, v.created DESC";
        try (PreparedStatement ps1 = conn.prepareStatement(sql);
             ResultSet rs = ps1.executeQuery();){
            String series = null;
            boolean isLatest = false;
            boolean isLatestMajor = false;
            while (rs.next()) {
                String id = rs.getString("id");
                String vid = rs.getString("versionableid");
                long maj = rs.getLong("majorversion");
                long min = rs.getLong("minorversion");
                if (vid == null || !vid.equals(series)) {
                    isLatest = true;
                    isLatestMajor = true;
                    series = vid;
                }
                boolean isMajor = min == 0L;
                try (PreparedStatement ps2 = conn.prepareStatement("UPDATE versions SET label = ?, islatest = ?, islatestmajor = ? WHERE id = ?");){
                    ps2.setString(1, maj + "." + min);
                    ps2.setBoolean(2, isLatest);
                    ps2.setBoolean(3, isMajor && isLatestMajor);
                    ps2.setString(4, id);
                    ps2.executeUpdate();
                }
                isLatest = false;
                if (!isMajor) continue;
                isLatestMajor = false;
            }
        }
        return new SimpleResultSet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResultSet upgradeLastContributor(Connection conn) throws SQLException {
        String sql = "SELECT dc_c.id, dc_c.item  FROM dublincore dc    JOIN (SELECT id, max(pos) AS pos FROM dc_contributors GROUP BY id) AS tmp ON (dc.id = tmp.id)    JOIN dc_contributors dc_c ON (tmp.id = dc_c.id AND tmp.pos = dc_c.pos)  WHERE dc.lastContributor IS NULL;";
        try (PreparedStatement ps1 = conn.prepareStatement(sql);
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                PreparedStatement ps2;
                block34: {
                    String id = rs.getString("id");
                    String lastContributor = rs.getString("item");
                    ps2 = conn.prepareStatement("UPDATE dublincore SET lastContributor = ? WHERE id = ?");
                    Throwable throwable = null;
                    try {
                        ps2.setString(1, lastContributor);
                        ps2.setString(2, id);
                        ps2.executeUpdate();
                        if (ps2 == null) continue;
                        if (throwable == null) break block34;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (ps2 == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    ps2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            ps2.close();
                            throw throwable3;
                        }
                    }
                    try {
                        ps2.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                ps2.close();
            }
            return new SimpleResultSet();
        }
    }

    public static ResultSet getAncestorsIds(Connection conn, String idsString) throws SQLException {
        Set<String> ids = H2Functions.split(idsString);
        DatabaseMetaData meta = conn.getMetaData();
        SimpleResultSet result = new SimpleResultSet();
        result.addColumn("ID", 12, 0, 0);
        if (meta.getURL().startsWith("jdbc:columnlist:")) {
            return result;
        }
        LinkedList<String> todo = new LinkedList<String>(ids);
        HashSet<String> done = new HashSet<String>();
        HashSet<String> res = new HashSet<String>();
        LinkedList<String> debugIds = null;
        if (H2Functions.isLogEnabled()) {
            debugIds = new LinkedList<String>();
        }
        while (!todo.isEmpty()) {
            done.addAll(todo);
            String sql = H2Functions.getSelectParentIdsByIdsSql(todo.size());
            if (H2Functions.isLogEnabled()) {
                H2Functions.logDebug(sql, todo);
            }
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                int i = 1;
                for (String id : todo) {
                    ps.setString(i++, id);
                }
                todo = new LinkedList();
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        String id = rs.getString(1);
                        if (id == null) continue;
                        if (!res.contains(id)) {
                            res.add(id);
                            result.addRow(new Object[]{id});
                        }
                        if (!done.contains(id)) {
                            todo.add(id);
                        }
                        if (debugIds == null) continue;
                        debugIds.add(id);
                    }
                }
            }
            if (!H2Functions.isLogEnabled()) continue;
            H2Functions.logDebug("  -> " + debugIds, new Object[0]);
        }
        return result;
    }

    protected static String getSelectParentIdsByIdsSql(int size) {
        StringBuilder buf = new StringBuilder("SELECT DISTINCT \"PARENTID\" FROM \"HIERARCHY\" WHERE \"ID\" IN (");
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append('?');
        }
        buf.append(')');
        return buf.toString();
    }
}

