/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.clients;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;

public class OAuth2Client {
    protected static final Pattern LOCALHOST_PATTERN = Pattern.compile("http://localhost(:\\d+)?(/.*)?");
    protected String name;
    protected String id;
    protected String secret;
    protected List<String> redirectURIs;
    protected boolean autoGrant;
    protected boolean enabled;

    protected OAuth2Client(String name, String id, String secret, List<String> redirectURIs, boolean autoGrant, boolean enabled) {
        this.name = name;
        this.id = id;
        this.secret = secret;
        this.redirectURIs = redirectURIs;
        this.autoGrant = autoGrant;
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getRedirectURIs() {
        return this.redirectURIs;
    }

    public boolean isAutoGrant() {
        return this.autoGrant;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static OAuth2Client fromDocumentModel(DocumentModel doc) {
        String name = (String)((Object)doc.getPropertyValue("oauth2Client:name"));
        String id = (String)((Object)doc.getPropertyValue("oauth2Client:clientId"));
        String secret = (String)((Object)doc.getPropertyValue("oauth2Client:clientSecret"));
        String redirectURIsProperty = (String)((Object)doc.getPropertyValue("oauth2Client:redirectURIs"));
        List<Object> redirectURIs = StringUtils.isEmpty((CharSequence)redirectURIsProperty) ? Collections.emptyList() : Arrays.asList(redirectURIsProperty.split(","));
        boolean autoGrant = (Boolean)Optional.ofNullable(doc.getPropertyValue("oauth2Client:autoGrant")).orElse(Boolean.valueOf(false));
        boolean enabled = (Boolean)doc.getPropertyValue("oauth2Client:enabled");
        return new OAuth2Client(name, id, secret, redirectURIs, autoGrant, enabled);
    }

    public static boolean isRedirectURIValid(String redirectURI) {
        String trimmed = redirectURI.trim();
        return !trimmed.isEmpty() && (trimmed.startsWith("https") || !trimmed.startsWith("http") || LOCALHOST_PATTERN.matcher(trimmed).matches());
    }

    public boolean isValidWith(String clientId, String clientSecret) {
        return this.enabled && this.id.equals(clientId) && (StringUtils.isEmpty((CharSequence)this.secret) || this.secret.equals(clientSecret));
    }

    public String toString() {
        return String.format("%s(name=%s, id=%s, redirectURIs=%s, autoGrant=%b, enabled=%b)", this.getClass().getSimpleName(), this.name, this.id, this.redirectURIs, this.autoGrant, this.enabled);
    }
}

