/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.tokens;

import com.google.api.client.auth.oauth2.StoredCredential;
import java.time.Instant;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.CharacterPredicates;
import org.apache.commons.text.RandomStringGenerator;
import org.nuxeo.ecm.core.api.DocumentModel;

public class NuxeoOAuth2Token {
    private static final RandomStringGenerator GENERATOR = new RandomStringGenerator.Builder().filteredBy(new CharacterPredicate[]{CharacterPredicates.LETTERS, CharacterPredicates.DIGITS}).withinRange(48, 122).build();
    public static final String SCHEMA = "oauth2Token";
    public static final String KEY_SERVICE_LOGIN = "serviceLogin";
    public static final String KEY_NUXEO_LOGIN = "nuxeoLogin";
    protected Long id;
    protected String serviceName;
    protected String nuxeoLogin;
    protected String accessToken;
    protected String clientId;
    protected Calendar creationDate;
    private String refreshToken;
    private Long expirationTimeMilliseconds;
    private boolean isShared;
    protected String sharedWith;
    protected String serviceLogin;

    public NuxeoOAuth2Token(long expirationTimeMilliseconds, String clientId) {
        this("", "", expirationTimeMilliseconds);
        this.clientId = clientId;
        this.refresh();
    }

    public NuxeoOAuth2Token(String accessToken, String refreshToken, Long expirationTimeMilliseconds) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expirationTimeMilliseconds = expirationTimeMilliseconds;
        this.creationDate = Calendar.getInstance();
        this.isShared = false;
        this.sharedWith = "";
    }

    public NuxeoOAuth2Token(StoredCredential credential) {
        this(credential.getAccessToken(), credential.getRefreshToken(), credential.getExpirationTimeMilliseconds());
    }

    public NuxeoOAuth2Token(DocumentModel entry) {
        this.id = (Long)entry.getProperty(SCHEMA, "id");
        this.accessToken = (String)entry.getProperty(SCHEMA, "accessToken");
        this.refreshToken = (String)entry.getProperty(SCHEMA, "refreshToken");
        this.expirationTimeMilliseconds = (Long)entry.getProperty(SCHEMA, "expirationTimeMilliseconds");
        this.serviceName = (String)entry.getProperty(SCHEMA, "serviceName");
        this.nuxeoLogin = (String)entry.getProperty(SCHEMA, KEY_NUXEO_LOGIN);
        this.clientId = (String)entry.getProperty(SCHEMA, "clientId");
        this.creationDate = (Calendar)entry.getProperty(SCHEMA, "creationDate");
        this.isShared = (Boolean)entry.getProperty(SCHEMA, "isShared");
        this.sharedWith = (String)entry.getProperty(SCHEMA, "sharedWith");
        this.serviceLogin = (String)entry.getProperty(SCHEMA, KEY_SERVICE_LOGIN);
    }

    public static StoredCredential asCredential(DocumentModel entry) {
        StoredCredential credential = new StoredCredential();
        String accessToken = (String)entry.getProperty(SCHEMA, "accessToken");
        String refreshToken = (String)entry.getProperty(SCHEMA, "refreshToken");
        Long expirationTimeMilliseconds = (Long)entry.getProperty(SCHEMA, "expirationTimeMilliseconds");
        credential.setAccessToken(accessToken);
        credential.setRefreshToken(refreshToken);
        credential.setExpirationTimeMilliseconds(expirationTimeMilliseconds);
        return credential;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceName", this.serviceName);
        map.put(KEY_NUXEO_LOGIN, this.nuxeoLogin);
        map.put("accessToken", this.accessToken);
        map.put("refreshToken", this.refreshToken);
        map.put("expirationTimeMilliseconds", this.expirationTimeMilliseconds);
        map.put("clientId", this.clientId);
        map.put("creationDate", this.creationDate);
        map.put("isShared", this.isShared);
        map.put("sharedWith", this.sharedWith);
        map.put(KEY_SERVICE_LOGIN, this.serviceLogin);
        return map;
    }

    public Map<String, Object> toJsonObject() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("access_token", this.accessToken);
        m.put("refresh_token", this.refreshToken);
        m.put("token_type", "bearer");
        m.put("expires_in", TimeUnit.MILLISECONDS.toSeconds(this.creationDate.getTimeInMillis() + this.expirationTimeMilliseconds - Instant.now().toEpochMilli()));
        return m;
    }

    public void updateEntry(DocumentModel entry) {
        entry.setProperty(SCHEMA, "serviceName", (Object)this.serviceName);
        entry.setProperty(SCHEMA, KEY_NUXEO_LOGIN, (Object)this.nuxeoLogin);
        entry.setProperty(SCHEMA, "accessToken", (Object)this.accessToken);
        entry.setProperty(SCHEMA, "refreshToken", (Object)this.refreshToken);
        entry.setProperty(SCHEMA, "expirationTimeMilliseconds", (Object)this.expirationTimeMilliseconds);
        entry.setProperty(SCHEMA, "clientId", (Object)this.clientId);
        entry.setProperty(SCHEMA, "isShared", (Object)this.isShared);
        entry.setProperty(SCHEMA, "sharedWith", (Object)this.sharedWith);
        entry.setProperty(SCHEMA, KEY_SERVICE_LOGIN, (Object)this.serviceLogin);
    }

    public void refresh() {
        this.accessToken = GENERATOR.generate(32);
        this.refreshToken = GENERATOR.generate(64);
        this.creationDate = Calendar.getInstance();
    }

    public boolean isExpired() {
        return this.creationDate != null && this.creationDate.getTimeInMillis() + this.expirationTimeMilliseconds < Calendar.getInstance().getTimeInMillis();
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setNuxeoLogin(String userId) {
        this.nuxeoLogin = userId;
    }

    public String getNuxeoLogin() {
        return this.nuxeoLogin;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public Long getExpirationTimeMilliseconds() {
        return this.expirationTimeMilliseconds;
    }

    public void setExpirationTimeMilliseconds(Long expirationTimeMilliseconds) {
        this.expirationTimeMilliseconds = expirationTimeMilliseconds;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public void setIsShared(boolean isShared) {
        this.isShared = isShared;
    }

    public String getSharedWith() {
        return this.sharedWith;
    }

    public void setSharedWith(String sharedWith) {
        this.sharedWith = sharedWith;
    }

    public String getServiceLogin() {
        return this.serviceLogin;
    }

    public void setServiceLogin(String serviceLogin) {
        this.serviceLogin = serviceLogin;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public Long getId() {
        return this.id;
    }
}

