/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.discovery;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.jolokia.discovery.AbstractDiscoveryMessage;
import org.jolokia.discovery.AgentDetails;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryIncomingMessage
extends AbstractDiscoveryMessage {
    private InetAddress sourceAddress;
    private int sourcePort;

    public DiscoveryIncomingMessage(DatagramPacket pPacket) throws IOException {
        this.sourceAddress = pPacket.getAddress();
        this.sourcePort = pPacket.getPort();
        Map<AbstractDiscoveryMessage.Payload, Object> inData = DiscoveryIncomingMessage.parseData(pPacket.getData(), pPacket.getLength());
        String typeS = (String)inData.remove((Object)AbstractDiscoveryMessage.Payload.TYPE);
        if (typeS == null) {
            throw new IOException("No message type given in discovery message " + inData);
        }
        try {
            AbstractDiscoveryMessage.MessageType type = AbstractDiscoveryMessage.MessageType.valueOf(typeS.toUpperCase());
            this.setType(type);
        }
        catch (IllegalArgumentException exp) {
            throw new IOException("Invalid type " + typeS + " given in discovery message", exp);
        }
        if (this.isResponse()) {
            this.setAgentDetails(new AgentDetails(inData));
        }
    }

    public InetAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    @Override
    public String toString() {
        return "JolokiaDiscoveryIncomingMessage{source = " + this.getSourceAddress() + ":" + this.getSourcePort() + ": " + super.toString() + "}";
    }

    public static Map<AbstractDiscoveryMessage.Payload, Object> parseData(byte[] pData, int pLength) throws IOException {
        JSONParser parser = new JSONParser();
        ByteArrayInputStream is = new ByteArrayInputStream(pData, 0, pLength);
        try {
            JSONObject inMsg = (JSONObject)parser.parse((Reader)new InputStreamReader((InputStream)is, "UTF-8"));
            HashMap<AbstractDiscoveryMessage.Payload, Object> data = new HashMap<AbstractDiscoveryMessage.Payload, Object>();
            for (Map.Entry entry : inMsg.entrySet()) {
                try {
                    data.put(AbstractDiscoveryMessage.Payload.fromKey(entry.getKey().toString()), entry.getValue());
                }
                catch (IllegalArgumentException exp) {}
            }
            return data;
        }
        catch (ParseException e) {
            throw new IOException("Cannot parse discovery message as JSON", e);
        }
    }
}

