/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jaxrs.io.audit;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.Provider;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.ecm.automation.jaxrs.io.EntityWriter;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;

@Deprecated
@Provider
@Produces(value={"application/json"})
public class LogEntryWriter
extends EntityWriter<LogEntry> {
    public static final String ENTITY_TYPE = "logEntry";

    @Override
    protected String getEntityType() {
        return ENTITY_TYPE;
    }

    @Override
    protected void writeEntityBody(JsonGenerator jg, LogEntry logEntry) throws IOException {
        jg.writeStringField("entity-type", ENTITY_TYPE);
        jg.writeStringField("category", logEntry.getCategory());
        jg.writeStringField("principalName", logEntry.getPrincipalName());
        jg.writeStringField("comment", logEntry.getComment());
        jg.writeStringField("docLifeCycle", logEntry.getDocLifeCycle());
        jg.writeStringField("docPath", logEntry.getDocPath());
        jg.writeStringField("docType", logEntry.getDocType());
        jg.writeStringField("docUUID", logEntry.getDocUUID());
        jg.writeStringField("eventId", logEntry.getEventId());
        jg.writeStringField("repositoryId", logEntry.getRepositoryId());
        jg.writeStringField("eventDate", ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)logEntry.getEventDate())));
        jg.writeNumberField("id", logEntry.getId());
        jg.writeStringField("logDate", ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)logEntry.getLogDate())));
        this.writeExtendedInfos(jg, logEntry);
    }

    protected void writeExtendedInfos(JsonGenerator jg, LogEntry logEntry) throws IOException {
        Map extended = logEntry.getExtendedInfos();
        jg.writeObjectFieldStart("extended");
        for (String key : extended.keySet()) {
            ExtendedInfo ei = (ExtendedInfo)extended.get(key);
            if (ei != null && ei.getSerializableValue() != null) {
                this.writeExtendedInfo(jg, key, ei.getSerializableValue());
                continue;
            }
            jg.writeNullField(key);
        }
        jg.writeEndObject();
    }

    protected void writeExtendedInfo(JsonGenerator jg, String key, Serializable value) throws IOException {
        Class<?> clazz = value.getClass();
        if (Long.class.isAssignableFrom(clazz)) {
            jg.writeNumberField(key, ((Long)value).longValue());
        } else if (Integer.class.isAssignableFrom(clazz)) {
            jg.writeNumberField(key, ((Integer)value).intValue());
        } else if (Double.class.isAssignableFrom(clazz)) {
            jg.writeNumberField(key, ((Double)value).doubleValue());
        } else if (Date.class.isAssignableFrom(clazz)) {
            jg.writeStringField(key, ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)value)));
        } else if (String.class.isAssignableFrom(clazz)) {
            jg.writeStringField(key, (String)((Object)value));
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            jg.writeBooleanField(key, ((Boolean)value).booleanValue());
        } else {
            jg.writeStringField(key, value.toString());
        }
    }
}

