/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ec.notification;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mvel2.PropertyAccessException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.ShallowDocumentModel;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.ec.notification.NotificationImpl;
import org.nuxeo.ecm.platform.ec.notification.NotificationListenerHook;
import org.nuxeo.ecm.platform.ec.notification.NotificationListenerVeto;
import org.nuxeo.ecm.platform.ec.notification.email.EmailHelper;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationService;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.notification.api.Notification;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.url.codec.api.DocumentViewCodec;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class NotificationEventListener
implements PostCommitFilteringEventListener {
    private static final Log log = LogFactory.getLog(NotificationEventListener.class);
    private static final String CHECK_READ_PERMISSION_PROPERTY = "notification.check.read.permission";
    public static final String NOTIFICATION_DOCUMENT_ID_CODEC_NAME = "notificationDocId";
    public static final String JSF_NOTIFICATION_DOCUMENT_ID_CODEC_PREFIX = "nxdoc";
    private UserManager userManager;
    private EmailHelper emailHelper = new EmailHelper();
    private NotificationService notificationService = NotificationServiceHelper.getNotificationService();

    public boolean acceptEvent(Event event) {
        if (this.notificationService == null) {
            return false;
        }
        return this.notificationService.getNotificationEventNames().contains(event.getName());
    }

    public void handleEvent(EventBundle events) {
        if (this.notificationService == null) {
            log.error((Object)"Unable to get NotificationService, exiting");
            return;
        }
        boolean processEvents = false;
        for (String name : this.notificationService.getNotificationEventNames()) {
            if (!events.containsEventName(name)) continue;
            processEvents = true;
            break;
        }
        if (!processEvents) {
            return;
        }
        for (Event event : events) {
            List<Notification> notifs;
            Boolean block = (Boolean)event.getContext().getProperty("disableNotificationService");
            if (block != null && block.booleanValue() || (notifs = this.notificationService.getNotificationsForEvents(event.getName())) == null || notifs.isEmpty()) continue;
            this.handleNotifications(event, notifs);
        }
    }

    protected void handleNotifications(Event event, List<Notification> notifs) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            log.warn((Object)"Can not handle notification on a event that is not bound to a DocumentEventContext");
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        if (docCtx.getSourceDocument() instanceof ShallowDocumentModel) {
            log.trace((Object)"Can not handle notification on a event that is bound to a ShallowDocument");
            return;
        }
        CoreSession coreSession = event.getContext().getCoreSession();
        Map properties = event.getContext().getProperties();
        HashMap<Notification, List<String>> targetUsers = new HashMap<Notification, List<String>>();
        for (NotificationListenerVeto veto : this.notificationService.getNotificationVetos()) {
            if (veto.accept(event)) continue;
            return;
        }
        for (NotificationListenerHook hookListener : this.notificationService.getListenerHooks()) {
            hookListener.handleNotifications(event);
        }
        this.gatherConcernedUsersForDocument(coreSession, docCtx.getSourceDocument(), notifs, targetUsers);
        for (Notification notif : targetUsers.keySet()) {
            if (!notif.getAutoSubscribed()) {
                for (String user : (List)targetUsers.get(notif)) {
                    this.sendNotificationSignalForUser(notif, user, event, docCtx);
                }
                continue;
            }
            Object recipientProperty = properties.get("recipients");
            String[] recipients = null;
            if (recipientProperty != null) {
                if (recipientProperty instanceof String[]) {
                    recipients = (String[])properties.get("recipients");
                } else if (recipientProperty instanceof String) {
                    recipients = new String[]{(String)recipientProperty};
                }
            }
            if (recipients == null) continue;
            HashSet<String> users = new HashSet<String>();
            for (String recipient : recipients) {
                if (recipient == null) continue;
                if (recipient.contains("user:")) {
                    users.add(recipient.replace("user:", ""));
                    continue;
                }
                if (recipient.contains("group:")) {
                    List<String> groupMembers = this.getGroupMembers(recipient.replace("group:", ""));
                    for (String member : groupMembers) {
                        users.add(member);
                    }
                    continue;
                }
                if (NotificationServiceHelper.getUsersService().getGroup(recipient) != null) {
                    users.addAll(this.getGroupMembers(recipient));
                    continue;
                }
                users.add(recipient);
            }
            for (String user : users) {
                this.sendNotificationSignalForUser(notif, user, event, docCtx);
            }
        }
    }

    protected UserManager getUserManager() {
        if (this.userManager == null) {
            this.userManager = (UserManager)Framework.getService(UserManager.class);
        }
        return this.userManager;
    }

    protected List<String> getGroupMembers(String groupId) {
        return this.getUserManager().getUsersInGroupAndSubGroups(groupId);
    }

    protected void sendNotificationSignalForUser(Notification notification, String subscriptor, Event event, DocumentEventContext ctx) {
        if ("system".equals(subscriptor)) {
            return;
        }
        NuxeoPrincipal principal = this.getUserManager().getPrincipal(subscriptor);
        if (principal == null) {
            log.error((Object)("No Nuxeo principal found for '" + subscriptor + "'. No notification will be sent to this user"));
            return;
        }
        if (Boolean.parseBoolean(Framework.getProperty((String)CHECK_READ_PERMISSION_PROPERTY)) && !ctx.getCoreSession().hasPermission(principal, ctx.getSourceDocument().getRef(), "Read")) {
            log.debug((Object)("Notification will not be sent: + '" + subscriptor + "' do not have Read permission on document " + ctx.getSourceDocument().getId()));
            return;
        }
        log.debug((Object)"Producing notification message.");
        Map eventInfo = ctx.getProperties();
        DocumentModel doc = ctx.getSourceDocument();
        String author = ctx.getPrincipal().getName();
        Calendar created = (Calendar)ctx.getSourceDocument().getPropertyValue("dc:created");
        DocumentViewCodecManager codecService = (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
        DocumentViewCodec codec = codecService.getCodec(NOTIFICATION_DOCUMENT_ID_CODEC_NAME);
        boolean isNotificationCodec = codec != null;
        boolean isJSFUI = isNotificationCodec && JSF_NOTIFICATION_DOCUMENT_ID_CODEC_PREFIX.equals(codec.getPrefix());
        eventInfo.put("isJSFUI", isJSFUI);
        eventInfo.put("destination", subscriptor);
        eventInfo.put("notification", notification);
        eventInfo.put("docId", doc.getId());
        eventInfo.put("dateTime", new Date(event.getTime()));
        eventInfo.put("author", author);
        eventInfo.put("docVersion", doc.getVersionLabel());
        eventInfo.put("docState", doc.getCurrentLifeCycleState());
        eventInfo.put("docCreated", created.getTime());
        if (isNotificationCodec) {
            StringBuilder userUrl = new StringBuilder();
            userUrl.append(this.notificationService.getServerUrlPrefix());
            if (!isJSFUI) {
                userUrl.append("ui/");
                userUrl.append("#!/");
            }
            userUrl.append("user/").append(ctx.getPrincipal().getName());
            eventInfo.put("userUrl", userUrl.toString());
        }
        eventInfo.put("docLocation", doc.getPathAsString());
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh != null && bh.getBlob() != null) {
            DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
            String filename = bh.getBlob().getFilename();
            String docMainFile = this.notificationService.getServerUrlPrefix() + downloadService.getDownloadUrl(doc, "blobholder:0", filename);
            eventInfo.put("docMainFileUrl", docMainFile);
        }
        if (!this.isDeleteEvent(event.getName())) {
            if (isNotificationCodec) {
                eventInfo.put("docUrl", codecService.getUrlFromDocumentView(NOTIFICATION_DOCUMENT_ID_CODEC_NAME, (DocumentView)new DocumentViewImpl(doc), true, this.notificationService.getServerUrlPrefix()));
            }
            eventInfo.put("docTitle", doc.getTitle());
        }
        if (this.isInterestedInNotification(notification)) {
            this.sendNotification(event, ctx);
            if (log.isDebugEnabled()) {
                log.debug((Object)("notification " + notification.getName() + " sent to " + notification.getSubject()));
            }
        }
    }

    public void sendNotification(Event event, DocumentEventContext ctx) {
        String mailTemplate;
        String subjectTemplate;
        String email;
        NotificationImpl notif;
        Map eventInfo;
        String eventId;
        block11: {
            eventId = event.getName();
            log.debug((Object)("Received a message for notification sender with eventId : " + eventId));
            eventInfo = ctx.getProperties();
            String userDest = (String)eventInfo.get("destination");
            notif = (NotificationImpl)eventInfo.get("notification");
            NuxeoPrincipal recepient = NotificationServiceHelper.getUsersService().getPrincipal(userDest);
            if (recepient == null) {
                log.error((Object)("Couldn't find user: " + userDest + " to send her a mail."));
                return;
            }
            email = recepient.getEmail();
            if (email == null || "".equals(email)) {
                log.error((Object)("No email found for user: " + userDest));
                return;
            }
            subjectTemplate = notif.getSubjectTemplate();
            mailTemplate = null;
            if (notif.getTemplateExpr() != null) {
                try {
                    mailTemplate = this.emailHelper.evaluateMvelExpresssion(notif.getTemplateExpr(), eventInfo);
                }
                catch (PropertyAccessException pae) {
                    if (!log.isDebugEnabled()) break block11;
                    log.debug((Object)("Cannot evaluate mail template expression '" + notif.getTemplateExpr() + "' in that context " + eventInfo), (Throwable)pae);
                }
            }
        }
        if (StringUtils.isEmpty(mailTemplate)) {
            mailTemplate = notif.getTemplate();
        }
        log.debug((Object)("email: " + email));
        log.debug((Object)("mail template: " + mailTemplate));
        log.debug((Object)("subject template: " + subjectTemplate));
        HashMap<String, Object> mail = new HashMap<String, Object>();
        mail.put("mail.to", email);
        String authorUsername = (String)eventInfo.get("author");
        if (authorUsername != null) {
            NuxeoPrincipal author = NotificationServiceHelper.getUsersService().getPrincipal(authorUsername);
            mail.put("principalAuthor", author);
        }
        mail.put("document", ctx.getSourceDocument());
        String subject = notif.getSubject() == null ? "notification" : notif.getSubject();
        subject = this.notificationService.getEMailSubjectPrefix() + subject;
        mail.put("subject", subject);
        mail.put("template", mailTemplate);
        mail.put("subjectTemplate", subjectTemplate);
        Iterator iterator = eventInfo.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            mail.put(key, eventInfo.get(key = (String)iterator.next()) == null ? "" : eventInfo.get(key));
            log.debug((Object)("Mail prop: " + key));
        }
        mail.put("eventId", eventId);
        try {
            this.emailHelper.sendmail(mail);
        }
        catch (MessagingException e) {
            String cause = "";
            if (e instanceof SendFailedException && e.getCause() instanceof SendFailedException) {
                cause = " - Cause: " + e.getCause().getMessage();
            }
            log.warn((Object)("Failed to send notification email to '" + email + "': " + ((Object)((Object)e)).getClass().getName() + ": " + e.getMessage() + cause));
        }
    }

    private void gatherConcernedUsersForDocument(CoreSession coreSession, DocumentModel doc, List<Notification> notifs, Map<Notification, List<String>> targetUsers) {
        if (doc.getPath().segmentCount() > 1) {
            log.debug((Object)("Searching document: " + doc.getName()));
            this.getInterstedUsers(doc, notifs, targetUsers);
            if (doc.getParentRef() != null && coreSession.exists(doc.getParentRef())) {
                DocumentModel parent = this.getDocumentParent(coreSession, doc);
                this.gatherConcernedUsersForDocument(coreSession, parent, notifs, targetUsers);
            }
        }
    }

    private DocumentModel getDocumentParent(CoreSession coreSession, DocumentModel doc) {
        if (doc == null) {
            return null;
        }
        return coreSession.getDocument(doc.getParentRef());
    }

    private void getInterstedUsers(DocumentModel doc, List<Notification> notifs, Map<Notification, List<String>> targetUsers) {
        for (Notification notification : notifs) {
            if (!notification.getAutoSubscribed()) {
                List<String> userGroup = this.notificationService.getSubscribers(notification.getName(), doc);
                for (String subscriptor : userGroup) {
                    if (subscriptor == null) continue;
                    if (this.isUser(subscriptor)) {
                        NotificationEventListener.storeUserForNotification(notification, subscriptor.substring(5), targetUsers);
                        continue;
                    }
                    List<String> usersOfGroup = this.getGroupMembers(subscriptor.substring(6));
                    if (usersOfGroup == null || usersOfGroup.isEmpty()) continue;
                    for (String usr : usersOfGroup) {
                        NotificationEventListener.storeUserForNotification(notification, usr, targetUsers);
                    }
                }
                continue;
            }
            targetUsers.put(notification, new ArrayList());
        }
    }

    private static void storeUserForNotification(Notification notification, String user, Map<Notification, List<String>> targetUsers) {
        List subscribedUsers = targetUsers.computeIfAbsent(notification, k -> new ArrayList());
        if (!subscribedUsers.contains(user)) {
            subscribedUsers.add(user);
        }
    }

    private boolean isDeleteEvent(String eventId) {
        ArrayList<String> deletionEvents = new ArrayList<String>();
        deletionEvents.add("aboutToRemove");
        deletionEvents.add("documentRemoved");
        return deletionEvents.contains(eventId);
    }

    private boolean isUser(String subscriptor) {
        return subscriptor != null && subscriptor.startsWith("user:");
    }

    public boolean isInterestedInNotification(Notification notif) {
        return notif != null && "email".equals(notif.getChannel());
    }

    public EmailHelper getEmailHelper() {
        return this.emailHelper;
    }

    public void setEmailHelper(EmailHelper emailHelper) {
        this.emailHelper = emailHelper;
    }
}

