/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.resolver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.nuxeo.ecm.core.schema.types.resolver.AbstractObjectResolver;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;

public class TestingColorResolver
extends AbstractObjectResolver
implements ObjectResolver {
    public static final String COLOR_MODE = "mode";
    public static final String NAME = "colorReference";
    private MODE mode;
    private List<Class<?>> managedClasses = null;

    @Override
    public List<Class<?>> getManagedClasses() {
        if (this.managedClasses == null) {
            this.managedClasses = new ArrayList();
            this.managedClasses.add(Color.class);
        }
        return this.managedClasses;
    }

    @Override
    public void configure(Map<String, String> parameters) throws IllegalStateException, IllegalArgumentException {
        super.configure(parameters);
        String modeParam = parameters.get(COLOR_MODE);
        if (modeParam == null || modeParam.trim().isEmpty()) {
            throw new IllegalArgumentException("missing mode param");
        }
        try {
            this.mode = MODE.valueOf(modeParam);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("missing mode param", e);
        }
        this.parameters.put(COLOR_MODE, this.mode.name());
    }

    @Override
    public String getName() throws IllegalStateException {
        this.checkConfig();
        return NAME;
    }

    @Override
    public Color fetch(Object value) throws IllegalStateException {
        this.checkConfig();
        if (value instanceof String) {
            String ref = (String)value;
            switch (this.mode) {
                case PRIMARY: {
                    for (PrimaryColor color : PrimaryColor.values()) {
                        if (!color.name().equals(ref)) continue;
                        return color;
                    }
                    break;
                }
                case SECONDARY: {
                    for (SecondaryColor color : SecondaryColor.values()) {
                        if (!color.name().equals(ref)) continue;
                        return color;
                    }
                    break;
                }
            }
        }
        return null;
    }

    @Override
    public <T> T fetch(Class<T> type, Object value) throws IllegalStateException {
        this.checkConfig();
        if (Color.class.equals(type)) {
            return (T)this.fetch(value);
        }
        if (this.mode == MODE.PRIMARY && PrimaryColor.class.equals(type)) {
            return (T)this.fetch(value);
        }
        if (this.mode == MODE.SECONDARY && SecondaryColor.class.equals(type)) {
            return (T)this.fetch(value);
        }
        return null;
    }

    @Override
    public Serializable getReference(Object entity) throws IllegalStateException {
        this.checkConfig();
        if (entity instanceof Color) {
            Color color = (Color)entity;
            switch (this.mode) {
                case PRIMARY: {
                    if (!(color instanceof PrimaryColor)) break;
                    return color.name();
                }
                case SECONDARY: {
                    if (!(color instanceof SecondaryColor)) break;
                    return color.name();
                }
            }
        }
        return null;
    }

    @Override
    public String getConstraintErrorMessage(Object invalidValue, Locale locale) {
        this.checkConfig();
        return String.format("\"%s\" is not a correct %s color", invalidValue, this.mode.name().toLowerCase());
    }

    public static enum SecondaryColor implements Color
    {
        VIOLET,
        ORANGE,
        GREEN;

    }

    public static enum PrimaryColor implements Color
    {
        RED,
        BLUE,
        YELLOW;

    }

    public static interface Color {
        public String name();
    }

    public static enum MODE {
        PRIMARY,
        SECONDARY;

    }
}

