/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.api;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.apidoc.api.DocumentationItem;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractDocumentationItem
implements DocumentationItem {
    protected static final Log log = LogFactory.getLog(AbstractDocumentationItem.class);
    final String typeLabel;

    protected AbstractDocumentationItem(String typeLabel) {
        this.typeLabel = typeLabel;
    }

    @Override
    public int compareTo(DocumentationItem o) {
        ArrayList<String> myVersions = new ArrayList<String>(this.getApplicableVersion());
        ArrayList<String> otherVersions = new ArrayList<String>(o.getApplicableVersion());
        Collections.sort(myVersions);
        Collections.sort(otherVersions);
        Collections.reverse(myVersions);
        Collections.reverse(otherVersions);
        if (myVersions.isEmpty()) {
            if (otherVersions.isEmpty()) {
                return 0;
            }
            return 1;
        }
        if (otherVersions.isEmpty()) {
            return -1;
        }
        return ((String)myVersions.get(0)).compareTo((String)otherVersions.get(0));
    }

    @Override
    public String getTypeLabel() {
        return this.typeLabel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String typeLabelOf(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return "";
        }
        DirectoryService dm = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = dm.open("documentationTypes");){
            DocumentModel entry = session.getEntry(type);
            if (entry == null) return type;
            String string = (String)entry.getProperty("vocabulary", "label");
            return string;
        }
        catch (PropertyException | DirectoryException e) {
            log.error((Object)"Error while resolving typeLabel", e);
        }
        return type;
    }
}

