/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.introspection;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.nuxeo.apidoc.documentation.DefaultDocumentationType;
import org.nuxeo.apidoc.documentation.ResourceDocumentationItem;
import org.nuxeo.apidoc.introspection.BundleInfoImpl;
import org.nuxeo.common.utils.Path;

public class EmbeddedDocExtractor {
    public static final String DOC_PREFIX = "doc/";
    public static final String PARENT_DOC_PREFIX = "doc-parent/";

    public static void extractEmbeddedDoc(ZipFile jarFile, BundleInfoImpl bi) throws IOException {
        Enumeration<? extends ZipEntry> entries = jarFile.entries();
        HashMap<String, ResourceDocumentationItem> localDocs = new HashMap<String, ResourceDocumentationItem>();
        HashMap<String, ResourceDocumentationItem> parentDocs = new HashMap<String, ResourceDocumentationItem>();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            InputStream is = jarFile.getInputStream(entry);
            Throwable throwable = null;
            try {
                ResourceDocumentationItem docItem;
                String name;
                String content;
                if (entry.getName().startsWith(PARENT_DOC_PREFIX) && !entry.isDirectory()) {
                    content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    name = new Path(entry.getName()).lastSegment();
                    if (name.length() >= 6 && name.substring(0, 6).equalsIgnoreCase("readme")) {
                        docItem = new ResourceDocumentationItem(name, content, DefaultDocumentationType.DESCRIPTION.toString(), bi);
                        parentDocs.put(DefaultDocumentationType.DESCRIPTION.toString(), docItem);
                    } else {
                        docItem = new ResourceDocumentationItem(name, content, DefaultDocumentationType.HOW_TO.toString(), bi);
                        parentDocs.put(DefaultDocumentationType.HOW_TO.toString(), docItem);
                    }
                }
                if (!entry.getName().startsWith(DOC_PREFIX) || entry.isDirectory()) continue;
                content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                name = new Path(entry.getName()).lastSegment();
                if (name.length() >= 6 && name.substring(0, 6).equalsIgnoreCase("readme")) {
                    docItem = new ResourceDocumentationItem(name, content, DefaultDocumentationType.DESCRIPTION.toString(), bi);
                    localDocs.put(DefaultDocumentationType.DESCRIPTION.toString(), docItem);
                    continue;
                }
                docItem = new ResourceDocumentationItem(name, content, DefaultDocumentationType.HOW_TO.toString(), bi);
                localDocs.put(DefaultDocumentationType.HOW_TO.toString(), docItem);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        bi.setLiveDoc(localDocs);
        bi.setParentLiveDoc(parentDocs);
    }
}

