/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nuxeo.apidoc.adapters.BaseNuxeoArtifactDocAdapter;
import org.nuxeo.apidoc.api.BundleGroup;
import org.nuxeo.apidoc.api.BundleInfo;
import org.nuxeo.apidoc.api.ComponentInfo;
import org.nuxeo.apidoc.api.ExtensionInfo;
import org.nuxeo.apidoc.api.ExtensionPointInfo;
import org.nuxeo.apidoc.api.NuxeoArtifact;
import org.nuxeo.apidoc.api.OperationInfo;
import org.nuxeo.apidoc.api.QueryHelper;
import org.nuxeo.apidoc.api.SeamComponentInfo;
import org.nuxeo.apidoc.api.ServiceInfo;
import org.nuxeo.apidoc.documentation.JavaDocHelper;
import org.nuxeo.apidoc.introspection.ServerInfo;
import org.nuxeo.apidoc.snapshot.DistributionSnapshot;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.query.sql.NXQL;

public class RepositoryDistributionSnapshot
extends BaseNuxeoArtifactDocAdapter
implements DistributionSnapshot {
    protected JavaDocHelper jdocHelper = null;

    public static RepositoryDistributionSnapshot create(DistributionSnapshot distrib, CoreSession session, String containerPath, String label, Map<String, Serializable> properties) {
        DocumentModel doc = session.createDocumentModel("NXDistribution");
        String name = RepositoryDistributionSnapshot.computeDocumentName(distrib.getKey());
        if (label != null) {
            name = RepositoryDistributionSnapshot.computeDocumentName(label);
        }
        String targetPath = new Path(containerPath).append(name).toString();
        boolean exist = false;
        if (session.exists((DocumentRef)new PathRef(targetPath))) {
            exist = true;
            doc = session.getDocument((DocumentRef)new PathRef(targetPath));
        }
        if (properties != null) {
            properties.forEach((arg_0, arg_1) -> ((DocumentModel)doc).setPropertyValue(arg_0, arg_1));
        }
        doc.setPathInfo(containerPath, name);
        if (label == null) {
            doc.setPropertyValue("dc:title", (Serializable)((Object)distrib.getKey()));
            doc.setPropertyValue("nxdistribution:key", (Serializable)((Object)distrib.getKey()));
            doc.setPropertyValue("nxdistribution:name", (Serializable)((Object)distrib.getName()));
        } else {
            doc.setPropertyValue("dc:title", (Serializable)((Object)label));
            doc.setPropertyValue("nxdistribution:key", (Serializable)((Object)(label + "-" + distrib.getVersion())));
            doc.setPropertyValue("nxdistribution:name", (Serializable)((Object)label));
        }
        doc.setPropertyValue("nxdistribution:latestFT", (Serializable)Boolean.valueOf(distrib.isLatestFT()));
        doc.setPropertyValue("nxdistribution:latestLTS", (Serializable)Boolean.valueOf(distrib.isLatestLTS()));
        doc.setPropertyValue("nxdistribution:version", (Serializable)((Object)distrib.getVersion()));
        DocumentModel ret = exist ? session.saveDocument(doc) : session.createDocument(doc);
        return new RepositoryDistributionSnapshot(ret);
    }

    public static List<DistributionSnapshot> readPersistentSnapshots(CoreSession session) {
        ArrayList<DistributionSnapshot> result = new ArrayList<DistributionSnapshot>();
        String query = "SELECT * FROM NXDistribution where ecm:isTrashed = 0 AND ecm:isVersion = 0";
        DocumentModelList docs = session.query(query);
        for (DocumentModel child : docs) {
            DistributionSnapshot ob = (DistributionSnapshot)child.getAdapter(DistributionSnapshot.class);
            if (ob == null) continue;
            result.add(ob);
        }
        return result;
    }

    public RepositoryDistributionSnapshot(DocumentModel doc) {
        super(doc);
    }

    protected <T> List<T> getChildren(Class<T> adapter, String docType) {
        ArrayList<Object> result = new ArrayList<Object>();
        String query = QueryHelper.select(docType, this.doc);
        DocumentModelList docs = this.getCoreSession().query(query);
        for (DocumentModel child : docs) {
            Object ob = child.getAdapter(adapter);
            if (ob == null) continue;
            result.add(ob);
        }
        return result;
    }

    protected <T> T getChild(Class<T> adapter, String docType, String idField, String id) {
        String query = QueryHelper.select(docType, this.doc) + " AND " + idField + " = " + NXQL.escapeString((String)id);
        DocumentModelList docs = this.getCoreSession().query(query);
        if (!docs.isEmpty()) {
            if (docs.size() == 1) {
                return (T)((DocumentModel)docs.get(0)).getAdapter(adapter);
            }
            log.error((Object)("multiple match for " + docType + " for id " + id));
            return (T)((DocumentModel)docs.get(0)).getAdapter(adapter);
        }
        log.error((Object)("Unable to find " + docType + " for id " + id));
        return null;
    }

    @Override
    public BundleInfo getBundle(String id) {
        return this.getChild(BundleInfo.class, "NXBundle", "nxbundle:bundleId", id);
    }

    @Override
    public BundleGroup getBundleGroup(String groupId) {
        return this.getChild(BundleGroup.class, "NXBundleGroup", "nxbundlegroup:key", groupId);
    }

    protected DocumentModel getBundleContainer() {
        PathRef ref = new PathRef(this.doc.getPathAsString(), "Bundles");
        if (this.getCoreSession().exists((DocumentRef)ref)) {
            return this.getCoreSession().getDocument((DocumentRef)ref);
        }
        return this.doc;
    }

    @Override
    public List<BundleGroup> getBundleGroups() {
        ArrayList<BundleGroup> grps = new ArrayList<BundleGroup>();
        String query = QueryHelper.select("NXBundleGroup", this.doc, "ecm:parentId", this.getBundleContainer().getId());
        DocumentModelList docs = this.getCoreSession().query(query);
        for (DocumentModel child : docs) {
            BundleGroup bg = (BundleGroup)child.getAdapter(BundleGroup.class);
            if (bg == null) continue;
            grps.add(bg);
        }
        return grps;
    }

    @Override
    public List<String> getBundleIds() {
        return this.getChildren(BundleInfo.class, "NXBundle").stream().map(NuxeoArtifact::getId).collect(Collectors.toList());
    }

    @Override
    public ComponentInfo getComponent(String id) {
        return this.getChild(ComponentInfo.class, "NXComponent", "nxcomponent:componentId", id);
    }

    @Override
    public List<String> getComponentIds() {
        return this.getChildren(ComponentInfo.class, "NXComponent").stream().map(NuxeoArtifact::getId).collect(Collectors.toList());
    }

    @Override
    public ExtensionInfo getContribution(String id) {
        return this.getChild(ExtensionInfo.class, "NXContribution", "nxcontribution:contribId", id);
    }

    @Override
    public List<String> getContributionIds() {
        return this.getChildren(ExtensionInfo.class, "NXContribution").stream().map(NuxeoArtifact::getId).collect(Collectors.toList());
    }

    @Override
    public List<ExtensionInfo> getContributions() {
        return this.getChildren(ExtensionInfo.class, "NXContribution");
    }

    @Override
    public ExtensionPointInfo getExtensionPoint(String id) {
        return this.getChild(ExtensionPointInfo.class, "NXExtensionPoint", "nxextensionpoint:epId", id);
    }

    @Override
    public List<String> getExtensionPointIds() {
        return this.getChildren(ExtensionPointInfo.class, "NXExtensionPoint").stream().map(NuxeoArtifact::getId).collect(Collectors.toList());
    }

    @Override
    public List<String> getBundleGroupChildren(String groupId) {
        BundleGroup bg = this.getChild(BundleGroup.class, "NXBundleGroup", "nxbundlegroup:key", groupId);
        return bg.getBundleIds();
    }

    public List<String> getBundleGroupIds() {
        return this.getChildren(BundleGroup.class, "NXBundleGroup").stream().map(NuxeoArtifact::getId).collect(Collectors.toList());
    }

    @Override
    public List<String> getServiceIds() {
        HashSet<String> ids = new HashSet<String>();
        String query = QueryHelper.select("NXComponent", this.doc);
        DocumentModelList components = this.getCoreSession().query(query);
        for (DocumentModel componentDoc : components) {
            ComponentInfo ci = (ComponentInfo)componentDoc.getAdapter(ComponentInfo.class);
            if (ci == null) continue;
            ids.addAll(ci.getServiceNames());
        }
        return new ArrayList<String>(ids);
    }

    @Override
    public String getName() {
        try {
            return (String)((Object)this.doc.getPropertyValue("nxdistribution:name"));
        }
        catch (PropertyException e) {
            log.error((Object)"Error while reading nxdistribution:name", (Throwable)e);
            return "!unknown!";
        }
    }

    @Override
    public String getVersion() {
        try {
            return (String)((Object)this.doc.getPropertyValue("nxdistribution:version"));
        }
        catch (PropertyException e) {
            log.error((Object)"Error while reading nxdistribution:version", (Throwable)e);
            return "!unknown!";
        }
    }

    @Override
    public String getKey() {
        try {
            return (String)((Object)this.doc.getPropertyValue("nxdistribution:key"));
        }
        catch (PropertyException e) {
            log.error((Object)"Error while reading nxdistribution:key", (Throwable)e);
            return "!unknown!";
        }
    }

    @Override
    public List<Class<?>> getSpi() {
        return null;
    }

    @Override
    public String getId() {
        return this.getKey();
    }

    @Override
    public String getArtifactType() {
        return "NXDistribution";
    }

    @Override
    public ServiceInfo getService(String id) {
        String query = QueryHelper.select("NXService", this.getDoc()) + " AND " + "nxservice:className" + " = " + NXQL.escapeString((String)id) + " AND (" + "nxservice:overriden" + " = 0 OR " + "nxservice:overriden" + " is NULL)";
        DocumentModelList docs = this.getCoreSession().query(query);
        if (docs.size() > 1) {
            throw new AssertionError((Object)("Multiple services found for " + id));
        }
        return (ServiceInfo)((DocumentModel)docs.get(0)).getAdapter(ServiceInfo.class);
    }

    @Override
    public List<String> getJavaComponentIds() {
        return this.getChildren(ComponentInfo.class, "NXComponent").stream().filter(ci -> !ci.isXmlPureComponent()).map(NuxeoArtifact::getId).collect(Collectors.toList());
    }

    @Override
    public List<String> getXmlComponentIds() {
        return this.getChildren(ComponentInfo.class, "NXComponent").stream().filter(ComponentInfo::isXmlPureComponent).map(NuxeoArtifact::getId).collect(Collectors.toList());
    }

    @Override
    public Date getCreationDate() {
        try {
            Calendar cal = (Calendar)this.getDoc().getPropertyValue("dc:created");
            return cal == null ? null : cal.getTime();
        }
        catch (PropertyException e) {
            return null;
        }
    }

    @Override
    public Date getReleaseDate() {
        try {
            Calendar cal = (Calendar)this.getDoc().getPropertyValue("nxdistribution:released");
            return cal == null ? this.getCreationDate() : cal.getTime();
        }
        catch (PropertyException e) {
            return null;
        }
    }

    @Override
    public boolean isLive() {
        return false;
    }

    @Override
    public SeamComponentInfo getSeamComponent(String id) {
        String name = id.replace("seam:", "");
        String query = QueryHelper.select("NXSeamComponent", this.getDoc()) + " AND " + "nxseam:componentName" + " = " + NXQL.escapeString((String)name);
        DocumentModelList docs = this.getCoreSession().query(query);
        return docs.isEmpty() ? null : (SeamComponentInfo)((DocumentModel)docs.get(0)).getAdapter(SeamComponentInfo.class);
    }

    @Override
    public List<String> getSeamComponentIds() {
        ArrayList<String> result = new ArrayList<String>();
        String query = QueryHelper.select("NXSeamComponent", this.getDoc());
        DocumentModelList docs = this.getCoreSession().query(query);
        for (DocumentModel doc : docs) {
            result.add(((SeamComponentInfo)doc.getAdapter(SeamComponentInfo.class)).getId());
        }
        return result;
    }

    @Override
    public List<SeamComponentInfo> getSeamComponents() {
        ArrayList<SeamComponentInfo> result = new ArrayList<SeamComponentInfo>();
        String query = QueryHelper.select("NXSeamComponent", this.getDoc());
        DocumentModelList docs = this.getCoreSession().query(query);
        for (DocumentModel doc : docs) {
            result.add((SeamComponentInfo)doc.getAdapter(SeamComponentInfo.class));
        }
        return result;
    }

    @Override
    public boolean containsSeamComponents() {
        return this.getSeamComponentIds().size() > 0;
    }

    @Override
    public OperationInfo getOperation(String id) {
        if (id.startsWith("op:")) {
            id = id.substring("op:".length());
        }
        String query = QueryHelper.select("NXOperation", this.getDoc()) + " AND " + "nxop:name" + " = " + NXQL.escapeString((String)id) + " OR " + "nxop:aliases" + " = " + NXQL.escapeString((String)id);
        DocumentModelList docs = this.getCoreSession().query(query);
        return docs.isEmpty() ? null : (OperationInfo)((DocumentModel)docs.get(0)).getAdapter(OperationInfo.class);
    }

    @Override
    public List<OperationInfo> getOperations() {
        ArrayList<OperationInfo> result = new ArrayList<OperationInfo>();
        String query = QueryHelper.select("NXOperation", this.getDoc());
        DocumentModelList docs = this.getCoreSession().query(query);
        for (DocumentModel doc : docs) {
            result.add((OperationInfo)doc.getAdapter(OperationInfo.class));
        }
        return result;
    }

    public JavaDocHelper getJavaDocHelper() {
        if (this.jdocHelper == null) {
            this.jdocHelper = JavaDocHelper.getHelper(this.getName(), this.getVersion());
        }
        return this.jdocHelper;
    }

    @Override
    public void cleanPreviousArtifacts() {
        String query = QueryHelper.select("Document", this.getDoc());
        ArrayList<DocumentRef> refs = new ArrayList<DocumentRef>();
        DocumentModelList docs = this.getCoreSession().query(query);
        for (DocumentModel doc : docs) {
            refs.add(doc.getRef());
        }
        this.getCoreSession().removeDocuments(refs.toArray(new DocumentRef[refs.size()]));
    }

    @Override
    public boolean isLatestFT() {
        try {
            return (Boolean)this.doc.getPropertyValue("nxdistribution:latestFT");
        }
        catch (PropertyException e) {
            log.error((Object)"Error while reading nxdistribution:latestFT", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isLatestLTS() {
        try {
            return (Boolean)this.doc.getPropertyValue("nxdistribution:latestLTS");
        }
        catch (PropertyException e) {
            log.error((Object)"Error while reading nxdistribution:latestLTS", (Throwable)e);
            return false;
        }
    }

    @Override
    public List<String> getAliases() {
        List aliases = (List)((Object)this.doc.getPropertyValue("nxdistribution:aliases"));
        if (this.isLatestLTS()) {
            aliases.add("latestLTS");
        } else if (this.isLatestFT()) {
            aliases.add("latestFT");
        }
        return aliases;
    }

    @Override
    public boolean isHidden() {
        return Boolean.TRUE.equals(this.doc.getPropertyValue("nxdistribution:hide"));
    }

    @Override
    public ServerInfo getServerInfo() {
        throw new UnsupportedOperationException();
    }
}

