/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Predicate;

public class MultiExpression
extends Predicate {
    private static final long serialVersionUID = 1L;
    public final List<Predicate> predicates;

    public MultiExpression(Operator operator, List<Predicate> predicates) {
        super(null, operator, null);
        this.predicates = predicates;
    }

    public MultiExpression(MultiExpression other) {
        this(other.operator, new ArrayList<Predicate>(other.predicates));
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitMultiExpression(this);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.operator);
        buf.append('(');
        Iterator<Predicate> it = this.predicates.iterator();
        while (it.hasNext()) {
            Predicate predicate = it.next();
            buf.append(predicate.toString());
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MultiExpression) {
            return this.equals((MultiExpression)other);
        }
        return false;
    }

    protected boolean equals(MultiExpression other) {
        return this.predicates.equals(other.predicates) && super.equals(other);
    }

    @Override
    public int hashCode() {
        return this.predicates.hashCode() + super.hashCode();
    }
}

