/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.storage.sql.ColumnSpec;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Delete;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Insert;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Select;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Update;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.core.utils.SIDGenerator;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.OperationNotAllowedException;
import org.nuxeo.ecm.directory.PasswordHelper;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.ecm.directory.sql.SQLDirectoryDescriptor;
import org.nuxeo.ecm.directory.sql.SQLQueryBuilder;
import org.nuxeo.ecm.directory.sql.SQLStaticFilter;
import org.nuxeo.ecm.directory.sql.TableReference;
import org.nuxeo.ecm.directory.sql.filter.SQLComplexFilter;

public class SQLSession
extends BaseSession {
    private static final Log log = LogFactory.getLog(SQLSession.class);
    private static final boolean HIDE_PASSWORD_IN_LOGS = true;
    final Table table;
    protected SQLStaticFilter[] staticFilters;
    String sid;
    Connection sqlConnection;
    protected final Dialect dialect;
    protected JDBCLogger logger = new JDBCLogger("SQLDirectory");

    public SQLSession(SQLDirectory directory, SQLDirectoryDescriptor config) {
        super((Directory)directory, TableReference.class);
        this.table = directory.getTable();
        this.dialect = directory.getDialect();
        this.sid = String.valueOf(SIDGenerator.next());
        this.staticFilters = config.getStaticFilters();
        this.acquireConnection();
    }

    public SQLDirectory getDirectory() {
        return (SQLDirectory)this.directory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocumentModel getEntryFromSource(String id, boolean fetchReferences) {
        this.acquireConnection();
        Select select = new Select(this.table);
        select.setFrom(this.table.getQuotedName());
        select.setWhat(this.getReadColumnsSQL());
        String whereClause = this.table.getPrimaryColumn().getQuotedName() + " = ?";
        whereClause = this.addFilterWhereClause(whereClause);
        select.setWhere(whereClause);
        String sql = select.getStatement();
        if (this.logger.isLogEnabled()) {
            ArrayList<Serializable> values = new ArrayList<Serializable>();
            values.add((Serializable)((Object)id));
            this.addFilterValuesForLog(values);
            this.logger.logSQL(sql, values);
        }
        try (PreparedStatement ps = this.sqlConnection.prepareStatement(sql);){
            String entryTenantId;
            String tenantId;
            this.setFieldValue(ps, 1, this.table.getPrimaryColumn(), id);
            this.addFilterValues(ps, 2);
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) {
                    DocumentModel documentModel = null;
                    return documentModel;
                }
                for (Column column : this.getReadColumns()) {
                    Object value = this.getFieldValue(rs, column);
                    fieldMap.put(column.getKey(), value);
                }
                if (this.logger.isLogEnabled()) {
                    this.logger.logResultSet(rs, this.getReadColumns());
                }
            }
            if (this.isMultiTenant() && !StringUtils.isBlank((CharSequence)(tenantId = this.getCurrentTenantId())) && !StringUtils.isBlank((CharSequence)(entryTenantId = (String)fieldMap.get("tenantId"))) && !entryTenantId.equals(tenantId)) {
                Iterator<Object> iterator = null;
                return iterator;
            }
            DocumentModel entry = this.fieldMapToDocumentModel(fieldMap);
            if (fetchReferences) {
                HashMap targetIdsMap = new HashMap();
                for (Reference reference : this.directory.getReferences()) {
                    ArrayList targetIds = reference.getTargetIdsForSource(entry.getId());
                    targetIds = new ArrayList(targetIds);
                    Collections.sort(targetIds);
                    String fieldName = reference.getFieldName();
                    if (targetIdsMap.containsKey(fieldName)) {
                        ((List)targetIdsMap.get(fieldName)).addAll(targetIds);
                        continue;
                    }
                    targetIdsMap.put(fieldName, targetIds);
                }
                for (Map.Entry entry2 : targetIdsMap.entrySet()) {
                    String fieldName = (String)entry2.getKey();
                    List targetIds = (List)entry2.getValue();
                    try {
                        entry.setProperty(this.schemaName, fieldName, (Object)targetIds);
                    }
                    catch (PropertyException e) {
                        throw new DirectoryException((Throwable)e);
                    }
                }
            }
            var10_12 = entry;
            return var10_12;
        }
        catch (SQLException e) {
            throw new DirectoryException("getEntry failed", (Throwable)e);
        }
    }

    protected List<Column> getReadColumns() {
        return this.readAllColumns ? this.getDirectory().readColumnsAll : this.getDirectory().readColumns;
    }

    protected String getReadColumnsSQL() {
        return this.readAllColumns ? this.getDirectory().readColumnsAllSQL : this.getDirectory().readColumnsSQL;
    }

    protected Column getIdColumn() {
        return this.getDirectory().idColumn;
    }

    protected DocumentModel fieldMapToDocumentModel(Map<String, Object> fieldMap) {
        String idFieldName = ((Field)this.directory.getSchemaFieldMap().get(this.getIdField())).getName().getPrefixedName();
        if (!fieldMap.containsKey(idFieldName)) {
            idFieldName = this.getIdField();
        }
        String id = String.valueOf(fieldMap.get(idFieldName));
        try {
            DocumentModel docModel = BaseSession.createEntryModel((String)this.sid, (String)this.schemaName, (String)id, fieldMap, (boolean)this.isReadOnly());
            return docModel;
        }
        catch (PropertyException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private void acquireConnection() {
        try {
            if (this.sqlConnection == null || this.sqlConnection.isClosed()) {
                this.sqlConnection = this.getDirectory().getConnection();
            }
        }
        catch (SQLException e) {
            throw new DirectoryException("Cannot connect to SQL directory '" + this.directory.getName() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    protected void checkConcurrentUpdate(Throwable e) throws ConcurrentUpdateException {
        if (this.dialect.isConcurrentUpdateException(e)) {
            throw new ConcurrentUpdateException(e);
        }
    }

    protected String addFilterWhereClause(String whereClause) {
        if (this.staticFilters.length == 0) {
            return whereClause;
        }
        whereClause = whereClause != null && whereClause.trim().length() > 0 ? whereClause + " AND " : "";
        for (int i = 0; i < this.staticFilters.length; ++i) {
            SQLStaticFilter filter = this.staticFilters[i];
            whereClause = whereClause + filter.getDirectoryColumn(this.table, this.getDirectory().useNativeCase()).getQuotedName();
            whereClause = whereClause + " " + filter.getOperator() + " ";
            whereClause = whereClause + "? ";
            if (i >= this.staticFilters.length - 1) continue;
            whereClause = whereClause + " AND ";
        }
        return whereClause;
    }

    protected void addFilterWhereClause(StringBuilder clause, List<SQLQueryBuilder.ColumnAndValue> params) {
        if (this.staticFilters.length == 0) {
            return;
        }
        for (SQLStaticFilter filter : this.staticFilters) {
            if (clause.length() > 0) {
                clause.append(" AND ");
            }
            Column column = filter.getDirectoryColumn(this.table, this.getDirectory().useNativeCase());
            clause.append(column.getQuotedName());
            clause.append(" ");
            clause.append(filter.getOperator());
            clause.append(" ?");
            params.add(new SQLQueryBuilder.ColumnAndValue(column, (Serializable)((Object)filter.getValue())));
        }
    }

    protected void addFilterValues(PreparedStatement ps, int startIdx) {
        for (int i = 0; i < this.staticFilters.length; ++i) {
            SQLStaticFilter filter = this.staticFilters[i];
            this.setFieldValue(ps, startIdx + i, filter.getDirectoryColumn(this.table, this.getDirectory().useNativeCase()), filter.getValue());
        }
    }

    protected void addFilterValuesForLog(List<Serializable> values) {
        for (int i = 0; i < this.staticFilters.length; ++i) {
            values.add((Serializable)((Object)this.staticFilters[i].getValue()));
        }
    }

    /*
     * Exception decompiling
     */
    protected String getPassword(String id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteEntry(String id) {
        this.acquireConnection();
        if (!this.canDeleteMultiTenantEntry(id)) {
            throw new OperationNotAllowedException("Operation not allowed in the current tenant context", "label.directory.error.multi.tenant.operationNotAllowed", null);
        }
        super.deleteEntry(id);
    }

    public void deleteEntry(String id, Map<String, String> map) {
        this.checkPermission("Write");
        this.acquireConnection();
        if (!this.canDeleteMultiTenantEntry(id)) {
            throw new DirectoryException("Operation not allowed in the current tenant context");
        }
        Delete delete = new Delete(this.table);
        StringBuilder whereClause = new StringBuilder();
        ArrayList<String> values = new ArrayList<String>(1 + map.size());
        whereClause.append(this.table.getPrimaryColumn().getQuotedName());
        whereClause.append(" = ?");
        values.add(id);
        for (Map.Entry<String, String> e : map.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            whereClause.append(" AND ");
            Column col = this.table.getColumn(key);
            if (col == null) {
                throw new IllegalArgumentException("Unknown column " + key);
            }
            whereClause.append(col.getQuotedName());
            if (value == null) {
                whereClause.append(" IS NULL");
                continue;
            }
            whereClause.append(" = ?");
            values.add(value);
        }
        delete.setWhere(whereClause.toString());
        String sql = delete.getStatement();
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, values);
        }
        try (PreparedStatement ps = this.sqlConnection.prepareStatement(sql);){
            for (int i = 0; i < values.size(); ++i) {
                if (i == 0) {
                    this.setFieldValue(ps, 1, this.table.getPrimaryColumn(), values.get(i));
                    continue;
                }
                ps.setString(1 + i, (String)values.get(i));
            }
            ps.execute();
        }
        catch (SQLException e) {
            this.checkConcurrentUpdate(e);
            throw new DirectoryException("deleteEntry failed", (Throwable)e);
        }
        this.getDirectory().invalidateCaches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences, int limit, int offset) {
        String tenantId;
        if (!this.hasPermission("Read")) {
            return new DocumentModelListImpl();
        }
        this.acquireConnection();
        LinkedHashMap<String, Object> filterMap = new LinkedHashMap<String, Object>(filter);
        filterMap.remove(this.getPasswordField());
        if (this.isMultiTenant() && !StringUtils.isBlank((CharSequence)(tenantId = this.getCurrentTenantId()))) {
            filterMap.put("tenantId", (Serializable)((Object)tenantId));
        }
        try {
            boolean manualLimitOffset;
            String where;
            Select select;
            StringBuilder whereClause = new StringBuilder();
            String separator = "";
            LinkedList<Column> orderedColumns = new LinkedList<Column>();
            for (String columnName : filterMap.keySet()) {
                Object operator;
                String rightSide;
                String leftSide;
                Column column;
                Object value;
                block92: {
                    block95: {
                        boolean substring;
                        block96: {
                            if (this.getDirectory().isReference(columnName)) {
                                log.warn((Object)(columnName + " is a reference and will be ignored as a query criterion"));
                                continue;
                            }
                            value = filterMap.get(columnName);
                            column = this.table.getColumn(columnName);
                            if (null == column) {
                                throw new DirectoryException("cannot find column '" + columnName + "' for table: " + this.table);
                            }
                            leftSide = column.getQuotedName();
                            rightSide = "?";
                            boolean bl = substring = fulltext != null && fulltext.contains(columnName);
                            if ("".equals(value) && this.dialect.hasNullEmptyString() && !substring) {
                                value = null;
                            }
                            if (value == null) break block95;
                            if (!(value instanceof SQLComplexFilter)) break block96;
                            SQLComplexFilter complexFilter = (SQLComplexFilter)value;
                            operator = complexFilter.getOperator();
                            rightSide = complexFilter.getRightSide();
                            break block92;
                        }
                        if (substring) {
                            String searchedValue = null;
                            switch (this.substringMatchType) {
                                case subany: {
                                    searchedValue = '%' + String.valueOf(value).toLowerCase() + '%';
                                    break;
                                }
                                case subinitial: {
                                    searchedValue = String.valueOf(value).toLowerCase() + '%';
                                    break;
                                }
                                case subfinal: {
                                    searchedValue = '%' + String.valueOf(value).toLowerCase();
                                    break;
                                }
                            }
                            filterMap.put(columnName, searchedValue);
                            if (this.dialect.supportsIlike()) {
                                operator = " ILIKE ";
                                break block92;
                            } else {
                                leftSide = "LOWER(" + leftSide + ')';
                                operator = " LIKE ";
                            }
                            break block92;
                        } else {
                            operator = " = ";
                        }
                        break block92;
                    }
                    operator = " IS NULL";
                }
                whereClause.append(separator).append(leftSide).append((String)operator);
                if (value != null) {
                    whereClause.append(rightSide);
                    orderedColumns.add(column);
                }
                separator = " AND ";
            }
            int queryLimitSize = this.getDirectory().getDescriptor().getQuerySizeLimit();
            boolean trucatedResults = false;
            if (queryLimitSize != 0 && (limit <= 0 || limit > queryLimitSize)) {
                int count;
                select = new Select(this.table);
                select.setWhat("count(*)");
                select.setFrom(this.table.getQuotedName());
                where = whereClause.toString();
                where = this.addFilterWhereClause(where);
                select.setWhere(where);
                String countQuery = select.getStatement();
                if (this.logger.isLogEnabled()) {
                    ArrayList<Serializable> values = new ArrayList<Serializable>(orderedColumns.size());
                    for (Column column : orderedColumns) {
                        Object value = filterMap.get(column.getKey());
                        values.add((Serializable)value);
                    }
                    this.addFilterValuesForLog(values);
                    this.logger.logSQL(countQuery, values);
                }
                try (PreparedStatement ps = this.sqlConnection.prepareStatement(countQuery);){
                    this.fillPreparedStatementFields(filterMap, orderedColumns, ps);
                    try (ResultSet rs = ps.executeQuery();){
                        rs.next();
                        count = rs.getInt(1);
                    }
                }
                if (this.logger.isLogEnabled()) {
                    this.logger.logCount(count);
                }
                if (count > queryLimitSize) {
                    trucatedResults = true;
                    limit = queryLimitSize;
                    log.error((Object)("Displayed results will be truncated because too many rows in result: " + count));
                }
            }
            select = new Select(this.table);
            select.setWhat(this.getReadColumnsSQL());
            select.setFrom(this.table.getQuotedName());
            where = whereClause.toString();
            where = this.addFilterWhereClause(where);
            select.setWhere(where);
            StringBuilder orderby = new StringBuilder(128);
            if (orderBy != null) {
                Iterator<Map.Entry<String, String>> it = orderBy.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> entry = it.next();
                    orderby.append(this.dialect.openQuote()).append(entry.getKey()).append(this.dialect.closeQuote()).append(' ').append(entry.getValue());
                    if (!it.hasNext()) continue;
                    orderby.append(',');
                }
            }
            select.setOrderBy(orderby.toString());
            String query = select.getStatement();
            if (limit <= 0) {
                manualLimitOffset = false;
            } else {
                if (offset < 0) {
                    offset = 0;
                }
                if (this.dialect.supportsPaging()) {
                    query = this.dialect.addPagingClause(query, (long)limit, (long)offset);
                    manualLimitOffset = false;
                } else {
                    manualLimitOffset = true;
                }
            }
            if (this.logger.isLogEnabled()) {
                ArrayList<Serializable> values = new ArrayList<Serializable>(orderedColumns.size());
                for (Column column : orderedColumns) {
                    Object value = filterMap.get(column.getKey());
                    values.add((Serializable)value);
                }
                this.addFilterValuesForLog(values);
                this.logger.logSQL(query, values);
            }
            PreparedStatement ps = this.sqlConnection.prepareStatement(query);
            Object object = null;
            try {
                this.fillPreparedStatementFields(filterMap, orderedColumns, ps);
                DocumentModelListImpl list = new DocumentModelListImpl();
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        for (Column column : this.getReadColumns()) {
                            Object o = this.getFieldValue(rs, column);
                            map.put(column.getKey(), o);
                        }
                        DocumentModel docModel = this.fieldMapToDocumentModel(map);
                        if (fetchReferences) {
                            HashMap<String, List> targetIdsMap = new HashMap<String, List>();
                            for (Reference reference : this.directory.getReferences()) {
                                List targetIds = reference.getTargetIdsForSource(docModel.getId());
                                String fieldName = reference.getFieldName();
                                if (targetIdsMap.containsKey(fieldName)) {
                                    ((List)targetIdsMap.get(fieldName)).addAll(targetIds);
                                    continue;
                                }
                                targetIdsMap.put(fieldName, targetIds);
                            }
                            for (Map.Entry entry : targetIdsMap.entrySet()) {
                                String fieldName = (String)entry.getKey();
                                List targetIds = (List)entry.getValue();
                                docModel.setProperty(this.schemaName, fieldName, (Object)targetIds);
                            }
                        }
                        list.add((Object)docModel);
                    }
                }
                if (manualLimitOffset) {
                    int totalSize = list.size();
                    if (offset > 0) {
                        list = offset >= totalSize ? new DocumentModelListImpl() : new DocumentModelListImpl(list.subList(offset, totalSize));
                    }
                    if (list.size() > limit) {
                        list = new DocumentModelListImpl(list.subList(0, limit));
                    }
                    list.setTotalSize((long)totalSize);
                }
                if (trucatedResults) {
                    list.setTotalSize(-2L);
                }
                DocumentModelListImpl documentModelListImpl = list;
                return documentModelListImpl;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ps != null) {
                    if (object != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                this.sqlConnection.close();
                throw new DirectoryException("query failed", (Throwable)e);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new DirectoryException("query failed", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocumentModelList query(QueryBuilder queryBuilder, boolean fetchReferences) {
        if (!this.hasPermission("Read")) {
            return new DocumentModelListImpl();
        }
        if (BaseSession.FieldDetector.hasField((MultiExpression)queryBuilder.predicate(), (String)this.getPasswordField())) {
            throw new DirectoryException("Cannot filter on password");
        }
        queryBuilder = this.addTenantId(queryBuilder);
        SQLQueryBuilder builder = new SQLQueryBuilder(this.getDirectory());
        builder.visitMultiExpression(queryBuilder.predicate());
        this.addFilterWhereClause(builder.clause, builder.params);
        String whereClause = builder.clause.toString();
        int limit = Math.max(0, (int)queryBuilder.limit());
        int offset = Math.max(0, (int)queryBuilder.offset());
        boolean countTotal = queryBuilder.countTotal();
        try {
            int count;
            DocumentModelListImpl list;
            block72: {
                Throwable throwable;
                this.acquireConnection();
                Select select = new Select(this.table);
                select.setWhat(this.getReadColumnsSQL());
                select.setFrom(this.table.getQuotedName());
                select.setWhere(whereClause);
                StringBuilder orderBy = new StringBuilder();
                OrderByList orders = queryBuilder.orders();
                if (!orders.isEmpty()) {
                    for (OrderByExpr ob : orders) {
                        if (orderBy.length() != 0) {
                            orderBy.append(", ");
                        }
                        orderBy.append(this.dialect.openQuote());
                        orderBy.append(ob.reference.name);
                        orderBy.append(this.dialect.closeQuote());
                        if (!ob.isDescending) continue;
                        orderBy.append(" DESC");
                    }
                    select.setOrderBy(orderBy.toString());
                }
                String query = select.getStatement();
                if (limit != 0 || offset != 0) {
                    if (!this.dialect.supportsPaging()) {
                        throw new QueryParseException("Cannot use limit/offset, not supported by database");
                    }
                    query = this.dialect.addPagingClause(query, (long)limit, (long)offset);
                }
                if (this.logger.isLogEnabled()) {
                    List values = builder.params.stream().map(SQLQueryBuilder.ColumnAndValue::getValue).collect(Collectors.toList());
                    this.logger.logSQL(query, values);
                }
                list = new DocumentModelListImpl();
                try (PreparedStatement ps = this.sqlConnection.prepareStatement(query);){
                    int i = 1;
                    for (SQLQueryBuilder.ColumnAndValue columnAndValue : builder.params) {
                        this.setFieldValue(ps, i++, columnAndValue.column, columnAndValue.value);
                    }
                    throwable = null;
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            for (Column column : this.getReadColumns()) {
                                Object o = this.getFieldValue(rs, column);
                                map.put(column.getKey(), o);
                            }
                            DocumentModel docModel = this.fieldMapToDocumentModel(map);
                            if (fetchReferences) {
                                HashMap<String, List> targetIdsMap = new HashMap<String, List>();
                                for (Reference reference : this.directory.getReferences()) {
                                    List targetIds = reference.getTargetIdsForSource(docModel.getId());
                                    String fieldName = reference.getFieldName();
                                    targetIdsMap.computeIfAbsent(fieldName, key -> new ArrayList()).addAll(targetIds);
                                }
                                for (Map.Entry entry : targetIdsMap.entrySet()) {
                                    String fieldName = (String)entry.getKey();
                                    List targetIds = (List)entry.getValue();
                                    docModel.setProperty(this.schemaName, fieldName, (Object)targetIds);
                                }
                            }
                            list.add((Object)docModel);
                        }
                    }
                    catch (Throwable map) {
                        throwable = map;
                        throw map;
                    }
                }
                if (limit == 0) {
                    if (offset == 0) return list;
                }
                if (countTotal) {
                    Select selectCount = new Select(this.table);
                    selectCount.setWhat("COUNT(*)");
                    selectCount.setFrom(this.table.getQuotedName());
                    selectCount.setWhere(whereClause);
                    String countQuery = selectCount.getStatement();
                    if (this.logger.isLogEnabled()) {
                        List values = builder.params.stream().map(SQLQueryBuilder.ColumnAndValue::getValue).collect(Collectors.toList());
                        this.logger.logSQL(countQuery, values);
                    }
                    throwable = null;
                    try (PreparedStatement ps = this.sqlConnection.prepareStatement(countQuery);){
                        int i = 1;
                        for (SQLQueryBuilder.ColumnAndValue columnAndValue : builder.params) {
                            this.setFieldValue(ps, i++, columnAndValue.column, columnAndValue.value);
                        }
                        try (ResultSet rs = ps.executeQuery();){
                            rs.next();
                            count = rs.getInt(1);
                            if (this.logger.isLogEnabled()) {
                                this.logger.logCount(count);
                            }
                            break block72;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                count = -2;
            }
            list.setTotalSize((long)count);
            return list;
        }
        catch (SQLException e) {
            try {
                this.sqlConnection.close();
                throw new DirectoryException("query failed", (Throwable)e);
            }
            catch (SQLException ee) {
                log.error((Object)ee, (Throwable)ee);
            }
            throw new DirectoryException("query failed", (Throwable)e);
        }
    }

    public List<String> queryIds(QueryBuilder queryBuilder) {
        if (!this.hasPermission("Read")) {
            return Collections.emptyList();
        }
        if (BaseSession.FieldDetector.hasField((MultiExpression)queryBuilder.predicate(), (String)this.getPasswordField())) {
            throw new DirectoryException("Cannot filter on password");
        }
        queryBuilder = this.addTenantId(queryBuilder);
        SQLQueryBuilder builder = new SQLQueryBuilder(this.getDirectory());
        builder.visitMultiExpression(queryBuilder.predicate());
        this.addFilterWhereClause(builder.clause, builder.params);
        String whereClause = builder.clause.toString();
        int limit = Math.max(0, (int)queryBuilder.limit());
        int offset = Math.max(0, (int)queryBuilder.offset());
        try {
            this.acquireConnection();
            Column idColumn = this.getIdColumn();
            Select select = new Select(this.table);
            select.setWhat(idColumn.getQuotedName());
            select.setFrom(this.table.getQuotedName());
            select.setWhere(whereClause);
            StringBuilder orderBy = new StringBuilder();
            OrderByList orders = queryBuilder.orders();
            if (!orders.isEmpty()) {
                for (OrderByExpr ob : orders) {
                    if (orderBy.length() != 0) {
                        orderBy.append(", ");
                    }
                    orderBy.append(this.dialect.openQuote());
                    orderBy.append(ob.reference.name);
                    orderBy.append(this.dialect.closeQuote());
                    if (!ob.isDescending) continue;
                    orderBy.append(" DESC");
                }
                select.setOrderBy(orderBy.toString());
            }
            String query = select.getStatement();
            if (limit != 0 || offset != 0) {
                if (!this.dialect.supportsPaging()) {
                    throw new QueryParseException("Cannot use limit/offset, not supported by database");
                }
                query = this.dialect.addPagingClause(query, (long)limit, (long)offset);
            }
            if (this.logger.isLogEnabled()) {
                List values = builder.params.stream().map(SQLQueryBuilder.ColumnAndValue::getValue).collect(Collectors.toList());
                this.logger.logSQL(query, values);
            }
            ArrayList<String> ids = new ArrayList<String>();
            try (PreparedStatement ps = this.sqlConnection.prepareStatement(query);){
                int i = 1;
                for (SQLQueryBuilder.ColumnAndValue columnAndValue : builder.params) {
                    this.setFieldValue(ps, i++, columnAndValue.column, columnAndValue.value);
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        String id = (String)((Object)idColumn.getFromResultSet(rs, 1));
                        ids.add(id);
                    }
                }
            }
            return ids;
        }
        catch (SQLException e) {
            try {
                this.sqlConnection.close();
            }
            catch (SQLException ee) {
                log.error((Object)ee, (Throwable)ee);
            }
            throw new DirectoryException("query failed", (Throwable)e);
        }
    }

    protected DocumentModel createEntryWithoutReferences(Map<String, Object> fieldMap) {
        DocumentModel entry;
        fieldMap = new HashMap<String, Object>(fieldMap);
        Map schemaFieldMap = this.directory.getSchemaFieldMap();
        Field schemaIdField = (Field)schemaFieldMap.get(this.getIdField());
        String idFieldName = schemaIdField.getName().getPrefixedName();
        this.acquireConnection();
        if (this.autoincrementId) {
            fieldMap.remove(idFieldName);
        } else {
            String tenantId;
            Object rawId = fieldMap.get(idFieldName);
            if (rawId == null) {
                throw new DirectoryException("Missing id");
            }
            String id = String.valueOf(rawId);
            if (this.isMultiTenant() && !StringUtils.isBlank((CharSequence)(tenantId = this.getCurrentTenantId()))) {
                fieldMap.put("tenantId", tenantId);
                if (this.computeMultiTenantId) {
                    id = SQLSession.computeMultiTenantDirectoryId((String)tenantId, (String)id);
                    fieldMap.put(idFieldName, id);
                }
            }
            if (this.hasEntry(id)) {
                throw new DirectoryException(String.format("Entry with id %s already exists", id));
            }
        }
        ArrayList columnList = new ArrayList(this.table.getColumns());
        Column idColumn = null;
        Iterator i = columnList.iterator();
        while (i.hasNext()) {
            String prefixedName;
            Column column = (Column)i.next();
            if (column.isIdentity()) {
                idColumn = column;
            }
            if (fieldMap.containsKey(prefixedName = ((Field)schemaFieldMap.get(column.getKey())).getName().getPrefixedName())) continue;
            Field prefixedField = (Field)schemaFieldMap.get(prefixedName);
            if (prefixedField != null && prefixedField.getDefaultValue() != null) {
                fieldMap.put(prefixedName, prefixedField.getDefaultValue());
                continue;
            }
            i.remove();
        }
        Insert insert = new Insert(this.table);
        for (Column column : columnList) {
            insert.addColumn(column);
        }
        insert.addIdentityColumn(idColumn);
        String sql = insert.getStatement();
        if (this.logger.isLogEnabled()) {
            ArrayList<String> values = new ArrayList<String>(columnList.size());
            for (Column column : columnList) {
                String prefixField = ((Field)schemaFieldMap.get(column.getKey())).getName().getPrefixedName();
                Object value = fieldMap.get(prefixField);
                Object v = column.getKey().equals(this.getPasswordField()) ? "********" : this.fieldValueForWrite(value, column);
                values.add((String)v);
            }
            this.logger.logSQL(sql, values);
        }
        try (PreparedStatement ps = this.prepareStatementWithAutoKeys(sql);){
            int index = 1;
            for (Column column : columnList) {
                String prefixField = ((Field)schemaFieldMap.get(column.getKey())).getName().getPrefixedName();
                Object value = fieldMap.get(prefixField);
                this.setFieldValue(ps, index, column, value);
                ++index;
            }
            ps.execute();
            if (this.autoincrementId) {
                Throwable throwable;
                Column column = this.table.getColumn(this.getIdField());
                if (this.dialect.hasIdentityGeneratedKey()) {
                    throwable = null;
                    try (ResultSet rs = ps.getGeneratedKeys();){
                        this.setIdFieldInMap(rs, column, idFieldName, fieldMap);
                    }
                    catch (Throwable value) {
                        throwable = value;
                        throw value;
                    }
                }
                sql = this.dialect.getIdentityGeneratedKeySql(column);
                throwable = null;
                try (Statement st = this.sqlConnection.createStatement();
                     ResultSet rs = st.executeQuery(sql);){
                    this.setIdFieldInMap(rs, column, idFieldName, fieldMap);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            entry = this.fieldMapToDocumentModel(fieldMap);
        }
        catch (SQLException e) {
            this.checkConcurrentUpdate(e);
            throw new DirectoryException("createEntry failed", (Throwable)e);
        }
        return entry;
    }

    protected void setIdFieldInMap(ResultSet rs, Column column, String idFieldName, Map<String, Object> fieldMap) throws SQLException {
        if (!rs.next()) {
            throw new DirectoryException("Cannot get generated key");
        }
        if (this.logger.isLogEnabled()) {
            this.logger.logResultSet(rs, Collections.singletonList(column));
        }
        Serializable rawId = column.getFromResultSet(rs, 1);
        fieldMap.put(idFieldName, rawId);
    }

    protected PreparedStatement prepareStatementWithAutoKeys(String sql) throws SQLException {
        if (this.autoincrementId && this.dialect.hasIdentityGeneratedKey()) {
            return this.sqlConnection.prepareStatement(sql, new String[]{this.getIdField()});
        }
        return this.sqlConnection.prepareStatement(sql);
    }

    protected List<String> updateEntryWithoutReferences(DocumentModel docModel) {
        String entryTenantId;
        Object tenantId;
        this.acquireConnection();
        LinkedList<Column> storedColumnList = new LinkedList<Column>();
        LinkedList<String> referenceFieldList = new LinkedList<String>();
        if (this.isMultiTenant() && !StringUtils.isBlank((CharSequence)(tenantId = this.getCurrentTenantId())) && (StringUtils.isBlank((CharSequence)(entryTenantId = (String)docModel.getProperty(this.schemaName, "tenantId"))) || !entryTenantId.equals(tenantId))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Trying to update entry '%s' not part of current tenant '%s'", docModel.getId(), tenantId));
            }
            throw new OperationNotAllowedException("Operation not allowed in the current tenant context", "label.directory.error.multi.tenant.operationNotAllowed", null);
        }
        for (String fieldName : this.directory.getSchemaFieldMap().keySet()) {
            Property prop;
            if (fieldName.equals(this.getIdField()) || !(prop = docModel.getPropertyObject(this.schemaName, fieldName)).isDirty() || fieldName.equals(this.getPasswordField()) && StringUtils.isEmpty((CharSequence)((String)((Object)prop.getValue())))) continue;
            if (this.getDirectory().isReference(fieldName)) {
                referenceFieldList.add(fieldName);
                continue;
            }
            storedColumnList.add(this.table.getColumn(fieldName));
        }
        if (!storedColumnList.isEmpty()) {
            Update update = new Update(this.table);
            update.setUpdatedColumns(storedColumnList);
            String whereString = this.table.getPrimaryColumn().getQuotedName() + " = ?";
            update.setWhere(whereString);
            String sql = update.getStatement();
            if (this.logger.isLogEnabled()) {
                ArrayList<Object> values = new ArrayList<Object>(storedColumnList.size());
                for (Column column : storedColumnList) {
                    Object value = docModel.getProperty(this.schemaName, column.getKey());
                    if (column.getKey().equals(this.getPasswordField())) {
                        value = "********";
                    }
                    values.add((Serializable)value);
                }
                values.add(docModel.getId());
                this.logger.logSQL(sql, values);
            }
            try {
                PreparedStatement ps = this.sqlConnection.prepareStatement(sql);
                Object object = null;
                try {
                    int index = 1;
                    for (Column column : storedColumnList) {
                        Object value = docModel.getProperty(this.schemaName, column.getKey());
                        this.setFieldValue(ps, index, column, value);
                        ++index;
                    }
                    this.setFieldValue(ps, index, this.table.getPrimaryColumn(), docModel.getId());
                    ps.execute();
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (ps != null) {
                        if (object != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.checkConcurrentUpdate(e);
                throw new DirectoryException("updateEntry failed for " + docModel.getId(), (Throwable)e);
            }
        }
        return referenceFieldList;
    }

    public void deleteEntryWithoutReferences(String id) {
        Delete delete = new Delete(this.table);
        String whereString = this.table.getPrimaryColumn().getQuotedName() + " = ?";
        delete.setWhere(whereString);
        String sql = delete.getStatement();
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Collections.singleton(id));
        }
        try (PreparedStatement ps = this.sqlConnection.prepareStatement(sql);){
            this.setFieldValue(ps, 1, this.table.getPrimaryColumn(), id);
            ps.execute();
        }
        catch (SQLException e) {
            this.checkConcurrentUpdate(e);
            throw new DirectoryException("deleteEntry failed", (Throwable)e);
        }
    }

    protected void fillPreparedStatementFields(Map<String, Object> filterMap, List<Column> orderedColumns, PreparedStatement ps) {
        int index = 1;
        for (Column column : orderedColumns) {
            Object value = filterMap.get(column.getKey());
            if (value instanceof SQLComplexFilter) {
                index = ((SQLComplexFilter)value).setFieldValue(ps, index, column);
                continue;
            }
            this.setFieldValue(ps, index, column, value);
            ++index;
        }
        this.addFilterValues(ps, index);
    }

    private Object getFieldValue(ResultSet rs, Column column) {
        try {
            int index = rs.findColumn(column.getPhysicalName());
            return column.getFromResultSet(rs, index);
        }
        catch (SQLException e) {
            throw new DirectoryException("getFieldValue failed", (Throwable)e);
        }
    }

    private void setFieldValue(PreparedStatement ps, int index, Column column, Object value) {
        try {
            column.setToPreparedStatement(ps, index, this.fieldValueForWrite(value, column));
        }
        catch (SQLException e) {
            throw new DirectoryException("setFieldValue failed", (Throwable)e);
        }
    }

    protected Serializable fieldValueForWrite(Object value, Column column) {
        ColumnSpec spec = column.getType().spec;
        if (value instanceof String) {
            if (spec == ColumnSpec.LONG || spec == ColumnSpec.AUTOINC) {
                return Long.valueOf((String)value);
            }
            if (column.getKey().equals(this.getPasswordField())) {
                String password = (String)value;
                if (!PasswordHelper.isHashed((String)password)) {
                    password = PasswordHelper.hashPassword((String)password, (String)this.passwordHashAlgorithm);
                }
                return password;
            }
        } else if (value instanceof Number) {
            if (spec == ColumnSpec.LONG || spec == ColumnSpec.AUTOINC) {
                if (value instanceof Integer) {
                    return Long.valueOf(((Integer)value).longValue());
                }
            } else if (spec == ColumnSpec.STRING) {
                return value.toString();
            }
        }
        return (Serializable)value;
    }

    public void close() {
        try {
            if (!this.sqlConnection.isClosed()) {
                this.sqlConnection.close();
            }
        }
        catch (SQLException e) {
            throw new DirectoryException("close failed", (Throwable)e);
        }
        finally {
            this.getDirectory().removeSession((Session)this);
        }
    }

    public boolean isLive() {
        try {
            return !this.sqlConnection.isClosed();
        }
        catch (SQLException e) {
            throw new DirectoryException("Cannot check connection status of " + (Object)((Object)this), (Throwable)e);
        }
    }

    public boolean authenticate(String username, String password) {
        String storedPassword = this.getPassword(username);
        return PasswordHelper.verifyPassword((String)password, (String)storedPassword);
    }

    public boolean isAuthenticating() {
        return this.directory.getSchemaFieldMap().containsKey(this.getPasswordField());
    }

    /*
     * Exception decompiling
     */
    public boolean hasEntry(String id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return "SQLSession [directory=" + this.directory.getName() + ", sid=" + this.sid + "]";
    }
}

