/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.runtime.pubsub.SerializableAccumulableInvalidations;

public class Invalidations
implements SerializableAccumulableInvalidations {
    private static final long serialVersionUID = 1L;
    public static final String PARENT = "__PARENT__";
    public static final String SERIES_PROXIES = "__SERIES_PROXIES__";
    public static final String TARGET_PROXIES = "__TARGET_PROXIES__";
    public static final int MODIFIED = 1;
    public static final int DELETED = 2;
    public static final int MAX_SIZE = 10000;
    public boolean all;
    public Set<RowId> modified;
    public Set<RowId> deleted;

    public Invalidations() {
    }

    public Invalidations(boolean all) {
        this.all = all;
    }

    public boolean isEmpty() {
        return this.modified == null && this.deleted == null && !this.all;
    }

    public void clear() {
        this.all = false;
        this.modified = null;
        this.deleted = null;
    }

    protected void setAll() {
        this.all = true;
        this.modified = null;
        this.deleted = null;
    }

    protected void checkMaxSize() {
        if (this.modified != null && this.modified.size() > 10000 || this.deleted != null && this.deleted.size() > 10000) {
            this.setAll();
        }
    }

    public Set<RowId> getKindSet(int kind) {
        switch (kind) {
            case 1: {
                if (this.modified == null) {
                    this.modified = new HashSet<RowId>();
                }
                return this.modified;
            }
            case 2: {
                if (this.deleted == null) {
                    this.deleted = new HashSet<RowId>();
                }
                return this.deleted;
            }
        }
        throw new AssertionError();
    }

    public void add(SerializableAccumulableInvalidations o) {
        Invalidations other = (Invalidations)o;
        if (other == null) {
            return;
        }
        if (this.all) {
            return;
        }
        if (other.all) {
            this.setAll();
            return;
        }
        if (other.modified != null) {
            if (this.modified == null) {
                this.modified = new HashSet<RowId>();
            }
            this.modified.addAll(other.modified);
        }
        if (other.deleted != null) {
            if (this.deleted == null) {
                this.deleted = new HashSet<RowId>();
            }
            this.deleted.addAll(other.deleted);
        }
        this.checkMaxSize();
    }

    public void addModified(RowId rowId) {
        if (this.all) {
            return;
        }
        if (this.modified == null) {
            this.modified = new HashSet<RowId>();
        }
        this.modified.add(rowId);
        this.checkMaxSize();
    }

    public void addDeleted(RowId rowId) {
        if (this.all) {
            return;
        }
        if (this.deleted == null) {
            this.deleted = new HashSet<RowId>();
        }
        this.deleted.add(rowId);
        this.checkMaxSize();
    }

    public void add(Serializable id, String[] tableNames, int kind) {
        if (tableNames.length == 0) {
            return;
        }
        Set<RowId> set = this.getKindSet(kind);
        for (String tableName : tableNames) {
            set.add(new RowId(tableName, id));
        }
        this.checkMaxSize();
    }

    public void serialize(OutputStream out) throws IOException {
        try (ObjectOutputStream oout = new ObjectOutputStream(out);){
            oout.writeObject(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Invalidations deserialize(InputStream in) throws IOException {
        try (ObjectInputStream oin = new ObjectInputStream(in);){
            Invalidations invalidations = (Invalidations)oin.readObject();
            return invalidations;
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + '(');
        if (this.all) {
            sb.append("all=true");
        }
        if (this.modified != null) {
            sb.append("modified=");
            sb.append(this.modified);
            if (this.deleted != null) {
                sb.append(',');
            }
        }
        if (this.deleted != null) {
            sb.append("deleted=");
            sb.append(this.deleted);
        }
        sb.append(')');
        return sb.toString();
    }
}

