/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.nuxeo.ecm.core.api.LifeCycleException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.ReadOnlyPropertyException;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocument;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentLive;
import org.nuxeo.runtime.api.Framework;

public class SQLDocumentProxy
implements SQLDocument {
    private final Document proxy;
    private Document target;
    public static final String CHANGE_TOKEN_PROXY_SEP = "/";

    protected SQLDocumentProxy(Document proxy, Document target) {
        this.proxy = proxy;
        this.target = target;
    }

    protected String getSchema(String xpath) {
        int p = xpath.indexOf(58);
        if (p == -1) {
            throw new PropertyNotFoundException(xpath, "Schema not specified");
        }
        String prefix = xpath.substring(0, p);
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        Schema schema = schemaManager.getSchemaFromPrefix(prefix);
        if (schema == null && (schema = schemaManager.getSchema(prefix)) == null) {
            throw new PropertyNotFoundException(xpath, "No schema for prefix");
        }
        return schema.getName();
    }

    protected boolean isSchemaForProxy(String schema) {
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        return schemaManager.isProxySchema(schema, this.getType().getName());
    }

    protected boolean isPropertyForProxy(String xpath) {
        if ("ecm:minorVersion".equals(xpath) || "ecm:majorVersion".equals(xpath)) {
            return false;
        }
        return this.isSchemaForProxy(this.getSchema(xpath));
    }

    @Override
    public Node getNode() {
        return ((SQLDocument)this.proxy).getNode();
    }

    public boolean isProxy() {
        return true;
    }

    public String getUUID() {
        return this.proxy.getUUID();
    }

    public String getName() {
        return this.proxy.getName();
    }

    public Long getPos() {
        return this.proxy.getPos();
    }

    public Document getParent() {
        return this.proxy.getParent();
    }

    public String getPath() {
        return this.proxy.getPath();
    }

    public void remove() {
        this.proxy.remove();
    }

    public DocumentType getType() {
        return this.target.getType();
    }

    public String getRepositoryName() {
        return this.target.getRepositoryName();
    }

    public Session getSession() {
        return this.target.getSession();
    }

    public boolean isFolder() {
        return this.target.isFolder();
    }

    public void setReadOnly(boolean readonly) {
        this.target.setReadOnly(readonly);
    }

    public boolean isReadOnly() {
        return this.target.isReadOnly();
    }

    public void readDocumentPart(DocumentPart dp) throws PropertyException {
        if (this.isSchemaForProxy(dp.getName())) {
            this.proxy.readDocumentPart(dp);
        } else {
            this.target.readDocumentPart(dp);
        }
    }

    public Document.WriteContext getWriteContext() {
        return this.proxy.getWriteContext();
    }

    public boolean writeDocumentPart(DocumentPart dp, Document.WriteContext writeContext) throws PropertyException {
        if (this.isSchemaForProxy(dp.getName())) {
            return this.proxy.writeDocumentPart(dp, writeContext);
        }
        return this.target.writeDocumentPart(dp, writeContext);
    }

    public void setSystemProp(String name, Serializable value) {
        this.target.setSystemProp(name, value);
    }

    public <T extends Serializable> T getSystemProp(String name, Class<T> type) {
        return (T)this.target.getSystemProp(name, type);
    }

    public String getChangeToken() {
        String proxyToken = this.proxy.getChangeToken();
        String targetToken = this.target.getChangeToken();
        return SQLDocumentProxy.getProxyChangeToken(proxyToken, targetToken);
    }

    protected static String getProxyChangeToken(String proxyToken, String targetToken) {
        if (proxyToken == null && targetToken == null) {
            return null;
        }
        if (proxyToken == null) {
            proxyToken = "";
        } else if (targetToken == null) {
            targetToken = "";
        }
        return proxyToken + CHANGE_TOKEN_PROXY_SEP + targetToken;
    }

    public boolean validateUserVisibleChangeToken(String userVisibleChangeToken) {
        String targetToken;
        if (userVisibleChangeToken == null) {
            return true;
        }
        String[] parts = userVisibleChangeToken.split(CHANGE_TOKEN_PROXY_SEP, 2);
        if (parts.length != 2) {
            return false;
        }
        String proxyToken = parts[0];
        if (proxyToken.isEmpty()) {
            proxyToken = null;
        }
        if ((targetToken = parts[1]).isEmpty()) {
            targetToken = null;
        }
        if (proxyToken == null && targetToken == null) {
            return true;
        }
        return this.proxy.validateUserVisibleChangeToken(proxyToken) && this.target.validateUserVisibleChangeToken(targetToken);
    }

    public void markUserChange() {
        this.proxy.markUserChange();
        this.target.markUserChange();
    }

    public Set<String> getAllFacets() {
        return this.target.getAllFacets();
    }

    public String[] getFacets() {
        return this.target.getFacets();
    }

    public boolean hasFacet(String facet) {
        return this.target.hasFacet(facet);
    }

    public boolean addFacet(String facet) {
        return this.target.addFacet(facet);
    }

    public boolean removeFacet(String facet) {
        return this.target.removeFacet(facet);
    }

    public void setRetentionActive(boolean retentionActive) {
        this.target.setRetentionActive(retentionActive);
    }

    public boolean isRetentionActive() {
        return this.target.isRetentionActive();
    }

    public String getLifeCyclePolicy() {
        return this.target.getLifeCyclePolicy();
    }

    public void setLifeCyclePolicy(String policy) {
        this.target.setLifeCyclePolicy(policy);
    }

    public String getLifeCycleState() {
        return this.target.getLifeCycleState();
    }

    public void setCurrentLifeCycleState(String state) {
        this.target.setCurrentLifeCycleState(state);
    }

    public void followTransition(String transition) throws LifeCycleException {
        this.target.followTransition(transition);
    }

    public Collection<String> getAllowedStateTransitions() {
        return this.target.getAllowedStateTransitions();
    }

    public Lock getLock() {
        return this.target.getLock();
    }

    public Lock setLock(Lock lock) {
        return this.target.setLock(lock);
    }

    public Lock removeLock(String owner) {
        return this.target.removeLock(owner);
    }

    public boolean isVersion() {
        return false;
    }

    public Document getBaseVersion() {
        return this.target.getBaseVersion();
    }

    public String getVersionSeriesId() {
        return this.target.getVersionSeriesId();
    }

    public Document getSourceDocument() {
        return this.target;
    }

    public Document checkIn(String label, String checkinComment) {
        return this.target.checkIn(label, checkinComment);
    }

    public void checkOut() {
        this.target.checkOut();
    }

    public boolean isCheckedOut() {
        return this.target.isCheckedOut();
    }

    public boolean isLatestVersion() {
        return this.target.isLatestVersion();
    }

    public boolean isMajorVersion() {
        return this.target.isMajorVersion();
    }

    public boolean isLatestMajorVersion() {
        return this.target.isLatestMajorVersion();
    }

    public boolean isVersionSeriesCheckedOut() {
        return this.target.isVersionSeriesCheckedOut();
    }

    public String getVersionLabel() {
        return this.target.getVersionLabel();
    }

    public String getCheckinComment() {
        return this.target.getCheckinComment();
    }

    public Document getWorkingCopy() {
        return this.target.getWorkingCopy();
    }

    public Calendar getVersionCreationDate() {
        return this.target.getVersionCreationDate();
    }

    public void restore(Document version) {
        this.target.restore(version);
    }

    public List<String> getVersionsIds() {
        return this.target.getVersionsIds();
    }

    public Document getVersion(String label) {
        return this.target.getVersion(label);
    }

    public List<Document> getVersions() {
        return this.target.getVersions();
    }

    public Document getLastVersion() {
        return this.target.getLastVersion();
    }

    public Document getChild(String name) {
        return this.proxy.getChild(name);
    }

    public List<Document> getChildren() {
        return this.proxy.getChildren();
    }

    public List<String> getChildrenIds() {
        return this.proxy.getChildrenIds();
    }

    public boolean hasChild(String name) {
        return this.proxy.hasChild(name);
    }

    public boolean hasChildren() {
        return this.proxy.hasChildren();
    }

    public Document addChild(String name, String typeName) {
        return this.proxy.addChild(name, typeName);
    }

    public void orderBefore(String src, String dest) {
        this.proxy.orderBefore(src, dest);
    }

    public Document getTargetDocument() {
        return this.target;
    }

    public void setTargetDocument(Document target) {
        if (((SQLDocumentLive)this.proxy).isReadOnly()) {
            throw new ReadOnlyPropertyException("Cannot write proxy: " + this);
        }
        if (!target.getVersionSeriesId().equals(this.getVersionSeriesId())) {
            throw new ReadOnlyPropertyException("Cannot set proxy target to different version series");
        }
        this.getSession().setProxyTarget(this.proxy, target);
        this.target = target;
    }

    public Serializable getPropertyValue(String name) {
        if (this.isPropertyForProxy(name)) {
            return this.proxy.getPropertyValue(name);
        }
        return this.target.getPropertyValue(name);
    }

    public void setPropertyValue(String name, Serializable value) {
        if (this.isPropertyForProxy(name)) {
            this.proxy.setPropertyValue(name, value);
        } else {
            this.target.setPropertyValue(name, value);
        }
    }

    public Object getValue(String xpath) throws PropertyException {
        if (this.isPropertyForProxy(xpath)) {
            return this.proxy.getValue(xpath);
        }
        return this.target.getValue(xpath);
    }

    public void setValue(String xpath, Object value) throws PropertyException {
        if (this.isPropertyForProxy(xpath)) {
            this.proxy.setValue(xpath, value);
        } else {
            this.target.setValue(xpath, value);
        }
    }

    public void visitBlobs(Consumer<Document.BlobAccessor> blobVisitor) throws PropertyException {
        this.proxy.visitBlobs(blobVisitor);
        this.target.visitBlobs(blobVisitor);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.target + ',' + this.proxy.getUUID() + ')';
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SQLDocumentProxy) {
            return this.equals((SQLDocumentProxy)other);
        }
        return false;
    }

    private boolean equals(SQLDocumentProxy other) {
        return this.proxy.equals(other.proxy) && this.target.equals(other.target);
    }

    public int hashCode() {
        return this.proxy.hashCode() + this.target.hashCode();
    }
}

