/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.storage.sql.ClusterInvalidator;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;

public class JDBCClusterInvalidator
implements ClusterInvalidator {
    private static final Log log = LogFactory.getLog(JDBCClusterInvalidator.class);
    private Serializable nodeId;
    private Mapper mapper;
    private long clusteringDelay;
    private long clusterNodeLastInvalidationTimeMillis;

    @Override
    public void initialize(String nodeId, RepositoryImpl repository) {
        Object nodeIdSer;
        RepositoryDescriptor repositoryDescriptor = repository.getRepositoryDescriptor();
        this.clusteringDelay = repositoryDescriptor.getClusteringDelay();
        this.processClusterInvalidationsNext();
        this.mapper = repository.newMapper(null, false);
        if (this.mapper.getClusterNodeIdType() == 12) {
            nodeIdSer = nodeId;
        } else {
            try {
                nodeIdSer = Long.valueOf(nodeId);
            }
            catch (NumberFormatException e) {
                throw new NuxeoException("Cluster node id must be an integer", (Throwable)e);
            }
        }
        this.nodeId = nodeIdSer;
        try {
            this.mapper.createClusterNode((Serializable)nodeIdSer);
        }
        catch (ConcurrentUpdateException e) {
            e.addInfo("Failed to initialize clustering for repository: " + repository.getName());
            throw e;
        }
        log.info((Object)("Clustering enabled for repository: " + repository.getName() + " with " + this.clusteringDelay + " ms delay  and cluster node id: " + nodeId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Mapper mapper = this.mapper;
        synchronized (mapper) {
            this.mapper.removeClusterNode(this.nodeId);
            this.mapper.close();
        }
    }

    protected void processClusterInvalidationsNext() {
        this.clusterNodeLastInvalidationTimeMillis = System.currentTimeMillis() - this.clusteringDelay - 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Invalidations receiveInvalidations() {
        Mapper mapper = this.mapper;
        synchronized (mapper) {
            long remaining = this.clusterNodeLastInvalidationTimeMillis + this.clusteringDelay - System.currentTimeMillis();
            if (remaining > 0L) {
                log.trace((Object)("Not fetching invalidations, remaining time: " + remaining + "ms"));
                return null;
            }
            Invalidations invalidations = this.mapper.getClusterInvalidations(this.nodeId);
            this.clusterNodeLastInvalidationTimeMillis = System.currentTimeMillis();
            return invalidations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendInvalidations(Invalidations invalidations) {
        if (invalidations == null || invalidations.isEmpty()) {
            return;
        }
        Mapper mapper = this.mapper;
        synchronized (mapper) {
            this.mapper.insertClusterInvalidations(this.nodeId, invalidations);
        }
    }
}

