/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class DialectHSQLDB
extends Dialect {
    public DialectHSQLDB(DatabaseMetaData metadata, RepositoryDescriptor repositoryDescriptor) {
        super(metadata, repositoryDescriptor);
    }

    @Override
    public boolean supportsIfExistsAfterTableName() {
        return true;
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type.spec) {
            case STRING: {
                if (type.isUnconstrained()) {
                    return DialectHSQLDB.jdbcInfo("VARCHAR", 12);
                }
                if (type.isClob()) {
                    return DialectHSQLDB.jdbcInfo("CLOB", 2005);
                }
                return DialectHSQLDB.jdbcInfo("VARCHAR(%d)", type.length, 12);
            }
            case BOOLEAN: {
                return DialectHSQLDB.jdbcInfo("BOOLEAN", 16);
            }
            case LONG: {
                return DialectHSQLDB.jdbcInfo("BIGINT", -5);
            }
            case DOUBLE: {
                return DialectHSQLDB.jdbcInfo("DOUBLE", 8);
            }
            case TIMESTAMP: {
                return DialectHSQLDB.jdbcInfo("TIMESTAMP", 93);
            }
            case BLOBID: {
                return DialectHSQLDB.jdbcInfo("VARCHAR(250)", 12);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEIDPK: 
            case NODEVAL: {
                return DialectHSQLDB.jdbcInfo("VARCHAR(36)", 12);
            }
            case SYSNAME: 
            case SYSNAMEARRAY: {
                return DialectHSQLDB.jdbcInfo("VARCHAR(250)", 12);
            }
            case TINYINT: {
                return DialectHSQLDB.jdbcInfo("TINYINT", -6);
            }
            case INTEGER: {
                return DialectHSQLDB.jdbcInfo("INTEGER", 4);
            }
            case AUTOINC: {
                return DialectHSQLDB.jdbcInfo("INTEGER IDENTITY", 4);
            }
            case FTINDEXED: {
                throw new AssertionError(type);
            }
            case FTSTORED: {
                return DialectHSQLDB.jdbcInfo("CLOB", 2005);
            }
            case CLUSTERNODE: {
                return DialectHSQLDB.jdbcInfo("INTEGER", 4);
            }
            case CLUSTERFRAGS: {
                return DialectHSQLDB.jdbcInfo("VARCHAR", 12);
            }
        }
        throw new AssertionError(type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 12 && actual == 2005) {
            return true;
        }
        if (expected == 2005 && actual == 12) {
            return true;
        }
        if (expected == -5 && actual == 4) {
            return true;
        }
        return expected == 4 && actual == -5;
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                this.setToPreparedStatementString(ps, index, value, column);
                return;
            }
            case 16: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case -6: 
            case -5: 
            case 4: {
                ps.setLong(index, ((Number)value).longValue());
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                this.setToPreparedStatementTimestamp(ps, index, value, column);
                return;
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                return this.getFromResultSetString(rs, index, column);
            }
            case 16: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -6: 
            case -5: 
            case 4: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                return this.getFromResultSetTimestamp(rs, index, column);
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Dialect.FulltextMatchInfo getFulltextScoredMatchInfo(String fulltextQuery, String indexName, int nthMatch, Column mainColumn, Model model, Database database) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return false;
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 2;
    }

    @Override
    public boolean supportsUpdateFrom() {
        return false;
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        return true;
    }

    @Override
    public boolean supportsReadAcl() {
        return false;
    }

    @Override
    public String getUpdateReadAclsSql() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRebuildReadAclsSql() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClobCast(boolean inOrderBy) {
        if (!inOrderBy) {
            return "CAST(%s AS VARCHAR)";
        }
        return null;
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getInTreeSql(String idColumnName, String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getUpsertSql(List<Column> columns, List<Serializable> values, List<Column> outColumns, List<Serializable> outValues) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsArrays() {
        return false;
    }

    @Override
    public String getSQLStatementsFilename() {
        return "nuxeovcs/hsqldb.sql.txt";
    }

    @Override
    public String getTestSQLStatementsFilename() {
        return "nuxeovcs/hsqldb.test.sql.txt";
    }

    @Override
    public Map<String, Serializable> getSQLStatementsProperties(Model model, Database database) {
        return new HashMap<String, Serializable>();
    }

    @Override
    public boolean isClusteringSupported() {
        return false;
    }

    @Override
    public String getClusterInsertInvalidations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClusterGetInvalidations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsPaging() {
        return true;
    }

    @Override
    public String addPagingClause(String sql, long limit, long offset) {
        return sql + String.format(" LIMIT %d OFFSET %d", limit, offset);
    }

    @Override
    public List<String> checkStoredProcedure(String procName, String procCreate, String ddlMode, Connection connection, JDBCLogger logger, Map<String, Serializable> properties) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

