/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public abstract class AbstractTagService
implements TagService {
    public static final String TAG_SANITIZATION_PROP = "nuxeo.tag.sanitization.enabled";

    public boolean isEnabled() {
        return true;
    }

    public void tag(CoreSession session, String docId, String label) throws DocumentSecurityException {
        String cleanLabel = this.cleanLabel(label, true, false);
        String username = AbstractTagService.cleanUsername(session.getPrincipal().getName());
        CoreInstance.doPrivileged((CoreSession)session, s -> this.doTag((CoreSession)s, docId, cleanLabel, username));
        this.fireUpdateEvent(session, docId);
    }

    public void tag(CoreSession session, String docId, String label, String username) {
        this.tag(session, docId, label);
    }

    public void untag(CoreSession session, String docId, String label) throws DocumentSecurityException {
        if (!session.exists((DocumentRef)new IdRef(docId)) || this.canUntag(session, docId, label)) {
            String cleanLabel = this.cleanLabel(label, true, false);
            CoreInstance.doPrivileged((CoreSession)session, s -> this.doUntag((CoreSession)s, docId, cleanLabel));
            if (label != null) {
                this.fireUpdateEvent(session, docId);
            }
        } else {
            String principalName = session.getPrincipal().getName();
            throw new DocumentSecurityException("User '" + principalName + "' is not allowed to remove tag '" + label + "' on document '" + docId + "'");
        }
    }

    public void untag(CoreSession session, String docId, String label, String username) throws DocumentSecurityException {
        this.untag(session, docId, label);
    }

    public boolean canUntag(CoreSession session, String docId, String label) {
        return session.hasPermission((DocumentRef)new IdRef(docId), "Write");
    }

    public Set<String> getTags(CoreSession session, String docId) {
        return (Set)CoreInstance.doPrivileged((CoreSession)session, s -> this.doGetTags((CoreSession)s, docId));
    }

    public List<Tag> getDocumentTags(CoreSession session, String docId, String username) {
        return this.getTags(session, docId).stream().map(t -> new Tag(t, 0)).collect(Collectors.toList());
    }

    public List<Tag> getDocumentTags(CoreSession session, String docId, String username, boolean useCore) {
        return this.getTags(session, docId).stream().map(t -> new Tag(t, 0)).collect(Collectors.toList());
    }

    public void removeTags(CoreSession session, String docId) {
        this.untag(session, docId, null);
    }

    public void copyTags(CoreSession session, String srcDocId, String dstDocId) {
        this.copyTags(session, srcDocId, dstDocId, false);
    }

    protected void copyTags(CoreSession session, String srcDocId, String dstDocId, boolean removeExistingTags) {
        CoreInstance.doPrivileged((CoreSession)session, s -> this.doCopyTags((CoreSession)s, srcDocId, dstDocId, removeExistingTags));
    }

    public void replaceTags(CoreSession session, String srcDocId, String dstDocId) {
        this.copyTags(session, srcDocId, dstDocId, true);
    }

    public List<String> getTagDocumentIds(CoreSession session, String label) {
        String cleanLabel = this.cleanLabel(label, true, false);
        return (List)CoreInstance.doPrivileged((CoreSession)session, s -> this.doGetTagDocumentIds((CoreSession)s, cleanLabel));
    }

    public List<String> getTagDocumentIds(CoreSession session, String label, String username) {
        return this.getTagDocumentIds(session, label);
    }

    public Set<String> getSuggestions(CoreSession session, String label) {
        label = this.cleanLabel(label, true, true);
        if (!this.isTagSanitizationEnabled()) {
            label = label.replace("\\", "\\\\");
        }
        if (!label.contains("%")) {
            label = label + "%";
        }
        String l = label;
        return (Set)CoreInstance.doPrivileged((CoreSession)session, s -> this.doGetTagSuggestions((CoreSession)s, l));
    }

    public List<Tag> getSuggestions(CoreSession session, String label, String username) {
        return this.getSuggestions(session, label).stream().map(t -> new Tag(t, 0)).collect(Collectors.toList());
    }

    protected boolean isTagSanitizationEnabled() {
        return !this.hasFeature(TagService.Feature.TAGS_BELONG_TO_DOCUMENT) || ((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanPropertyTrue(TAG_SANITIZATION_PROP);
    }

    public abstract void doTag(CoreSession var1, String var2, String var3, String var4);

    public abstract void doUntag(CoreSession var1, String var2, String var3);

    public abstract Set<String> doGetTags(CoreSession var1, String var2);

    public abstract void doCopyTags(CoreSession var1, String var2, String var3, boolean var4);

    public abstract List<String> doGetTagDocumentIds(CoreSession var1, String var2);

    public abstract Set<String> doGetTagSuggestions(CoreSession var1, String var2);

    protected String cleanLabel(String label, boolean allowEmpty, boolean allowPercent) {
        if (label == null) {
            if (allowEmpty) {
                return null;
            }
            throw new NuxeoException("Invalid empty tag");
        }
        label = label.toLowerCase();
        if (this.isTagSanitizationEnabled()) {
            label = label.replace(" ", "");
            label = label.replace("/", "");
            label = label.replace("\\", "");
            label = label.replace("'", "");
        }
        if (!allowPercent) {
            label = label.replace("%", "");
        }
        if (label.length() == 0) {
            throw new NuxeoException("Invalid empty tag");
        }
        return label;
    }

    protected static String cleanUsername(String username) {
        return username == null ? null : username.replace("'", "");
    }

    protected static List<Map<String, Serializable>> getItems(String pageProviderName, CoreSession session, Object ... params) {
        Map defProps;
        PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
        if (ppService == null) {
            throw new RuntimeException("Missing PageProvider service");
        }
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        PageProviderDefinition def = ppService.getPageProviderDefinition(pageProviderName);
        if (def != null && (defProps = def.getProperties()) != null) {
            props.putAll(defProps);
        }
        props.put("coreSession", (Serializable)session);
        PageProvider pp = ppService.getPageProvider(pageProviderName, null, null, null, props, params);
        if (pp == null) {
            throw new NuxeoException("Page provider not found: " + pageProviderName);
        }
        return pp.getCurrentPage();
    }

    protected void fireUpdateEvent(CoreSession session, String docId) {
        IdRef documentRef = new IdRef(docId);
        if (session.exists((DocumentRef)documentRef)) {
            DocumentModel documentModel = session.getDocument((DocumentRef)documentRef);
            DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), documentModel);
            Event event = ctx.newEvent("documentTagUpdated");
            ((EventService)Framework.getService(EventService.class)).fireEvent(event);
        }
    }

    protected static enum PAGE_PROVIDERS {
        GET_DOCUMENT_IDS_FOR_FACETED_TAG,
        GET_DOCUMENT_IDS_FOR_TAG,
        GET_FIRST_TAGGING_FOR_DOC_AND_TAG_AND_USER,
        GET_FIRST_TAGGING_FOR_DOC_AND_TAG,
        GET_TAGS_FOR_DOCUMENT,
        GET_TAGS_FOR_DOCUMENT_CORE,
        GET_DOCUMENTS_FOR_TAG,
        GET_TAGS_FOR_DOCUMENT_AND_USER,
        GET_TAGS_FOR_DOCUMENT_AND_USER_CORE,
        GET_DOCUMENTS_FOR_TAG_AND_USER,
        GET_TAGS_TO_COPY_FOR_DOCUMENT,
        GET_FACETED_TAG_SUGGESTIONS,
        GET_TAG_SUGGESTIONS,
        GET_TAG_SUGGESTIONS_FOR_USER,
        GET_TAGGED_DOCUMENTS_UNDER,
        GET_ALL_TAGS,
        GET_ALL_TAGS_FOR_USER,
        GET_TAGS_FOR_DOCUMENTS,
        GET_TAGS_FOR_DOCUMENTS_AND_USER;

    }
}

