/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.platform.tag.AbstractTagService;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;

public class FacetedTagService
extends AbstractTagService {
    private static final Logger log = LogManager.getLogger(FacetedTagService.class);
    public static final String LABEL_PROPERTY = "label";
    public static final String USERNAME_PROPERTY = "username";
    public static final String DISABLE_VERSIONING = "tag.facet.disable.versioning";

    public boolean hasFeature(TagService.Feature feature) {
        switch (feature) {
            case TAGS_BELONG_TO_DOCUMENT: {
                return true;
            }
        }
        throw new UnsupportedOperationException(feature.name());
    }

    public boolean supportsTag(CoreSession session, String docId) {
        return session.getDocument((DocumentRef)new IdRef(docId)).hasFacet("NXTag");
    }

    protected void saveDocument(CoreSession session, DocumentModel doc) {
        doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
        doc.putContextData(DISABLE_VERSIONING, (Serializable)Boolean.TRUE);
        doc.putContextData("disableDublinCoreListener", (Serializable)Boolean.TRUE);
        doc.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
        session.saveDocument(doc);
    }

    @Override
    public void doTag(CoreSession session, String docId, String label, String username) {
        DocumentModel docModel = session.getDocument((DocumentRef)new IdRef(docId));
        if (docModel.isProxy()) {
            throw new NuxeoException("Adding tags is not allowed on proxies");
        }
        List<Map<String, Serializable>> tags = this.getTags(docModel);
        if (tags.stream().noneMatch(t -> label.equals(t.get(LABEL_PROPERTY)))) {
            HashMap<String, String> tag = new HashMap<String, String>();
            tag.put(LABEL_PROPERTY, label);
            tag.put(USERNAME_PROPERTY, username);
            tags.add(tag);
            this.setTags(docModel, tags);
            this.saveDocument(session, docModel);
        }
    }

    @Override
    public void doUntag(CoreSession session, String docId, String label) {
        IdRef docRef = new IdRef(docId);
        if (!session.exists((DocumentRef)docRef)) {
            return;
        }
        DocumentModel docModel = session.getDocument((DocumentRef)docRef);
        if (docModel.isProxy()) {
            throw new NuxeoException("Removing tags is not allowed on proxies");
        }
        if (docModel.hasFacet("NXTag")) {
            if (label == null) {
                if (!this.getTags(docModel).isEmpty()) {
                    this.setTags(docModel, new ArrayList<Map<String, Serializable>>());
                    this.saveDocument(session, docModel);
                }
            } else {
                List<Map<String, Serializable>> tags = this.getTags(docModel);
                Map tag = tags.stream().filter(t -> label.equals(t.get(LABEL_PROPERTY))).findFirst().orElse(null);
                if (tag != null) {
                    tags.remove(tag);
                    this.setTags(docModel, tags);
                    this.saveDocument(session, docModel);
                }
            }
        }
    }

    @Override
    public boolean canUntag(CoreSession session, String docId, String label) {
        DocumentModel docModel;
        Map tag;
        boolean canUntag = super.canUntag(session, docId, label);
        if (!canUntag && (tag = (Map)this.getTags(docModel = session.getDocument((DocumentRef)new IdRef(docId))).stream().filter(t -> label.equals(t.get(LABEL_PROPERTY))).findFirst().orElse(null)) != null) {
            String username = session.getPrincipal().getName();
            canUntag = username.equals(tag.get(USERNAME_PROPERTY));
        }
        return canUntag;
    }

    @Override
    public Set<String> doGetTags(CoreSession session, String docId) {
        IdRef docRef = new IdRef(docId);
        if (!session.exists((DocumentRef)docRef)) {
            return Collections.emptySet();
        }
        DocumentModel docModel = session.getDocument((DocumentRef)docRef);
        List<Map<String, Serializable>> tags = this.getTags(docModel);
        return tags.stream().map(t -> (String)t.get(LABEL_PROPERTY)).collect(Collectors.toSet());
    }

    @Override
    public void doCopyTags(CoreSession session, String srcDocId, String dstDocId, boolean removeExistingTags) {
        DocumentModel srcDocModel = session.getDocument((DocumentRef)new IdRef(srcDocId));
        DocumentModel dstDocModel = session.getDocument((DocumentRef)new IdRef(dstDocId));
        if (!dstDocModel.isProxy()) {
            List<Map<String, Serializable>> dstTags;
            List<Map<String, Serializable>> srcTags = this.getTags(srcDocModel);
            if (removeExistingTags) {
                dstTags = srcTags;
            } else {
                dstTags = this.getTags(dstDocModel);
                for (Map<String, Serializable> tag : srcTags) {
                    if (!dstTags.stream().noneMatch(t -> ((Serializable)tag.get(LABEL_PROPERTY)).equals(t.get(LABEL_PROPERTY)))) continue;
                    dstTags.add(tag);
                }
            }
            this.setTags(dstDocModel, dstTags);
            this.saveDocument(session, dstDocModel);
        }
    }

    @Override
    public List<String> doGetTagDocumentIds(CoreSession session, String label) {
        List<Map<String, Serializable>> res = FacetedTagService.getItems(AbstractTagService.PAGE_PROVIDERS.GET_DOCUMENT_IDS_FOR_FACETED_TAG.name(), session, label);
        if (res == null) {
            return Collections.emptyList();
        }
        return res.stream().map(m -> (String)m.get("ecm:uuid")).collect(Collectors.toList());
    }

    @Override
    public Set<String> doGetTagSuggestions(CoreSession session, String label) {
        List<Map<String, Serializable>> res = FacetedTagService.getItems(AbstractTagService.PAGE_PROVIDERS.GET_FACETED_TAG_SUGGESTIONS.name(), session, label);
        if (res == null) {
            return Collections.emptySet();
        }
        return res.stream().map(m -> (String)m.get("nxtag:tags/*1/label")).collect(Collectors.toSet());
    }

    public List<Tag> getTagCloud(CoreSession session, String docId, String username, Boolean normalize) {
        return Collections.emptyList();
    }

    protected List<Map<String, Serializable>> getTags(DocumentModel docModel) {
        try {
            return (List)((Object)docModel.getPropertyValue("nxtag:tags"));
        }
        catch (PropertyNotFoundException e) {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> ((DocumentModel)docModel).getPathAsString();
            supplierArray[1] = () -> "NXTag";
            supplierArray[2] = () -> ((DocumentModel)docModel).getType();
            log.warn("Getting tags on {} failed since {} is missing on {} document type. This operation will be ignored.", supplierArray);
            return new ArrayList<Map<String, Serializable>>();
        }
    }

    protected void setTags(DocumentModel docModel, List<Map<String, Serializable>> tags) {
        try {
            if (docModel.isVersion()) {
                docModel.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
            }
            docModel.setPropertyValue("nxtag:tags", (Serializable)((Object)tags));
        }
        catch (PropertyNotFoundException e) {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> ((DocumentModel)docModel).getPathAsString();
            supplierArray[1] = () -> "NXTag";
            supplierArray[2] = () -> ((DocumentModel)docModel).getType();
            log.warn("Setting tags on {} failed since {} is missing on {} document type. This operation will be ignored.", supplierArray);
        }
    }
}

