/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.csv.export.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.io.marshallers.csv.AbstractCSVWriter;
import org.nuxeo.ecm.core.io.marshallers.csv.OutputStreamWithCSVWriter;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.platform.csv.export.io.DocumentModelCSVHelper;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DocumentModelCSVWriter
extends AbstractCSVWriter<DocumentModel> {
    public static final String SCHEMAS_CTX_DATA = "schemas";
    public static final String XPATHS_CTX_DATA = "xpaths";

    protected void write(DocumentModel entity, CSVPrinter printer) throws IOException {
        this.writeSystem(entity, printer);
        for (String schemaName : DocumentModelCSVHelper.getList(this.ctx, SCHEMAS_CTX_DATA)) {
            Schema schema = this.schemaManager.getSchema(schemaName);
            if (schema == null) continue;
            this.writeSchema(entity, schema, printer);
        }
        for (String xpath : DocumentModelCSVHelper.getList(this.ctx, XPATHS_CTX_DATA)) {
            Field field = this.schemaManager.getField(xpath);
            if (field == null) continue;
            this.writeProperty(entity, xpath, printer);
        }
    }

    protected void writeHeader(DocumentModel entity, CSVPrinter printer) throws IOException {
        DocumentModelCSVHelper.printSystemPropertiesHeader(printer);
        List<String> schemas = DocumentModelCSVHelper.getList(this.ctx, SCHEMAS_CTX_DATA);
        List<String> xpaths = DocumentModelCSVHelper.getList(this.ctx, XPATHS_CTX_DATA);
        DocumentModelCSVHelper.printPropertiesHeader(schemas, xpaths, printer);
        printer.println();
    }

    protected void writeSystem(DocumentModel doc, CSVPrinter printer) throws IOException {
        printer.print((Object)doc.getRepositoryName());
        printer.print((Object)doc.getId());
        printer.print((Object)doc.getPathAsString());
        printer.print((Object)doc.getType());
        printer.print((Object)(doc.getRef() != null ? doc.getCurrentLifeCycleState() : null));
        printer.print(doc.getParentRef() != null ? doc.getParentRef().toString() : null);
        printer.print((Object)doc.isCheckedOut());
        boolean isVersion = doc.isVersion();
        boolean isProxy = doc.isProxy();
        printer.print((Object)doc.isVersion());
        printer.print((Object)isProxy);
        printer.print((Object)(isProxy ? doc.getSourceId() : null));
        printer.print((Object)(isVersion || isProxy ? doc.getVersionSeriesId() : null));
        printer.print((Object)doc.getChangeToken());
        printer.print((Object)(doc.getRef() != null && doc.isTrashed() ? 1 : 0));
        printer.print((Object)doc.getTitle());
        printer.print((Object)doc.getVersionLabel());
        Lock lock = doc.getLockInfo();
        if (lock != null) {
            printer.print((Object)lock.getOwner());
            this.printCalendar(lock.getCreated(), printer);
        } else {
            printer.print(null);
            printer.print(null);
        }
        if (doc.hasSchema("dublincore")) {
            Calendar cal = (Calendar)doc.getPropertyValue("dc:modified");
            this.printCalendar(cal, printer);
        } else {
            printer.print(null);
        }
    }

    protected void writeSchema(DocumentModel entity, Schema schema, CSVPrinter printer) throws IOException {
        ArrayList<Field> fields = new ArrayList<Field>(schema.getFields());
        fields.sort(Comparator.comparing(o -> o.getName().getLocalName()));
        String prefix = schema.getNamespace().prefix;
        if (StringUtils.isBlank((CharSequence)prefix)) {
            prefix = schema.getName();
        }
        prefix = prefix + ":";
        for (Field field : fields) {
            this.writeProperty(entity, prefix + field.getName().getLocalName(), printer);
        }
    }

    protected void writeProperty(DocumentModel entity, String xpath, CSVPrinter printer) throws IOException {
        Writer propertyWriter = this.registry.getWriter(this.ctx, Property.class, TEXT_CSV_TYPE);
        Property property = null;
        try {
            property = entity.getProperty(xpath);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            // empty catch block
        }
        propertyWriter.write((Object)property, Property.class, Property.class, TEXT_CSV_TYPE, (OutputStream)new OutputStreamWithCSVWriter(printer));
    }
}

