/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.bson.Document;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.BooleanLiteral;
import org.nuxeo.ecm.core.query.sql.model.DateLiteral;
import org.nuxeo.ecm.core.query.sql.model.DoubleLiteral;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.Function;
import org.nuxeo.ecm.core.query.sql.model.IntegerLiteral;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.storage.ExpressionEvaluator;
import org.nuxeo.ecm.core.storage.QueryOptimizer;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBConverter;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public abstract class MongoDBAbstractQueryBuilder {
    public static final Long LONG_ZERO = 0L;
    public static final Long LONG_ONE = 1L;
    public static final Double ONE = 1.0;
    public static final Double MINUS_ONE = -1.0;
    protected static final String DATE_CAST = "DATE";
    protected static final String LIKE_ANCHORED_PROP = "nuxeo.mongodb.like.anchored";
    protected final MongoDBConverter converter;
    protected final Expression expression;
    protected Document query;
    protected String elemMatchPrefix;
    protected boolean likeAnchored;
    protected static final Pattern SLASH_WILDCARD_SLASH = Pattern.compile("/\\*\\d+(/)?");

    public MongoDBAbstractQueryBuilder(MongoDBConverter converter, Expression expression) {
        this.converter = converter;
        this.expression = expression;
        this.likeAnchored = !((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanPropertyFalse(LIKE_ANCHORED_PROP);
    }

    public void walk() {
        this.query = this.expression instanceof MultiExpression && ((MultiExpression)this.expression).predicates.isEmpty() ? new Document() : this.walkExpression(this.expression);
    }

    public Document getQuery() {
        return this.query;
    }

    public Document walkExpression(Expression expr) {
        String cast;
        Operator op = expr.operator;
        Operand lvalue = expr.lvalue;
        Operand rvalue = expr.rvalue;
        Reference ref = lvalue instanceof Reference ? (Reference)lvalue : null;
        String name = ref != null ? ref.name : null;
        String string = cast = ref != null ? ref.cast : null;
        if (DATE_CAST.equals(cast)) {
            this.checkDateLiteralForCast(op, rvalue, name);
        }
        if (op == Operator.SUM) {
            throw new UnsupportedOperationException("SUM");
        }
        if (op == Operator.SUB) {
            throw new UnsupportedOperationException("SUB");
        }
        if (op == Operator.MUL) {
            throw new UnsupportedOperationException("MUL");
        }
        if (op == Operator.DIV) {
            throw new UnsupportedOperationException("DIV");
        }
        if (op == Operator.LT) {
            return this.walkLt(lvalue, rvalue);
        }
        if (op == Operator.GT) {
            return this.walkGt(lvalue, rvalue);
        }
        if (op == Operator.EQ) {
            return this.walkEq(lvalue, rvalue);
        }
        if (op == Operator.NOTEQ) {
            return this.walkNotEq(lvalue, rvalue);
        }
        if (op == Operator.LTEQ) {
            return this.walkLtEq(lvalue, rvalue);
        }
        if (op == Operator.GTEQ) {
            return this.walkGtEq(lvalue, rvalue);
        }
        if (op == Operator.AND || op == Operator.OR) {
            if (expr instanceof MultiExpression) {
                return this.walkAndOrMultiExpression((MultiExpression)expr);
            }
            return this.walkAndOr(expr);
        }
        if (op == Operator.NOT) {
            return this.walkNot(lvalue);
        }
        if (op == Operator.LIKE) {
            return this.walkLike(lvalue, rvalue, true, false);
        }
        if (op == Operator.ILIKE) {
            return this.walkLike(lvalue, rvalue, true, true);
        }
        if (op == Operator.NOTLIKE) {
            return this.walkLike(lvalue, rvalue, false, false);
        }
        if (op == Operator.NOTILIKE) {
            return this.walkLike(lvalue, rvalue, false, true);
        }
        if (op == Operator.IN) {
            return this.walkIn(lvalue, rvalue, true);
        }
        if (op == Operator.NOTIN) {
            return this.walkIn(lvalue, rvalue, false);
        }
        if (op == Operator.ISNULL) {
            return this.walkIsNull(lvalue);
        }
        if (op == Operator.ISNOTNULL) {
            return this.walkIsNotNull(lvalue);
        }
        if (op == Operator.BETWEEN) {
            return this.walkBetween(lvalue, rvalue, true);
        }
        if (op == Operator.NOTBETWEEN) {
            return this.walkBetween(lvalue, rvalue, false);
        }
        throw new QueryParseException("Unknown operator: " + op);
    }

    protected void checkDateLiteralForCast(Operator op, Operand value, String name) {
        if (op == Operator.BETWEEN || op == Operator.NOTBETWEEN) {
            LiteralList l = (LiteralList)value;
            this.checkDateLiteralForCast((Operand)l.get(0), name);
            this.checkDateLiteralForCast((Operand)l.get(1), name);
        } else {
            this.checkDateLiteralForCast(value, name);
        }
    }

    protected void checkDateLiteralForCast(Operand value, String name) {
        if (value instanceof DateLiteral && !((DateLiteral)value).onlyDate) {
            throw new QueryParseException("DATE() cast must be used with DATE literal, not TIMESTAMP: " + name);
        }
    }

    public Document walkNot(Operand value) {
        Object val = this.walkOperand(value);
        Object not = this.pushDownNot(val);
        if (!(not instanceof Document)) {
            throw new QueryParseException("Cannot do NOT on: " + val);
        }
        return (Document)not;
    }

    protected Object pushDownNot(Object object) {
        if (!(object instanceof Document)) {
            throw new QueryParseException("Cannot do NOT on: " + object);
        }
        Document ob = (Document)object;
        Set keySet = ob.keySet();
        if (keySet.size() != 1) {
            throw new QueryParseException("Cannot do NOT on: " + ob);
        }
        String key = (String)keySet.iterator().next();
        Object value = ob.get((Object)key);
        if (!key.startsWith("$")) {
            if (value instanceof Document) {
                return new Document(key, this.pushDownNot(value));
            }
            return new Document(key, (Object)new Document("$ne", value));
        }
        if ("$ne".equals(key)) {
            return value;
        }
        if ("$not".equals(key)) {
            return value;
        }
        if ("$and".equals(key) || "$or".equals(key)) {
            String op = "$and".equals(key) ? "$or" : "$and";
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, this.pushDownNot(list.get(i)));
            }
            return new Document(op, (Object)list);
        }
        if ("$in".equals(key) || "$nin".equals(key)) {
            String op = "$in".equals(key) ? "$nin" : "$in";
            return new Document(op, value);
        }
        if ("$lt".equals(key) || "$gt".equals(key) || "$lte".equals(key) || "$gte".equals(key)) {
            return new Document("$not", (Object)ob);
        }
        throw new QueryParseException("Unknown operator for NOT: " + key);
    }

    protected Document newDocumentWithField(FieldInfo fieldInfo, Object value) {
        return new Document(fieldInfo.queryField, value);
    }

    public Document walkIsNull(Operand value) {
        FieldInfo fieldInfo = this.walkReference(value);
        return this.newDocumentWithField(fieldInfo, null);
    }

    public Document walkIsNotNull(Operand value) {
        FieldInfo fieldInfo = this.walkReference(value);
        return this.newDocumentWithField(fieldInfo, new Document("$ne", null));
    }

    public Document walkAndOrMultiExpression(MultiExpression expr) {
        return this.walkAndOr((Expression)expr, expr.predicates);
    }

    public Document walkAndOr(Expression expr) {
        return this.walkAndOr(expr, Arrays.asList(expr.lvalue, expr.rvalue));
    }

    protected Document walkAndOr(Expression expr, List<? extends Operand> values) {
        if (values.size() == 1) {
            return (Document)this.walkOperand(values.get(0));
        }
        boolean and = expr.operator == Operator.AND;
        String op = and ? "$and" : "$or";
        QueryOptimizer.PrefixInfo info = (QueryOptimizer.PrefixInfo)expr.getInfo();
        if (info == null || info.count < 2 || !and) {
            List<Object> list = this.walkOperandList(values);
            return new Document(op, list);
        }
        String prefix = SLASH_WILDCARD_SLASH.matcher(info.prefix).replaceAll(".");
        String fieldBase = this.stripElemMatchPrefix(prefix.substring(0, prefix.length() - 1));
        String previousElemMatchPrefix = this.elemMatchPrefix;
        this.elemMatchPrefix = prefix;
        List<Object> list = this.walkOperandList(values);
        this.elemMatchPrefix = previousElemMatchPrefix;
        return new Document(fieldBase, (Object)new Document("$elemMatch", (Object)new Document(op, list)));
    }

    protected String stripElemMatchPrefix(String field) {
        if (this.elemMatchPrefix != null && field.startsWith(this.elemMatchPrefix)) {
            field = field.substring(this.elemMatchPrefix.length());
        }
        return field;
    }

    protected Object checkBoolean(FieldInfo fieldInfo, Object right) {
        if (fieldInfo.isBoolean() && right instanceof Long) {
            if (LONG_ZERO.equals(right)) {
                right = fieldInfo.isTrueOrNullBoolean ? null : Boolean.FALSE;
            } else if (LONG_ONE.equals(right)) {
                right = Boolean.TRUE;
            } else {
                throw new QueryParseException("Invalid boolean: " + right);
            }
        }
        return right;
    }

    public Document walkEq(Operand lvalue, Operand rvalue) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object right = this.walkOperand(rvalue);
        right = this.checkBoolean(fieldInfo, right);
        return this.newDocumentWithField(fieldInfo, right);
    }

    public Document walkNotEq(Operand lvalue, Operand rvalue) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object right = this.walkOperand(rvalue);
        right = this.checkBoolean(fieldInfo, right);
        return this.newDocumentWithField(fieldInfo, new Document("$ne", right));
    }

    public Document walkLt(Operand lvalue, Operand rvalue) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object right = this.walkOperand(rvalue);
        return this.newDocumentWithField(fieldInfo, new Document("$lt", right));
    }

    public Document walkGt(Operand lvalue, Operand rvalue) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object right = this.walkOperand(rvalue);
        return this.newDocumentWithField(fieldInfo, new Document("$gt", right));
    }

    public Document walkLtEq(Operand lvalue, Operand rvalue) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object right = this.walkOperand(rvalue);
        return this.newDocumentWithField(fieldInfo, new Document("$lte", right));
    }

    public Document walkGtEq(Operand lvalue, Operand rvalue) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object right = this.walkOperand(rvalue);
        return this.newDocumentWithField(fieldInfo, new Document("$gte", right));
    }

    public Document walkBetween(Operand lvalue, Operand rvalue, boolean positive) {
        LiteralList l = (LiteralList)rvalue;
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object left = this.walkOperand((Operand)l.get(0));
        Object right = this.walkOperand((Operand)l.get(1));
        if (positive) {
            Document range = new Document();
            range.put("$gte", left);
            range.put("$lte", right);
            return this.newDocumentWithField(fieldInfo, range);
        }
        Document a = this.newDocumentWithField(fieldInfo, new Document("$lt", left));
        Document b = this.newDocumentWithField(fieldInfo, new Document("$gt", right));
        return new Document("$or", Arrays.asList(a, b));
    }

    public Document walkIn(Operand lvalue, Operand rvalue, boolean positive) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object right = this.walkOperand(rvalue);
        if (!(right instanceof List)) {
            throw new QueryParseException("Invalid IN, right hand side must be a list: " + rvalue);
        }
        List list = (List)right;
        return this.newDocumentWithField(fieldInfo, new Document(positive ? "$in" : "$nin", (Object)list));
    }

    public Document walkLike(Operand lvalue, Operand rvalue, boolean positive, boolean caseInsensitive) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("Invalid LIKE/ILIKE, right hand side must be a string: " + rvalue);
        }
        String like = this.walkStringLiteral((StringLiteral)rvalue);
        String regex = ExpressionEvaluator.likeToRegex((String)like);
        if (regex.startsWith(".*")) {
            regex = regex.substring(2);
        } else if (this.likeAnchored) {
            regex = "^" + regex;
        }
        if (regex.endsWith(".*")) {
            regex = regex.substring(0, regex.length() - 2);
        } else if (this.likeAnchored) {
            regex = regex + "$";
        }
        int flags = caseInsensitive ? 2 : 0;
        Pattern pattern = Pattern.compile(regex, flags);
        Pattern value = positive ? pattern : new Document("$not", (Object)pattern);
        return this.newDocumentWithField(fieldInfo, value);
    }

    public Object walkOperand(Operand op) {
        if (op instanceof Literal) {
            return this.walkLiteral((Literal)op);
        }
        if (op instanceof LiteralList) {
            return this.walkLiteralList((LiteralList)op);
        }
        if (op instanceof Function) {
            return this.walkFunction((Function)op);
        }
        if (op instanceof Expression) {
            return this.walkExpression((Expression)op);
        }
        if (op instanceof Reference) {
            return this.walkReference((Reference)op);
        }
        throw new QueryParseException("Unknown operand: " + op);
    }

    public Object walkLiteral(Literal lit) {
        if (lit instanceof BooleanLiteral) {
            return this.walkBooleanLiteral((BooleanLiteral)lit);
        }
        if (lit instanceof DateLiteral) {
            return this.walkDateLiteral((DateLiteral)lit);
        }
        if (lit instanceof DoubleLiteral) {
            return this.walkDoubleLiteral((DoubleLiteral)lit);
        }
        if (lit instanceof IntegerLiteral) {
            return this.walkIntegerLiteral((IntegerLiteral)lit);
        }
        if (lit instanceof StringLiteral) {
            return this.walkStringLiteral((StringLiteral)lit);
        }
        throw new QueryParseException("Unknown literal: " + lit);
    }

    public Object walkBooleanLiteral(BooleanLiteral lit) {
        return lit.value;
    }

    public Date walkDateLiteral(DateLiteral lit) {
        return lit.value.toDate();
    }

    public Double walkDoubleLiteral(DoubleLiteral lit) {
        return lit.value;
    }

    public Long walkIntegerLiteral(IntegerLiteral lit) {
        return lit.value;
    }

    public String walkStringLiteral(StringLiteral lit) {
        return lit.value;
    }

    public List<Object> walkLiteralList(LiteralList litList) {
        ArrayList<Object> list = new ArrayList<Object>(litList.size());
        for (Literal lit : litList) {
            list.add(this.walkLiteral(lit));
        }
        return list;
    }

    protected List<Object> walkOperandList(List<? extends Operand> values) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (Operand operand : values) {
            list.add(this.walkOperand(operand));
        }
        return list;
    }

    public Object walkFunction(Function func) {
        throw new UnsupportedOperationException(func.name);
    }

    protected FieldInfo walkReference(Operand value) {
        if (!(value instanceof Reference)) {
            throw new QueryParseException("Invalid query, left hand side must be a property: " + value);
        }
        return this.walkReference((Reference)value);
    }

    public FieldInfo walkReference(Reference ref) {
        Type type;
        FieldInfo fieldInfo = this.walkReference(ref.name);
        if (!(!DATE_CAST.equals(ref.cast) || (type = fieldInfo.type) instanceof DateType || type instanceof ListType && ((ListType)type).getFieldType() instanceof DateType)) {
            throw new QueryParseException("Cannot cast to " + ref.cast + ": " + ref.name);
        }
        return fieldInfo;
    }

    protected abstract FieldInfo walkReference(String var1);

    public static class FieldInfo {
        public final String prop;
        public final String queryField;
        public final String projectionField;
        public final Type type;
        public final boolean isTrueOrNullBoolean;

        public FieldInfo(String prop, String queryField, String projectionField, Type type, boolean isTrueOrNullBoolean) {
            this.prop = prop;
            this.queryField = queryField;
            this.projectionField = projectionField;
            this.type = type;
            this.isTrueOrNullBoolean = isTrueOrNullBoolean;
        }

        public boolean isBoolean() {
            return this.type instanceof BooleanType;
        }
    }
}

