/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.io.Serializable;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.event.DeletedDocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.ReconnectedEventBundle;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.runtime.api.Framework;

public class ReconnectedEventBundleImpl
implements ReconnectedEventBundle {
    private static final long serialVersionUID = 1L;
    protected EventBundle sourceEventBundle;
    protected String listenerName;
    protected transient List<Event> reconnectedEvents;
    protected transient LoginContext loginCtx;
    protected transient CloseableCoreSession reconnectedCoreSession;
    private static final Log log = LogFactory.getLog(ReconnectedEventBundleImpl.class);

    protected ReconnectedEventBundleImpl() {
    }

    public ReconnectedEventBundleImpl(EventBundle sourceEventBundle) {
        this.sourceEventBundle = sourceEventBundle;
    }

    public ReconnectedEventBundleImpl(EventBundle sourceEventBundle, String listenerName) {
        this.sourceEventBundle = sourceEventBundle;
        this.listenerName = listenerName;
    }

    protected CoreSession getReconnectedCoreSession(String repoName, String originatingUsername) {
        if (this.reconnectedCoreSession == null) {
            try {
                this.loginCtx = Framework.login();
            }
            catch (LoginException e) {
                log.error((Object)"Cannot log in", (Throwable)e);
                return null;
            }
            this.reconnectedCoreSession = CoreInstance.openCoreSessionSystem((String)repoName, (String)originatingUsername);
        } else if (!this.reconnectedCoreSession.getRepositoryName().equals(repoName) && repoName != null) {
            throw new IllegalStateException("Can no reconnected a Bundle tied to several Core instances !");
        }
        return this.reconnectedCoreSession;
    }

    protected List<Event> getReconnectedEvents() {
        if (this.reconnectedEvents == null) {
            this.reconnectedEvents = new ArrayList<Event>();
            for (Event event : this.sourceEventBundle) {
                DocumentModel oldDoc;
                CoreSession session;
                EventContext ctx = event.getContext();
                String repositoryName = ctx.getRepositoryName();
                if (repositoryName == null) {
                    session = null;
                } else {
                    String originatingUsername = ctx.getPrincipal().getActingUser();
                    session = this.getReconnectedCoreSession(repositoryName, originatingUsername);
                }
                ArrayList<Object> newArgs = new ArrayList<Object>();
                Object[] objectArray = ctx.getArguments();
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    DocumentRef ref;
                    Object arg;
                    Object newArg = arg = objectArray[i];
                    if (this.refetchDocumentModel(session, arg) && session.getPrincipal() != null && (ref = (oldDoc = (DocumentModel)arg).getRef()) != null) {
                        try {
                            newArg = session.exists(oldDoc.getRef()) ? session.getDocument(oldDoc.getRef()) : new DeletedDocumentModel(oldDoc);
                        }
                        catch (DocumentNotFoundException e) {
                            log.error((Object)("Can not refetch Doc with ref " + ref.toString()), (Throwable)e);
                        }
                    }
                    newArgs.add(newArg);
                }
                EventContextImpl newCtx = null;
                if (ctx instanceof DocumentEventContext) {
                    newCtx = new DocumentEventContext(session, ctx.getPrincipal(), (DocumentModel)newArgs.get(0), (DocumentRef)newArgs.get(1));
                } else {
                    newCtx = new EventContextImpl(session, ctx.getPrincipal());
                    newCtx.setArgs(newArgs.toArray());
                }
                HashMap<String, Serializable> newProps = new HashMap<String, Serializable>();
                for (Map.Entry<String, Serializable> prop : ctx.getProperties().entrySet()) {
                    Serializable propValue = prop.getValue();
                    if (this.refetchDocumentModel(session, propValue)) {
                        oldDoc = (DocumentModel)propValue;
                        DocumentRef oldRef = oldDoc.getRef();
                        try {
                            if (session.exists(oldRef)) {
                                propValue = session.getDocument(oldRef);
                            } else {
                                log.warn((Object)("Listener " + (this.listenerName == null ? "" : "'" + this.listenerName + "' ") + "cannot refetch missing document: " + oldRef + " (" + oldDoc.getPathAsString() + ")"));
                            }
                        }
                        catch (DocumentNotFoundException e) {
                            log.error((Object)("Can not refetch Doc with ref " + oldRef), (Throwable)e);
                        }
                    }
                    newProps.put(prop.getKey(), propValue);
                }
                newCtx.setProperties(newProps);
                EventImpl newEvt = new EventImpl(event.getName(), newCtx, event.getFlags(), event.getTime());
                this.reconnectedEvents.add(newEvt);
            }
        }
        return this.reconnectedEvents;
    }

    protected boolean refetchDocumentModel(CoreSession session, Object eventProperty) {
        if (eventProperty instanceof DocumentModel && session != null) {
            DocumentModel doc = (DocumentModel)eventProperty;
            return !Boolean.TRUE.equals(doc.getContextData("skipRefetchDocument"));
        }
        return false;
    }

    @Override
    public String getName() {
        return this.sourceEventBundle.getName();
    }

    @Override
    public VMID getSourceVMID() {
        return this.sourceEventBundle.getSourceVMID();
    }

    @Override
    public boolean hasRemoteSource() {
        return this.sourceEventBundle.hasRemoteSource();
    }

    @Override
    public boolean isEmpty() {
        return this.sourceEventBundle.isEmpty();
    }

    @Override
    public Event peek() {
        return this.getReconnectedEvents().get(0);
    }

    @Override
    public void push(Event event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.sourceEventBundle.size();
    }

    @Override
    public Iterator<Event> iterator() {
        return this.getReconnectedEvents().iterator();
    }

    @Override
    public void disconnect() {
        if (this.reconnectedCoreSession != null) {
            this.reconnectedCoreSession.close();
        }
        this.reconnectedCoreSession = null;
        this.reconnectedEvents = null;
        if (this.loginCtx != null) {
            try {
                this.loginCtx.logout();
            }
            catch (LoginException e) {
                log.error((Object)"Cannot log out", (Throwable)e);
            }
            finally {
                this.loginCtx = null;
            }
        }
    }

    @Override
    public boolean containsEventName(String eventName) {
        return this.sourceEventBundle.containsEventName(eventName);
    }

    public List<String> getEventNames() {
        ArrayList<String> eventNames = new ArrayList<String>();
        for (Event event : this.sourceEventBundle) {
            eventNames.add(event.getName());
        }
        return eventNames;
    }
}

