/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.WorkStateHelper;
import org.nuxeo.ecm.core.work.api.Work;

public class SleepWork
extends AbstractWork {
    private static final Logger log = LogManager.getLogger(SleepWork.class);
    public static final String CATEGORY = "SleepWork";
    private static final long serialVersionUID = 1L;
    protected long durationMillis;
    protected String category;
    protected AtomicInteger count = new AtomicInteger();
    protected String partitionKey;
    protected boolean idempotent = true;
    protected boolean coalescing = false;

    public SleepWork(long durationMillis, String category, String id) {
        super(id);
        this.durationMillis = durationMillis;
        this.category = category;
        this.partitionKey = String.valueOf(this.count.incrementAndGet());
        this.setProgress(Work.Progress.PROGRESS_0_PC);
    }

    public SleepWork(long durationMillis, String id) {
        this(durationMillis, CATEGORY, id);
    }

    public SleepWork(long durationMillis) {
        this(durationMillis, CATEGORY, UUID.randomUUID().toString());
    }

    @Deprecated
    public SleepWork(long durationMillis, boolean debug) {
        this(durationMillis, null, CATEGORY);
    }

    @Deprecated
    public SleepWork(long durationMillis, boolean debug, String id) {
        this(durationMillis, null, id);
    }

    @Deprecated
    public SleepWork(long durationMillis, String category, boolean debug) {
        this(durationMillis, category, CATEGORY);
    }

    @Deprecated
    public SleepWork(long durationMillis, String category, boolean debug, String id) {
        this(durationMillis, category, id);
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getTitle() {
        return "Sleep " + this.durationMillis + " ms";
    }

    @Override
    public void work() {
        log.debug("Running " + this);
        try {
            this.doWork();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    protected void doWork() throws InterruptedException {
        long elapsed;
        while ((elapsed = System.currentTimeMillis() - this.getStartTime()) <= this.durationMillis) {
            this.setProgress(new Work.Progress(100.0f * (float)elapsed / (float)this.durationMillis));
            if (this.isSuspending()) {
                this.durationMillis -= elapsed;
                this.suspended();
                return;
            }
            if (WorkStateHelper.isCanceled(this.getId())) {
                this.durationMillis -= elapsed;
                return;
            }
            Thread.sleep(10L);
        }
    }

    @Override
    public String getPartitionKey() {
        return this.partitionKey;
    }

    @Override
    public boolean isIdempotent() {
        return this.idempotent;
    }

    public void setIdempotent(boolean idempotent) {
        this.idempotent = idempotent;
    }

    @Override
    public boolean isCoalescing() {
        return this.coalescing;
    }

    public void setCoalescing(boolean coalescing) {
        this.coalescing = coalescing;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + (this.getId().length() > 10 ? "" : this.getId() + ", ") + this.durationMillis + "ms, " + this.getProgress() + ")";
    }
}

