/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.dublincore.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.platform.dublincore.service.DublinCoreStorageService;
import org.nuxeo.runtime.model.DefaultComponent;

public class DublinCoreStorageServiceImpl
extends DefaultComponent
implements DublinCoreStorageService {
    @Override
    public void setCreationDate(DocumentModel doc, Calendar creationDate) {
        doc.setPropertyValue("dc:created", (Serializable)creationDate);
    }

    @Override
    public void setCreationDate(DocumentModel doc, Calendar creationDate, Event event) {
        this.setCreationDate(doc, creationDate);
    }

    @Override
    public void setIssuedDate(DocumentModel doc, Calendar issuedDate) {
        doc.setPropertyValue("dc:issued", (Serializable)issuedDate);
    }

    @Override
    public void setModificationDate(DocumentModel doc, Calendar modificationDate) {
        doc.setPropertyValue("dc:modified", (Serializable)modificationDate);
        if (doc.getPropertyValue("dc:created") == null) {
            this.setCreationDate(doc, modificationDate);
        }
    }

    @Override
    public void setModificationDate(DocumentModel doc, Calendar modificationDate, Event event) {
        this.setModificationDate(doc, modificationDate);
    }

    @Override
    public void addContributor(DocumentModel doc, Event event) {
        List<String> contributorsList;
        NuxeoPrincipal principal = Objects.requireNonNull(event.getContext().getPrincipal());
        String principalName = principal.getName();
        if (principal instanceof SystemPrincipal && "system".equals(principalName = ((SystemPrincipal)principal).getActingUser()) && !"aboutToCreate".equals(event.getName())) {
            return;
        }
        if (doc.getPropertyValue("dc:creator") == null) {
            doc.setPropertyValue("dc:creator", (Serializable)((Object)principalName));
        }
        if (!(contributorsList = this.getSanitizedExistingContributors(doc)).contains(principalName)) {
            contributorsList.add(principalName);
        }
        doc.setPropertyValue("dc:contributors", (Serializable)((Object)contributorsList));
        doc.setPropertyValue("dc:lastContributor", (Serializable)((Object)principalName));
    }

    protected List<String> getSanitizedExistingContributors(DocumentModel doc) {
        Object[] contributorsArray = (String[])doc.getPropertyValue("dc:contributors");
        if (ArrayUtils.isEmpty((Object[])contributorsArray)) {
            return new ArrayList<String>();
        }
        return Arrays.stream(contributorsArray).map(DublinCoreStorageServiceImpl::stripPrincipalPrefix).distinct().collect(Collectors.toList());
    }

    protected static String stripPrincipalPrefix(String principal) {
        if (principal.startsWith("user:")) {
            return principal.substring("user:".length());
        }
        return principal;
    }
}

