/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.CoreSessionService;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.publisher.api.AbstractBasePublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.helper.PublicationRelationHelper;
import org.nuxeo.ecm.platform.publisher.impl.core.CoreFolderPublicationNode;
import org.nuxeo.ecm.platform.publisher.impl.core.CoreProxyFactory;
import org.nuxeo.ecm.platform.publisher.impl.core.SimpleCorePublishedDocument;
import org.nuxeo.ecm.platform.publisher.impl.core.VirtualCoreFolderPublicationNode;
import org.nuxeo.runtime.api.Framework;

public class SectionPublicationTree
extends AbstractBasePublicationTree {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SectionPublicationTree.class);
    public static final String CAN_ASK_FOR_PUBLISHING = "CanAskForPublishing";
    protected static final String DEFAULT_ROOT_PATH = "/default-domain/sections";
    protected DocumentModel treeRoot;
    protected String sessionId;

    public void initTree(CoreSession coreSession, Map<String, String> parameters, PublishedDocumentFactory factory, String configName, String title) {
        super.initTree(coreSession, parameters, factory, configName, title);
        PathRef ref = new PathRef(this.rootPath);
        boolean exists = coreSession.exists((DocumentRef)ref);
        if (!exists) {
            log.debug((Object)("Root section " + this.rootPath + " doesn't exist. Check publicationTreeConfig with name " + configName));
        }
        if (exists && coreSession.hasPermission((DocumentRef)ref, "Read")) {
            this.treeRoot = coreSession.getDocument((DocumentRef)new PathRef(this.rootPath));
            this.rootNode = new CoreFolderPublicationNode(this.treeRoot, (PublicationTree)this, factory);
        } else {
            this.rootNode = new VirtualCoreFolderPublicationNode(coreSession.getSessionId(), this.rootPath, (PublicationTree)this, factory);
            this.sessionId = coreSession.getSessionId();
        }
    }

    protected CoreSession getCoreSession() {
        String coreSessionId = this.treeRoot == null ? this.sessionId : this.treeRoot.getSessionId();
        return ((CoreSessionService)Framework.getService(CoreSessionService.class)).getCoreSession(coreSessionId);
    }

    public List<PublishedDocument> getExistingPublishedDocument(DocumentLocation docLoc) {
        ArrayList<PublishedDocument> publishedDocs = new ArrayList<PublishedDocument>();
        DocumentModelList proxies = this.getCoreSession().getProxies(docLoc.getDocRef(), null);
        for (DocumentModel proxy : proxies) {
            if (!proxy.getPathAsString().startsWith(this.rootPath)) continue;
            publishedDocs.add(this.factory.wrapDocumentModel(proxy));
        }
        return publishedDocs;
    }

    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode) {
        SimpleCorePublishedDocument publishedDocument = (SimpleCorePublishedDocument)super.publish(doc, targetNode);
        PublicationRelationHelper.addPublicationRelation(publishedDocument.getProxy(), (PublicationTree)this);
        return publishedDocument;
    }

    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) {
        SimpleCorePublishedDocument publishedDocument = (SimpleCorePublishedDocument)super.publish(doc, targetNode, params);
        PublicationRelationHelper.addPublicationRelation(publishedDocument.getProxy(), (PublicationTree)this);
        return publishedDocument;
    }

    public void unpublish(DocumentModel doc, PublicationNode targetNode) {
        List publishedDocs = this.getPublishedDocumentInNode(targetNode);
        for (PublishedDocument pubDoc : publishedDocs) {
            if (!pubDoc.getSourceDocumentRef().equals(doc.getRef())) continue;
            this.unpublish(pubDoc);
        }
    }

    public void unpublish(PublishedDocument publishedDocument) {
        if (!this.accept(publishedDocument)) {
            return;
        }
        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
        PublicationRelationHelper.removePublicationRelation(proxy);
        this.getCoreSession().removeDocument(proxy.getRef());
        this.getCoreSession().save();
    }

    public PublicationNode getNodeByPath(String path) {
        PathRef docRef = new PathRef(path);
        if (this.coreSession.hasPermission((DocumentRef)docRef, "Read")) {
            return new CoreFolderPublicationNode(this.coreSession.getDocument((DocumentRef)new PathRef(path)), (PublicationTree)this, this.factory);
        }
        return new VirtualCoreFolderPublicationNode(this.coreSession.getSessionId(), path, (PublicationTree)this, this.factory);
    }

    public void release() {
    }

    protected String getDefaultRootPath() {
        return DEFAULT_ROOT_PATH;
    }

    protected PublishedDocumentFactory getDefaultFactory() {
        return new CoreProxyFactory();
    }

    public boolean canPublishTo(PublicationNode publicationNode) {
        if (publicationNode == null || publicationNode.getParent() == null) {
            return false;
        }
        PathRef docRef = new PathRef(publicationNode.getPath());
        return this.coreSession.hasPermission((DocumentRef)docRef, CAN_ASK_FOR_PUBLISHING);
    }

    public boolean canUnpublish(PublishedDocument publishedDocument) {
        if (!this.accept(publishedDocument)) {
            return false;
        }
        PathRef docRef = new PathRef(publishedDocument.getParentPath());
        return this.coreSession.hasPermission((DocumentRef)docRef, "Write");
    }

    public PublishedDocument wrapToPublishedDocument(DocumentModel documentModel) {
        return this.factory.wrapDocumentModel(documentModel);
    }

    public boolean isPublicationNode(DocumentModel documentModel) {
        return documentModel.getPathAsString().startsWith(this.rootPath);
    }

    public PublicationNode wrapToPublicationNode(DocumentModel documentModel) {
        if (!this.isPublicationNode(documentModel)) {
            throw new NuxeoException("Document " + documentModel.getPathAsString() + " is not a valid publication node.");
        }
        return new CoreFolderPublicationNode(documentModel, (PublicationTree)this, this.factory);
    }

    protected boolean accept(PublishedDocument publishedDocument) {
        return publishedDocument instanceof SimpleCorePublishedDocument;
    }
}

