/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.CoreSessionService;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.platform.publisher.api.AbstractPublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.impl.core.CoreFolderPublicationNode;
import org.nuxeo.runtime.api.Framework;

public class VirtualCoreFolderPublicationNode
extends AbstractPublicationNode {
    private static final long serialVersionUID = 1L;
    protected static String ACCESSIBLE_CHILDREN_QUERY = "SELECT * FROM Document WHERE ecm:primaryType = 'Section' AND ecm:path STARTSWITH %s AND ecm:isVersion = 0 AND ecm:isProxy = 0  AND ecm:isTrashed = 0 ";
    protected String coreSessionId;
    protected String path;
    protected PublishedDocumentFactory factory;

    public VirtualCoreFolderPublicationNode(String coreSessionId, String documentPath, PublicationTree tree, PublishedDocumentFactory factory) {
        super(tree);
        this.coreSessionId = coreSessionId;
        this.path = documentPath;
        this.factory = factory;
    }

    public String getTitle() {
        return "Sections";
    }

    public String getName() {
        return "sections";
    }

    public PublicationNode getParent() {
        return null;
    }

    public List<PublicationNode> getChildrenNodes() {
        ArrayList<PublicationNode> childrenNodes = new ArrayList<PublicationNode>();
        CoreSession session = this.getCoreSession();
        if (session != null) {
            String query = String.format(ACCESSIBLE_CHILDREN_QUERY, NXQL.escapeString((String)this.path));
            DocumentModelList docs = session.query(query);
            for (DocumentModel doc : docs) {
                Path path = doc.getPath().removeLastSegments(1);
                boolean foundParent = false;
                for (DocumentModel d : docs) {
                    if (!d.getPath().equals((Object)path)) continue;
                    foundParent = true;
                }
                if (foundParent) continue;
                childrenNodes.add((PublicationNode)new CoreFolderPublicationNode(doc, this.tree, (PublicationNode)this, this.factory));
            }
        }
        return childrenNodes;
    }

    protected CoreSession getCoreSession() {
        return ((CoreSessionService)Framework.getService(CoreSessionService.class)).getCoreSession(this.coreSessionId);
    }

    public List<PublishedDocument> getChildrenDocuments() {
        return Collections.emptyList();
    }

    public String getPath() {
        return this.path;
    }
}

