/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.io.plugins.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetSelectOption;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetSelectOptionImpl;
import org.nuxeo.ecm.platform.forms.layout.io.plugins.helpers.TranslationHelper;
import org.nuxeo.runtime.api.Framework;

public class VocabularyHelper {
    private static final Log log = LogFactory.getLog(VocabularyHelper.class);
    public static final String PARENT_PROPERTY_NAME = "parent";
    public static final String LABEL_PROPERTY_NAME = "label";
    public static final String SUBDIRECTORY_SEPARATOR = "/";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<WidgetSelectOption> getVocabularySelectOptions(String dirName, String lang) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(dirName);){
            String schema = ds.getDirectory(dirName).getSchema();
            DocumentModelList entries = session.getEntries();
            List<WidgetSelectOption> list = VocabularyHelper.convertToSelectOptions(entries, schema, dirName, lang);
            return list;
        }
        catch (DirectoryException e) {
            log.error((Object)("Error while getting content of directory " + dirName), (Throwable)e);
            return Collections.emptyList();
        }
    }

    /*
     * Exception decompiling
     */
    public static List<WidgetSelectOption> getChainSelectVocabularySelectOptions(String parentDirName, String childDirName, String lang) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<WidgetSelectOption> convertToSelectOptions(DocumentModelList entries, String schema, String directoryName, String lang) {
        ArrayList<WidgetSelectOption> res = new ArrayList<WidgetSelectOption>();
        for (DocumentModel entry : entries) {
            String itemLabel;
            String itemValue;
            block4: {
                itemLabel = itemValue = entry.getId();
                try {
                    itemLabel = (String)entry.getProperty(schema, LABEL_PROPERTY_NAME);
                    if (lang != null) {
                        itemLabel = TranslationHelper.getTranslation(itemLabel, lang);
                    }
                }
                catch (PropertyException e) {
                    if (lang == null) break block4;
                    itemLabel = (String)entry.getProperty(schema, "label_" + lang);
                }
            }
            WidgetSelectOptionImpl selectOption = new WidgetSelectOptionImpl(itemLabel, itemValue);
            res.add((WidgetSelectOption)selectOption);
        }
        return res;
    }
}

