/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf.service;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDPixelMap;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.pdf.PDFUtils;
import org.nuxeo.ecm.platform.pdf.service.PDFTransformationService;
import org.nuxeo.ecm.platform.pdf.service.watermark.WatermarkProperties;
import org.nuxeo.runtime.model.DefaultComponent;

public class PDFTransformationServiceImpl
extends DefaultComponent
implements PDFTransformationService {
    protected static final Log log = LogFactory.getLog(PDFTransformationServiceImpl.class);
    protected static final String MIME_TYPE = "application/pdf";

    @Override
    public WatermarkProperties getDefaultProperties() {
        return new WatermarkProperties();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Blob applyTextWatermark(Blob input, String text, WatermarkProperties properties) {
        PDExtendedGraphicsState extendedGraphicsState = new PDExtendedGraphicsState();
        extendedGraphicsState.setNonStrokingAlphaConstant(Float.valueOf((float)properties.getAlphaColor()));
        try (PDDocument pdfDoc = PDDocument.load((InputStream)input.getStream());){
            PDType1Font font = PDType1Font.getStandardFont((String)properties.getFontFamily());
            float watermarkWidth = (float)((double)font.getStringWidth(text) * properties.getFontSize() / 1000.0);
            int[] rgb = PDFUtils.hex255ToRGB(properties.getHex255Color());
            for (PDPage page : pdfDoc.getDocumentCatalog().getAllPages()) {
                PDRectangle pageSize = page.findMediaBox();
                PDResources resources = page.findResources();
                HashMap<String, PDExtendedGraphicsState> graphicsStates = resources.getGraphicsStates();
                if (graphicsStates == null) {
                    graphicsStates = new HashMap<String, PDExtendedGraphicsState>();
                }
                graphicsStates.put("TransparentState", extendedGraphicsState);
                resources.setGraphicsStates(graphicsStates);
                PDPageContentStream contentStream = new PDPageContentStream(pdfDoc, page, true, true, true);
                Throwable throwable = null;
                try {
                    contentStream.beginText();
                    contentStream.setFont((PDFont)font, (float)properties.getFontSize());
                    contentStream.appendRawCommands("/TransparentState gs\n");
                    contentStream.setNonStrokingColor(rgb[0], rgb[1], rgb[2]);
                    Point2D position = this.computeTranslationVector(pageSize.getWidth(), watermarkWidth, pageSize.getHeight(), properties.getFontSize(), properties);
                    contentStream.setTextRotation(Math.toRadians(properties.getRotation()), position.getX(), position.getY());
                    contentStream.drawString(text);
                    contentStream.endText();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (contentStream == null) continue;
                    if (throwable != null) {
                        try {
                            contentStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    contentStream.close();
                }
            }
            Blob blob = this.saveInTempFile(pdfDoc);
            return blob;
        }
        catch (IOException | COSVisitorException e) {
            throw new NuxeoException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Blob applyImageWatermark(Blob input, Blob watermark, WatermarkProperties properties) {
        PDExtendedGraphicsState extendedGraphicsState = new PDExtendedGraphicsState();
        extendedGraphicsState.setNonStrokingAlphaConstant(Float.valueOf((float)properties.getAlphaColor()));
        try (PDDocument pdfDoc = PDDocument.load((InputStream)input.getStream());){
            BufferedImage image = ImageIO.read(watermark.getStream());
            PDPixelMap ximage = new PDPixelMap(pdfDoc, image);
            for (PDPage page : pdfDoc.getDocumentCatalog().getAllPages()) {
                PDRectangle pageSize = page.findMediaBox();
                PDResources resources = page.findResources();
                HashMap<String, PDExtendedGraphicsState> graphicsStates = resources.getGraphicsStates();
                if (graphicsStates == null) {
                    graphicsStates = new HashMap<String, PDExtendedGraphicsState>();
                }
                graphicsStates.put("TransparentState", extendedGraphicsState);
                resources.setGraphicsStates(graphicsStates);
                PDPageContentStream contentStream = new PDPageContentStream(pdfDoc, page, true, true);
                Throwable throwable = null;
                try {
                    contentStream.appendRawCommands("/TransparentState gs\n");
                    contentStream.endMarkedContentSequence();
                    double watermarkWidth = (double)ximage.getWidth() * properties.getScale();
                    double watermarkHeight = (double)ximage.getHeight() * properties.getScale();
                    Point2D position = this.computeTranslationVector(pageSize.getWidth(), watermarkWidth, pageSize.getHeight(), watermarkHeight, properties);
                    contentStream.drawXObject((PDXObject)ximage, (float)position.getX(), (float)position.getY(), (float)watermarkWidth, (float)watermarkHeight);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (contentStream == null) continue;
                    if (throwable != null) {
                        try {
                            contentStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    contentStream.close();
                }
            }
            Blob blob = this.saveInTempFile(pdfDoc);
            return blob;
        }
        catch (IOException | COSVisitorException e) {
            throw new NuxeoException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Blob overlayPDF(Blob input, Blob overlayBlob) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Point2D computeTranslationVector(double pageWidth, double watermarkWidth, double pageHeight, double watermarkHeight, WatermarkProperties properties) {
        double yTranslation;
        double xTranslation;
        double xRotationOffset = 0.0;
        double yRotationOffset = 0.0;
        if (properties.getRotation() != 0) {
            Rectangle2D.Double rectangle2D = new Rectangle2D.Double(0.0, -watermarkHeight, watermarkWidth, watermarkHeight);
            AffineTransform at = AffineTransform.getRotateInstance(-Math.toRadians(properties.getRotation()), 0.0, 0.0);
            Shape shape = at.createTransformedShape(rectangle2D);
            Rectangle2D rotated = shape.getBounds2D();
            watermarkWidth = rotated.getWidth();
            xRotationOffset = !properties.isInvertX() || properties.isRelativeCoordinates() ? -rotated.getX() : rotated.getX();
            watermarkHeight = rotated.getHeight();
            yRotationOffset = !properties.isInvertY() || properties.isRelativeCoordinates() ? rotated.getY() + rotated.getHeight() : -(rotated.getY() + rotated.getHeight());
        }
        if (properties.isRelativeCoordinates()) {
            xTranslation = (pageWidth - watermarkWidth) * properties.getxPosition() + xRotationOffset;
            yTranslation = (pageHeight - watermarkHeight) * properties.getyPosition() + yRotationOffset;
        } else {
            xTranslation = properties.getxPosition() + xRotationOffset;
            yTranslation = properties.getyPosition() + yRotationOffset;
            if (properties.isInvertX()) {
                xTranslation = pageWidth - watermarkWidth - xTranslation;
            }
            if (properties.isInvertY()) {
                yTranslation = pageHeight - watermarkHeight - yTranslation;
            }
        }
        return new Point2D.Double(xTranslation, yTranslation);
    }

    protected Blob saveInTempFile(PDDocument PdfDoc) throws IOException, COSVisitorException {
        Blob blob = Blobs.createBlobWithExtension((String)".pdf");
        blob.setMimeType(MIME_TYPE);
        PdfDoc.save(blob.getFile());
        return blob;
    }
}

