/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.content.template.factories;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.content.template.factories.BaseContentFactory;
import org.nuxeo.ecm.platform.content.template.service.ACEDescriptor;
import org.nuxeo.ecm.platform.content.template.service.TemplateItemDescriptor;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.runtime.api.Framework;

public class ImportBasedFactory
extends BaseContentFactory {
    private static final Logger log = LogManager.getLogger(ImportBasedFactory.class);
    public static final String IMPORT_FILE_PATH_OPTION = "path";
    public static final String IMPORT_OVERWRITE_OPTION = "overwrite";
    protected FileManager fileManager;
    protected Map<String, String> options;
    protected File importedFile;
    protected Boolean overwrite = false;

    @Override
    public boolean initFactory(Map<String, String> options, List<ACEDescriptor> rootAcl, List<TemplateItemDescriptor> template) {
        this.options = options;
        this.overwrite = Boolean.valueOf(options.get(IMPORT_OVERWRITE_OPTION));
        String path = options.get(IMPORT_FILE_PATH_OPTION);
        File file = PathOptions.getResource(path);
        if (file != null) {
            if (file.exists()) {
                this.importedFile = file;
                return true;
            }
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = file::getAbsolutePath;
            log.warn("Following file does not exist: {}", supplierArray);
        }
        return false;
    }

    @Override
    public void createContentStructure(DocumentModel eventDoc) {
        this.initSession(eventDoc);
        if (eventDoc.isVersion()) {
            return;
        }
        try {
            String parentPath = eventDoc.getPathAsString();
            this.importBlob(this.importedFile, parentPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot import file: " + this.importedFile, e);
        }
    }

    protected void importBlob(File file, String parentPath) throws IOException {
        if (file.isDirectory()) {
            File[] files;
            DocumentModel createdFolder = this.getFileManagerService().createFolder(this.session, file.getAbsolutePath(), parentPath, true);
            for (File childFile : files = file.listFiles()) {
                this.importBlob(childFile, createdFolder.getPathAsString());
            }
        } else {
            Blob fb = Blobs.createBlob((File)file);
            fb.setFilename(file.getName());
            FileImporterContext context = FileImporterContext.builder((CoreSession)this.session, (Blob)fb, (String)parentPath).overwrite(this.overwrite.booleanValue()).build();
            this.getFileManagerService().createOrUpdateDocument(context);
        }
    }

    protected FileManager getFileManagerService() {
        if (this.fileManager == null) {
            this.fileManager = (FileManager)Framework.getService(FileManager.class);
        }
        return this.fileManager;
    }

    public static enum PathOptions {
        resource{

            @Override
            public File getFile(String path) {
                return FileUtils.getResourceFileFromContext((String)path);
            }
        }
        ,
        nxData{

            @Override
            public File getFile(String path) {
                File nxDdataFolder = Environment.getDefault().getData();
                return new File(nxDdataFolder, path);
            }
        }
        ,
        absolute{

            @Override
            public File getFile(String path) {
                return new File(path);
            }
        };


        protected abstract File getFile(String var1);

        public static File getResource(String path) {
            String[] s = path.split(":", 2);
            String resourceType = s[0];
            String resourcePath = s[1];
            PathOptions option = PathOptions.valueOf(resourceType);
            if (option == null) {
                log.error("Unsupported resource type: {}", (Object)resourceType);
                return null;
            }
            return option.getFile(resourcePath);
        }
    }
}

