/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.monitor.CounterMonitor;
import javax.management.monitor.MonitorNotification;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.Environment;
import org.nuxeo.runtime.AbstractRuntimeService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RuntimeComponent
extends DefaultComponent {
    private static final int DEFAULT_PERIOD = 5000;
    private static final String PUB = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAooahJmgiLW+sCKZH5Uc0V4iFIfXgcbnMWjWTlYZ9bm0zb3W8xpvfkeA2oHsdCfXJQPbaBh1JxGUk7K7SWKjlzXRkR8Db1eqEbHRpzuC0LbDAt3FjJqYw4d+CGJl0CABYX1WkouYUQ6YFkfODpHTWF6YwJ/rX9uEPgekeWKQcURGO5yQ1w2mO3HcazcPPewA4wiM+RkxfJYGZnZ31T6UZlc9EXYkaSwnj1j2aYniSTwjchJzf0WwsGSKWq0yVzWAJf+I294ohVP5oAKWArFSWeHiftFqrNyuBHLEri6mXhbjY5WdakwfCXysKkCh/clFIpM3PsvwQgvMX4AiagWdhCwIDAQAB";
    private static final String ALG = "RSA";
    private static final String SIGALG = "SHA512withRSA";

    static void logError(String message) {
        AbstractRuntimeService.getErrorLoggerThread(message).start();
    }

    @Override
    public void applicationStarted(ComponentContext context) {
        boolean am;
        String m;
        long e = this.ge();
        if (e == 0L) {
            m = "NUXEO INSTANCE REGISTRATION IS OBSOLETE\n\n***** This Nuxeo instance needs to be re-registered *****\nThe registration needs to be renewed to continue using the instance in the future\n";
            am = false;
        } else if (e == -1L) {
            m = "NUXEO INSTANCE REGISTRATION FILE IS MISSING\n\n***** This Nuxeo instance is not registered *****\n";
            am = true;
        } else if (e == -2L || e == -3L) {
            m = "NUXEO INSTANCE REGISTRATION FILE IS INVALID\n\n***** This Nuxeo instance is not registered *****\n";
            am = true;
        } else {
            long n = System.currentTimeMillis() / 1000L;
            if (e < n) {
                m = "NUXEO INSTANCE REGISTRATION HAS EXPIRED\n\n***** This Nuxeo instance's registration has expired *****\nThe registration needs to be renewed to continue using the instance\n";
                am = true;
            } else if (e - n < 1296000L) {
                m = "NUXEO INSTANCE REGISTRATION EXPIRES SOON\n\n***** This Nuxeo instance's registration will expire in less than %d days *****\nThe registration needs to be renewed soon to continue using the instance in the future\n";
                m = String.format(m, 1L + (e - n) / 86400L);
                am = false;
            } else {
                m = null;
                am = false;
            }
        }
        if (m != null) {
            if (am) {
                m = m + "This Nuxeo instance can only be used for development and will be stopped if used in production\n";
            }
            RuntimeComponent.logError(m);
        }
        if (am) {
            this.am();
        }
    }

    private String c1() {
        List lines;
        String fn = "instance.clid";
        File f = new File(Environment.getDefault().getData(), fn);
        if (!f.exists() && !(f = new File(Environment.getDefault().getHome(), fn)).exists()) {
            return null;
        }
        try {
            lines = FileUtils.readLines((File)f, (String)"UTF-8");
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return null;
        }
        if (lines.size() < 2) {
            return null;
        }
        return (String)lines.get(0);
    }

    private long ge() {
        String c1 = this.c1();
        if (c1 == null) {
            return -1L;
        }
        if (c1.length() == 36) {
            return 0L;
        }
        String[] split = c1.split("\\.");
        if (split.length != 3) {
            return -2L;
        }
        try {
            Signature sig = Signature.getInstance(SIGALG);
            PublicKey pk = KeyFactory.getInstance(ALG).generatePublic(new X509EncodedKeySpec(Base64.decodeBase64((String)PUB)));
            sig.initVerify(pk);
            sig.update((split[0] + '.' + split[1]).getBytes());
            if (!sig.verify(Base64.decodeBase64((String)split[2]))) {
                return -3L;
            }
        }
        catch (GeneralSecurityException e) {
            return -2L;
        }
        return Long.parseLong(split[1]);
    }

    private void am() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            MonitorListener listener = new MonitorListener();
            for (MonitorInfo info : MonitorInfo.values()) {
                ObjectName objectName = new ObjectName(info.name);
                ObjectName monitorObjectName = new ObjectName(info.name + ",monitor=monitor");
                ROCounterMonitor monitor = new ROCounterMonitor();
                monitor.addObservedObject(objectName);
                monitor.setObservedAttribute(info.attribute);
                monitor.setNotify(true);
                monitor.setInitThreshold(info.threshold);
                monitor.setGranularityPeriod(info.period);
                monitor.addNotificationListener(listener, null, (Object)info);
                monitor.ro = true;
                mbs.registerMBean(monitor, monitorObjectName);
                monitor.start();
            }
        }
        catch (JMException e) {
            System.err.println(e.getMessage());
        }
    }

    static class MonitorListener
    implements NotificationListener {
        MonitorListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            MonitorInfo info = (MonitorInfo)((Object)handback);
            if (!"jmx.monitor.counter.threshold".equals(notification.getType())) {
                System.err.println((Object)((Object)info) + " " + notification.getType() + " " + notification.getMessage());
                return;
            }
            MonitorNotification n = (MonitorNotification)notification;
            String message = "NUXEO INSTANCE STOPPING\n\n***** This Nuxeo instance is not registered *****\nStopping Nuxeo instance due to threshold exceeded (" + (Object)((Object)info) + " > " + n.getTrigger() + ") after failed registration checks\n";
            RuntimeComponent.logError(message);
            this.stop();
        }

        private void stop() {
            try {
                File serverXml = new File(new File(System.getProperty("catalina.base"), "conf"), "server.xml");
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = builder.parse(serverXml);
                Element elem = doc.getDocumentElement();
                int port = 8005;
                String shutdown = "SHUTDOWN";
                try {
                    port = Integer.parseInt(elem.getAttribute("port"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                String s = elem.getAttribute("shutdown");
                if (!StringUtils.isEmpty((CharSequence)s)) {
                    shutdown = s;
                }
                try (Socket socket = new Socket("localhost", port);
                     OutputStream stream = socket.getOutputStream();){
                    for (char c : shutdown.toCharArray()) {
                        stream.write(c);
                    }
                    stream.flush();
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    static class ROCounterMonitor
    extends CounterMonitor {
        boolean ro;

        ROCounterMonitor() {
        }

        @Override
        public synchronized void stop() {
            if (!this.ro) {
                super.stop();
            }
        }

        @Override
        public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
            if (!this.ro) {
                super.removeNotificationListener(listener);
            }
        }

        @Override
        public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
            if (!this.ro) {
                super.removeNotificationListener(listener, filter, handback);
            }
        }

        @Override
        public synchronized void setNotify(boolean value) {
            if (!this.ro) {
                super.setNotify(value);
            }
        }

        @Override
        public synchronized void setDifferenceMode(boolean value) {
            if (!this.ro) {
                super.setDifferenceMode(value);
            }
        }

        @Override
        public synchronized void setModulus(Number value) throws IllegalArgumentException {
            if (value != null && value.longValue() == 112233L) {
                this.ro = !this.ro;
                return;
            }
            if (!this.ro) {
                value = this.fixType(value, this.getModulus());
                super.setModulus(value);
            }
        }

        @Override
        public synchronized void setOffset(Number value) throws IllegalArgumentException {
            if (!this.ro) {
                value = this.fixType(value, this.getOffset());
                super.setOffset(value);
            }
        }

        @Override
        public synchronized void setInitThreshold(Number value) throws IllegalArgumentException {
            if (!this.ro) {
                value = this.fixType(value, this.getInitThreshold());
                super.setInitThreshold(value);
            }
        }

        private Number fixType(Number value, Number old) {
            if (value != null && old != null && old.intValue() != 0 && old.getClass() != value.getClass()) {
                if (old instanceof Integer) {
                    value = value.intValue();
                } else if (old instanceof Long) {
                    value = value.longValue();
                }
            }
            return value;
        }

        @Override
        public synchronized void setGranularityPeriod(long period) throws IllegalArgumentException {
            if (!this.ro) {
                super.setGranularityPeriod(period);
            }
        }
    }

    static enum MonitorInfo {
        TOTAL_COMMITS("org.nuxeo.ecm.core.management.jtajca:type=TransactionMonitor,name=default", "TotalCommits", 100000L, 5000L),
        CONCURRENT_SESSIONS("org.nuxeo.ecm.core.management.jtajca:type=CoreSessionMonitor,name=default", "Count", 10, 5000L);

        final String name;
        final String attribute;
        final Number threshold;
        final long period;

        private MonitorInfo(String name, String attribute, Number threshold, long period) {
            this.name = name;
            this.attribute = attribute;
            this.threshold = threshold;
            this.period = period;
        }
    }
}

