/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.services.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.logging.DeprecationLogger;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.services.config.ConfigurationPropertyDescriptor;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class ConfigurationServiceImpl
extends DefaultComponent
implements ConfigurationService {
    protected static final Log log = LogFactory.getLog(ConfigurationServiceImpl.class);
    public static final String CONFIGURATION_EP = "configuration";
    protected static final JavaPropsMapper PROPERTIES_MAPPER = new JavaPropsMapper();
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected volatile Map<String, ConfigurationPropertyDescriptor> descriptors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ConfigurationPropertyDescriptor> getDescriptors() {
        Map<String, ConfigurationPropertyDescriptor> d = this.descriptors;
        if (d == null) {
            ConfigurationServiceImpl configurationServiceImpl = this;
            synchronized (configurationServiceImpl) {
                d = this.descriptors;
                if (d == null) {
                    List descs = this.getDescriptors(CONFIGURATION_EP);
                    this.descriptors = d = descs.stream().collect(Collectors.toMap(desc -> desc.getId(), desc -> desc));
                }
            }
        }
        return d;
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        ConfigurationPropertyDescriptor conf = this.getDescriptors().get(key);
        if (conf == null) {
            return defaultValue;
        }
        String value = conf.getValue();
        return value != null ? value : defaultValue;
    }

    @Override
    public boolean isBooleanPropertyTrue(String key) {
        String value = this.getProperty(key);
        return Boolean.parseBoolean(value);
    }

    @Override
    public boolean isBooleanPropertyFalse(String key) {
        String value = this.getProperty(key);
        return StringUtils.isNotBlank((CharSequence)value) && !Boolean.parseBoolean(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIGURATION_EP.equals(extensionPoint)) {
            ConfigurationServiceImpl configurationServiceImpl = this;
            synchronized (configurationServiceImpl) {
                this.descriptors = null;
            }
            ConfigurationPropertyDescriptor configurationPropertyDescriptor = (ConfigurationPropertyDescriptor)contribution;
            String key = configurationPropertyDescriptor.getName();
            if (Framework.getProperties().containsKey(key)) {
                String message = "Property '" + key + "' should now be contributed to extension point 'org.nuxeo.runtime.ConfigurationService', using target 'configuration'";
                DeprecationLogger.log(message, "7.4");
                Framework.getRuntime().getMessageHandler().addWarning(message);
            }
            super.registerContribution(contribution, extensionPoint, contributor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIGURATION_EP.equals(extensionPoint)) {
            ConfigurationServiceImpl configurationServiceImpl = this;
            synchronized (configurationServiceImpl) {
                this.descriptors = null;
            }
            super.unregisterContribution(contribution, extensionPoint, contributor);
        }
    }

    @Override
    public Map<String, Serializable> getProperties(String namespace) {
        if (StringUtils.isEmpty((CharSequence)namespace)) {
            return null;
        }
        if (namespace.charAt(namespace.length() - 1) == '.') {
            throw new IllegalArgumentException("namespace cannot end with a dot");
        }
        return this.getDescriptors().values().stream().filter(desc -> ConfigurationServiceImpl.startsWithNamespace(desc.getName(), namespace)).collect(Collectors.toMap(desc -> desc.getId().substring(namespace.length() + 1), desc -> desc.getValue() != null && desc.list ? desc.getValue().split(",") : desc.getValue()));
    }

    @Override
    public String getPropertiesAsJson(String namespace) throws IOException {
        Properties properties = new Properties();
        this.getProperties(namespace).forEach((key, value) -> {
            if (value instanceof String[]) {
                int idx = 1;
                for (String v : (String[])value) {
                    properties.put(String.format("%s.%d", key, idx++), v);
                }
            } else {
                properties.put(key, value);
            }
        });
        return OBJECT_MAPPER.writer().writeValueAsString(PROPERTIES_MAPPER.readPropertiesAs(properties, ObjectNode.class));
    }

    protected static boolean startsWithNamespace(String string, String namespace) {
        int nl = namespace.length();
        return string.length() > nl && string.charAt(nl) == '.' && string.startsWith(namespace);
    }
}

