/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.io;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class LogEntryJsonWriter
extends ExtensibleEntityJsonWriter<LogEntry> {
    public static final String ENTITY_TYPE = "logEntry";

    public LogEntryJsonWriter() {
        super(ENTITY_TYPE, LogEntry.class);
    }

    protected void writeEntityBody(LogEntry logEntry, JsonGenerator jg) throws IOException {
        jg.writeNumberField("id", logEntry.getId());
        jg.writeStringField("category", logEntry.getCategory());
        jg.writeStringField("principalName", logEntry.getPrincipalName());
        jg.writeStringField("comment", logEntry.getComment());
        jg.writeStringField("docLifeCycle", logEntry.getDocLifeCycle());
        jg.writeStringField("docPath", logEntry.getDocPath());
        jg.writeStringField("docType", logEntry.getDocType());
        jg.writeStringField("docUUID", logEntry.getDocUUID());
        jg.writeStringField("eventId", logEntry.getEventId());
        jg.writeStringField("repositoryId", logEntry.getRepositoryId());
        DateTimeFormatter dateTime = ISODateTimeFormat.dateTime();
        jg.writeStringField("eventDate", dateTime.print((ReadableInstant)new DateTime((Object)logEntry.getEventDate())));
        jg.writeStringField("logDate", dateTime.print((ReadableInstant)new DateTime((Object)logEntry.getLogDate())));
        this.writeExtendedInfos(jg, logEntry);
    }

    protected void writeExtendedInfos(JsonGenerator jg, LogEntry logEntry) throws IOException {
        Map extended = logEntry.getExtendedInfos();
        jg.writeObjectFieldStart("extended");
        for (String key : extended.keySet()) {
            ExtendedInfo ei = (ExtendedInfo)extended.get(key);
            if (ei != null && ei.getSerializableValue() != null) {
                this.writeExtendedInfo(jg, key, ei.getSerializableValue());
                continue;
            }
            jg.writeNullField(key);
        }
        jg.writeEndObject();
    }

    protected void writeExtendedInfo(JsonGenerator jg, String key, Serializable value) throws IOException {
        Class<?> clazz = value.getClass();
        if (Long.class.isAssignableFrom(clazz)) {
            jg.writeNumberField(key, ((Long)value).longValue());
        } else if (Integer.class.isAssignableFrom(clazz)) {
            jg.writeNumberField(key, ((Integer)value).intValue());
        } else if (Double.class.isAssignableFrom(clazz)) {
            jg.writeNumberField(key, ((Double)value).doubleValue());
        } else if (Date.class.isAssignableFrom(clazz)) {
            jg.writeStringField(key, ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)value)));
        } else if (String.class.isAssignableFrom(clazz)) {
            jg.writeStringField(key, (String)((Object)value));
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            jg.writeBooleanField(key, ((Boolean)value).booleanValue());
        } else if (clazz.isArray() || List.class.isAssignableFrom(clazz)) {
            jg.writeObjectField(key, (Object)value);
        } else if (Map.class.isAssignableFrom(clazz)) {
            Map<String, Serializable> map = ((Map)((Object)value)).entrySet().stream().filter(entry -> entry.getValue() != null && ClassUtils.isPrimitiveOrWrapper(((Serializable)entry.getValue()).getClass())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            jg.writeObjectField(key, map);
        } else {
            jg.writeStringField(key, value.toString());
        }
    }
}

