/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.platform.audit.api.AuditStorage;
import org.nuxeo.ecm.platform.audit.api.DocumentHistoryReader;
import org.nuxeo.ecm.platform.audit.api.document.DocumentHistoryReaderImpl;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.AuditBulker;
import org.nuxeo.ecm.platform.audit.service.extension.AdapterDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.AuditBackendDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.AuditBulkerDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.AuditStorageDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.EventDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.ExtendedInfoDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.logging.DeprecationLogger;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class NXAuditEventsService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.audit.service.NXAuditEventsService");
    private static final String EVENT_EXT_POINT = "event";
    private static final String EXTENDED_INFO_EXT_POINT = "extendedInfo";
    private static final String ADAPTER_POINT = "adapter";
    public static final String DISABLE_AUDIT_LOGGER = "disableAuditLogger";
    protected static final Logger log = LogManager.getLogger(NXAuditEventsService.class);
    protected final Set<ExtendedInfoDescriptor> extendedInfoDescriptors = new HashSet<ExtendedInfoDescriptor>();
    protected final Map<String, List<ExtendedInfoDescriptor>> eventExtendedInfoDescriptors = new HashMap<String, List<ExtendedInfoDescriptor>>();
    protected final Set<AdapterDescriptor> documentAdapters = new HashSet<AdapterDescriptor>();
    protected final Set<String> eventNames = new HashSet<String>();
    protected AuditBackend backend;
    protected AuditBackendDescriptor backendConfig = new AuditBackendDescriptor();
    @Deprecated
    protected AuditBulker bulker;
    @Deprecated
    protected AuditBulkerDescriptor bulkerConfig = new AuditBulkerDescriptor();
    protected Map<String, AuditStorageDescriptor> auditStorageDescriptors = new HashMap<String, AuditStorageDescriptor>();
    protected Map<String, AuditStorage> auditStorages = new HashMap<String, AuditStorage>();

    public int getApplicationStartedOrder() {
        return this.backendConfig.getApplicationStartedOrder();
    }

    public void start(ComponentContext context) {
        this.backend = this.backendConfig.newInstance(this);
        this.backend.onApplicationStarted();
        if (Framework.isBooleanPropertyFalse((String)"nuxeo.stream.audit.enabled")) {
            this.bulker = this.bulkerConfig.newInstance(this.backend);
            this.bulker.onApplicationStarted();
        }
        Framework.getRuntime().getComponentManager().addListener(new ComponentManager.Listener(){

            public void afterStart(ComponentManager mgr, boolean isResume) {
                for (Map.Entry<String, AuditStorageDescriptor> descriptor : NXAuditEventsService.this.auditStorageDescriptors.entrySet()) {
                    AuditStorage storage = descriptor.getValue().newInstance();
                    if (storage instanceof AuditBackend) {
                        ((AuditBackend)storage).onApplicationStarted();
                    }
                    NXAuditEventsService.this.auditStorages.put(descriptor.getKey(), storage);
                }
            }

            public void afterStop(ComponentManager mgr, boolean isStandby) {
                this.uninstall();
            }
        });
    }

    public void stop(ComponentContext context) {
        try {
            if (this.bulker != null) {
                this.bulker.onApplicationStopped();
            }
        }
        finally {
            this.backend.onApplicationStopped();
            this.auditStorages.values().forEach(storage -> {
                if (storage instanceof AuditBackend) {
                    ((AuditBackend)storage).onApplicationStopped();
                }
            });
            this.auditStorages.clear();
        }
    }

    protected void doRegisterAdapter(AdapterDescriptor desc) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = desc::getName;
        log.debug("Registered adapter : {}", supplierArray);
        this.documentAdapters.add(desc);
    }

    protected void doRegisterEvent(EventDescriptor desc) {
        String eventName = desc.getName();
        if (desc.getEnabled()) {
            this.eventNames.add(eventName);
            log.debug("Registered event: {}", (Object)eventName);
            for (ExtendedInfoDescriptor extInfoDesc : desc.getExtendedInfoDescriptors()) {
                if (extInfoDesc.getEnabled()) {
                    if (this.eventExtendedInfoDescriptors.containsKey(eventName)) {
                        this.eventExtendedInfoDescriptors.get(eventName).add(extInfoDesc);
                        continue;
                    }
                    ArrayList<ExtendedInfoDescriptor> toBeAdded = new ArrayList<ExtendedInfoDescriptor>();
                    toBeAdded.add(extInfoDesc);
                    this.eventExtendedInfoDescriptors.put(eventName, toBeAdded);
                    continue;
                }
                if (!this.eventExtendedInfoDescriptors.containsKey(eventName)) continue;
                this.eventExtendedInfoDescriptors.get(eventName).remove(extInfoDesc);
            }
        } else if (this.eventNames.contains(eventName)) {
            this.doUnregisterEvent(desc);
        }
    }

    protected void doRegisterExtendedInfo(ExtendedInfoDescriptor desc) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = desc::getKey;
        log.debug("Registered extended info mapping : {}", supplierArray);
        this.extendedInfoDescriptors.add(desc);
    }

    protected void doUnregisterAdapter(AdapterDescriptor desc) {
        this.documentAdapters.remove(desc);
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = desc::getName;
        log.debug("Unregistered adapter: {}", supplierArray);
    }

    protected void doUnregisterEvent(EventDescriptor desc) {
        this.eventNames.remove(desc.getName());
        this.eventExtendedInfoDescriptors.remove(desc.getName());
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = desc::getName;
        log.debug("Unregistered event: {}", supplierArray);
    }

    protected void doUnregisterExtendedInfo(ExtendedInfoDescriptor desc) {
        this.extendedInfoDescriptors.remove(desc);
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = desc::getKey;
        log.debug("Unregistered extended info: {}", supplierArray);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.getCanonicalName().equals(DocumentHistoryReader.class.getCanonicalName())) {
            return adapter.cast(new DocumentHistoryReaderImpl());
        }
        if (this.backend != null) {
            return adapter.cast(this.backend);
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = adapter::getCanonicalName;
        log.error("Can not provide service {} since backend is undefined", supplierArray);
        return null;
    }

    public Set<String> getAuditableEventNames() {
        return this.eventNames;
    }

    public AuditBackend getBackend() {
        return this.backend;
    }

    public Set<AdapterDescriptor> getDocumentAdapters() {
        return this.documentAdapters;
    }

    public Map<String, List<ExtendedInfoDescriptor>> getEventExtendedInfoDescriptors() {
        return this.eventExtendedInfoDescriptors;
    }

    public Set<ExtendedInfoDescriptor> getExtendedInfoDescriptors() {
        return this.extendedInfoDescriptors;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(EVENT_EXT_POINT)) {
            this.doRegisterEvent((EventDescriptor)contribution);
        } else if (extensionPoint.equals(EXTENDED_INFO_EXT_POINT)) {
            this.doRegisterExtendedInfo((ExtendedInfoDescriptor)contribution);
        } else if (extensionPoint.equals(ADAPTER_POINT)) {
            this.doRegisterAdapter((AdapterDescriptor)contribution);
        } else if (contribution instanceof AuditBackendDescriptor) {
            this.backendConfig = (AuditBackendDescriptor)contribution;
        } else if (contribution instanceof AuditBulkerDescriptor) {
            this.bulkerConfig = (AuditBulkerDescriptor)contribution;
            String message = String.format("AuditBulker on component %s is deprecated because it is now handled with nuxeo-stream, no replacement.", contributor.getName());
            DeprecationLogger.log((String)message, (String)"10.10");
            Framework.getRuntime().getMessageHandler().addWarning(message);
        } else if (contribution instanceof AuditStorageDescriptor) {
            AuditStorageDescriptor auditStorageDesc = (AuditStorageDescriptor)contribution;
            this.auditStorageDescriptors.put(auditStorageDesc.getId(), auditStorageDesc);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(EVENT_EXT_POINT)) {
            this.doUnregisterEvent((EventDescriptor)contribution);
        } else if (extensionPoint.equals(EXTENDED_INFO_EXT_POINT)) {
            this.doUnregisterExtendedInfo((ExtendedInfoDescriptor)contribution);
        } else if (extensionPoint.equals(ADAPTER_POINT)) {
            this.doUnregisterAdapter((AdapterDescriptor)contribution);
        }
    }

    public AuditStorage getAuditStorage(String id) {
        return this.auditStorages.get(id);
    }
}

