/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webengine.model.exceptions.IllegalParameterException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

@Operation(id="Document.AddPermission", category="Document", label="Add Permission", description="Add Permission on the input document(s). Returns the document(s).", aliases={"Document.AddACL"})
public class AddPermission {
    public static final String ID = "Document.AddPermission";
    public static final String NOTIFY_KEY = "notify";
    public static final String COMMENT_KEY = "comment";
    public static final String ALLOW_VIRTUAL_USER = "nuxeo.automation.allowVirtualUser";
    @Context
    protected CoreSession session;
    @Param(name="users", required=false, alias={"users"}, description="ACE target set of users and/or groups.")
    protected List<String> users;
    @Deprecated
    @Param(name="username", required=false, alias={"user"}, description="ACE target user/group.")
    protected String user;
    @Param(name="email", required=false, description="ACE target user/group.")
    protected String email;
    @Param(name="permission", description="ACE permission.")
    protected String permission;
    @Param(name="acl", required=false, values={"local"}, description="ACL name.")
    protected String aclName = "local";
    @Param(name="begin", required=false, description="ACE begin date.")
    protected Calendar begin;
    @Param(name="end", required=false, description="ACE end date.")
    protected Calendar end;
    @Param(name="blockInheritance", required=false, description="Block inheritance or not.")
    protected boolean blockInheritance = false;
    @Param(name="notify", required=false, description="Notify the user or not")
    protected boolean notify = false;
    @Param(name="comment", required=false, description="Comment")
    protected String comment;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        this.validateParameters();
        this.addPermission(doc);
        return doc;
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef docRef) {
        DocumentModel doc = this.session.getDocument(docRef);
        this.validateParameters();
        this.addPermission(doc);
        return doc;
    }

    protected void addPermission(DocumentModel doc) {
        ACP acp = doc.getACP() != null ? doc.getACP() : new ACPImpl();
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put(NOTIFY_KEY, this.notify);
        contextData.put(COMMENT_KEY, this.comment);
        String creator = this.session.getPrincipal().getName();
        boolean permissionChanged = false;
        if (this.blockInheritance) {
            permissionChanged = acp.blockInheritance(this.aclName, creator);
        }
        for (String username : this.users) {
            ACE ace = ACE.builder((String)username, (String)this.permission).creator(creator).begin(this.begin).end(this.end).contextData(contextData).build();
            permissionChanged = acp.addACE(this.aclName, ace) || permissionChanged;
        }
        if (permissionChanged) {
            doc.setACP(acp, true);
        }
    }

    protected void validateParameters() {
        if (this.user == null && (this.users == null || this.users.isEmpty()) && this.email == null) {
            throw new IllegalParameterException("'users' or 'email' parameters must be set");
        }
        if (this.email != null && this.end == null) {
            throw new IllegalParameterException("'end' parameter must be set when adding a permission for an 'email'");
        }
        this.ensureUserListIsUsed();
        ConfigurationService configService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        if (configService.isBooleanPropertyFalse(ALLOW_VIRTUAL_USER)) {
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            List unknownNames = this.users.stream().filter(userOrGroupName -> !NuxeoPrincipal.isTransientUsername((String)userOrGroupName) && userManager.getUserModel(userOrGroupName) == null && userManager.getGroupModel(userOrGroupName) == null).collect(Collectors.toList());
            if (!unknownNames.isEmpty()) {
                String errorMsg = String.format("The following set of User or Group names do not exist: [%s]. Please provide valid ones.", String.join((CharSequence)",", unknownNames));
                throw new IllegalParameterException(errorMsg);
            }
        }
    }

    protected void ensureUserListIsUsed() {
        List<String> list = this.users = this.users == null ? new ArrayList<String>() : new ArrayList<String>(this.users);
        if (this.user != null && !this.users.contains(this.user)) {
            this.users.add(this.user);
        } else if (this.email != null && this.users.isEmpty()) {
            this.users.add(NuxeoPrincipal.computeTransientUsername((String)this.email));
        }
    }
}

